/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceContainerFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int UUIDCAPACITYINPUT;
    public static final int UUIDCOUNTOUTPUT;
    public static final int UUIDS;

    public XrSpaceContainerFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceContainerFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceContainerFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceContainerFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int uuidCapacityInput() {
        return XrSpaceContainerFB.nuuidCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int uuidCountOutput() {
        return XrSpaceContainerFB.nuuidCountOutput(this.address());
    }

    @Nullable
    @NativeType(value="XrUuidEXT *")
    public XrUuidEXT.Buffer uuids() {
        return XrSpaceContainerFB.nuuids(this.address());
    }

    public XrSpaceContainerFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceContainerFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceContainerFB type$Default() {
        return this.type(1000199000);
    }

    public XrSpaceContainerFB next(@NativeType(value="void const *") long value) {
        XrSpaceContainerFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceContainerFB uuidCapacityInput(@NativeType(value="uint32_t") int value) {
        XrSpaceContainerFB.nuuidCapacityInput(this.address(), value);
        return this;
    }

    public XrSpaceContainerFB uuidCountOutput(@NativeType(value="uint32_t") int value) {
        XrSpaceContainerFB.nuuidCountOutput(this.address(), value);
        return this;
    }

    public XrSpaceContainerFB uuids(@Nullable @NativeType(value="XrUuidEXT *") XrUuidEXT.Buffer value) {
        XrSpaceContainerFB.nuuids(this.address(), value);
        return this;
    }

    public XrSpaceContainerFB set(int type, long next, int uuidCapacityInput, int uuidCountOutput, @Nullable XrUuidEXT.Buffer uuids) {
        this.type(type);
        this.next(next);
        this.uuidCapacityInput(uuidCapacityInput);
        this.uuidCountOutput(uuidCountOutput);
        this.uuids(uuids);
        return this;
    }

    public XrSpaceContainerFB set(XrSpaceContainerFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpaceContainerFB malloc() {
        return (XrSpaceContainerFB)XrSpaceContainerFB.wrap(XrSpaceContainerFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSpaceContainerFB calloc() {
        return (XrSpaceContainerFB)XrSpaceContainerFB.wrap(XrSpaceContainerFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSpaceContainerFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSpaceContainerFB)XrSpaceContainerFB.wrap(XrSpaceContainerFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSpaceContainerFB create(long address) {
        return (XrSpaceContainerFB)XrSpaceContainerFB.wrap(XrSpaceContainerFB.class, (long)address);
    }

    @Nullable
    public static XrSpaceContainerFB createSafe(long address) {
        return address == 0L ? null : (XrSpaceContainerFB)XrSpaceContainerFB.wrap(XrSpaceContainerFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSpaceContainerFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSpaceContainerFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSpaceContainerFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceContainerFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSpaceContainerFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSpaceContainerFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSpaceContainerFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSpaceContainerFB malloc(MemoryStack stack) {
        return (XrSpaceContainerFB)XrSpaceContainerFB.wrap(XrSpaceContainerFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSpaceContainerFB calloc(MemoryStack stack) {
        return (XrSpaceContainerFB)XrSpaceContainerFB.wrap(XrSpaceContainerFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSpaceContainerFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSpaceContainerFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nuuidCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)UUIDCAPACITYINPUT);
    }

    public static int nuuidCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)UUIDCOUNTOUTPUT);
    }

    @Nullable
    public static XrUuidEXT.Buffer nuuids(long struct) {
        return XrUuidEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)UUIDS)), XrSpaceContainerFB.nuuidCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nuuidCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UUIDCAPACITYINPUT, value);
    }

    public static void nuuidCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UUIDCOUNTOUTPUT, value);
    }

    public static void nuuids(long struct, @Nullable XrUuidEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)UUIDS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrSpaceContainerFB.nuuidCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSpaceContainerFB.__struct((Struct.Member[])new Struct.Member[]{XrSpaceContainerFB.__member((int)4), XrSpaceContainerFB.__member((int)POINTER_SIZE), XrSpaceContainerFB.__member((int)4), XrSpaceContainerFB.__member((int)4), XrSpaceContainerFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        UUIDCAPACITYINPUT = layout.offsetof(2);
        UUIDCOUNTOUTPUT = layout.offsetof(3);
        UUIDS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceContainerFB, Buffer>
    implements NativeResource {
        private static final XrSpaceContainerFB ELEMENT_FACTORY = XrSpaceContainerFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpaceContainerFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceContainerFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceContainerFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int uuidCapacityInput() {
            return XrSpaceContainerFB.nuuidCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int uuidCountOutput() {
            return XrSpaceContainerFB.nuuidCountOutput(this.address());
        }

        @Nullable
        @NativeType(value="XrUuidEXT *")
        public XrUuidEXT.Buffer uuids() {
            return XrSpaceContainerFB.nuuids(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceContainerFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000199000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceContainerFB.nnext(this.address(), value);
            return this;
        }

        public Buffer uuidCapacityInput(@NativeType(value="uint32_t") int value) {
            XrSpaceContainerFB.nuuidCapacityInput(this.address(), value);
            return this;
        }

        public Buffer uuidCountOutput(@NativeType(value="uint32_t") int value) {
            XrSpaceContainerFB.nuuidCountOutput(this.address(), value);
            return this;
        }

        public Buffer uuids(@Nullable @NativeType(value="XrUuidEXT *") XrUuidEXT.Buffer value) {
            XrSpaceContainerFB.nuuids(this.address(), value);
            return this;
        }
    }
}

