/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceEraseInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACE;
    public static final int LOCATION;

    public XrSpaceEraseInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceEraseInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceEraseInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceEraseInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSpaceEraseInfoFB.nspace(this.address());
    }

    @NativeType(value="XrSpaceStorageLocationFB")
    public int location() {
        return XrSpaceEraseInfoFB.nlocation(this.address());
    }

    public XrSpaceEraseInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceEraseInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB type$Default() {
        return this.type(1000158001);
    }

    public XrSpaceEraseInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceEraseInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB space(XrSpace value) {
        XrSpaceEraseInfoFB.nspace(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
        XrSpaceEraseInfoFB.nlocation(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB set(int type, long next, XrSpace space, int location) {
        this.type(type);
        this.next(next);
        this.space(space);
        this.location(location);
        return this;
    }

    public XrSpaceEraseInfoFB set(XrSpaceEraseInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpaceEraseInfoFB malloc() {
        return (XrSpaceEraseInfoFB)XrSpaceEraseInfoFB.wrap(XrSpaceEraseInfoFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSpaceEraseInfoFB calloc() {
        return (XrSpaceEraseInfoFB)XrSpaceEraseInfoFB.wrap(XrSpaceEraseInfoFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSpaceEraseInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSpaceEraseInfoFB)XrSpaceEraseInfoFB.wrap(XrSpaceEraseInfoFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSpaceEraseInfoFB create(long address) {
        return (XrSpaceEraseInfoFB)XrSpaceEraseInfoFB.wrap(XrSpaceEraseInfoFB.class, (long)address);
    }

    @Nullable
    public static XrSpaceEraseInfoFB createSafe(long address) {
        return address == 0L ? null : (XrSpaceEraseInfoFB)XrSpaceEraseInfoFB.wrap(XrSpaceEraseInfoFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSpaceEraseInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSpaceEraseInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSpaceEraseInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceEraseInfoFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSpaceEraseInfoFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSpaceEraseInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSpaceEraseInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSpaceEraseInfoFB malloc(MemoryStack stack) {
        return (XrSpaceEraseInfoFB)XrSpaceEraseInfoFB.wrap(XrSpaceEraseInfoFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSpaceEraseInfoFB calloc(MemoryStack stack) {
        return (XrSpaceEraseInfoFB)XrSpaceEraseInfoFB.wrap(XrSpaceEraseInfoFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSpaceEraseInfoFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSpaceEraseInfoFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static int nlocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATION);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void nlocation(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOCATION, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
    }

    static {
        Struct.Layout layout = XrSpaceEraseInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrSpaceEraseInfoFB.__member((int)4), XrSpaceEraseInfoFB.__member((int)POINTER_SIZE), XrSpaceEraseInfoFB.__member((int)POINTER_SIZE), XrSpaceEraseInfoFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACE = layout.offsetof(2);
        LOCATION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceEraseInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceEraseInfoFB ELEMENT_FACTORY = XrSpaceEraseInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpaceEraseInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceEraseInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceEraseInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSpaceEraseInfoFB.nspace(this.address());
        }

        @NativeType(value="XrSpaceStorageLocationFB")
        public int location() {
            return XrSpaceEraseInfoFB.nlocation(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceEraseInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000158001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceEraseInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrSpaceEraseInfoFB.nspace(this.address(), value);
            return this;
        }

        public Buffer location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
            XrSpaceEraseInfoFB.nlocation(this.address(), value);
            return this;
        }
    }
}

