/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpaceFilterInfoBaseHeaderFB;
import org.lwjgl.openxr.XrSpaceQueryInfoBaseHeaderFB;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceQueryInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int QUERYACTION;
    public static final int MAXRESULTCOUNT;
    public static final int TIMEOUT;
    public static final int FILTER;
    public static final int EXCLUDEFILTER;

    public XrSpaceQueryInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceQueryInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceQueryInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceQueryInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSpaceQueryActionFB")
    public int queryAction() {
        return XrSpaceQueryInfoFB.nqueryAction(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxResultCount() {
        return XrSpaceQueryInfoFB.nmaxResultCount(this.address());
    }

    @NativeType(value="XrDuration")
    public long timeout() {
        return XrSpaceQueryInfoFB.ntimeout(this.address());
    }

    @Nullable
    @NativeType(value="XrSpaceFilterInfoBaseHeaderFB const *")
    public XrSpaceFilterInfoBaseHeaderFB filter() {
        return XrSpaceQueryInfoFB.nfilter(this.address());
    }

    @Nullable
    @NativeType(value="XrSpaceFilterInfoBaseHeaderFB const *")
    public XrSpaceFilterInfoBaseHeaderFB excludeFilter() {
        return XrSpaceQueryInfoFB.nexcludeFilter(this.address());
    }

    public XrSpaceQueryInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceQueryInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceQueryInfoFB type$Default() {
        return this.type(1000156001);
    }

    public XrSpaceQueryInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceQueryInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceQueryInfoFB queryAction(@NativeType(value="XrSpaceQueryActionFB") int value) {
        XrSpaceQueryInfoFB.nqueryAction(this.address(), value);
        return this;
    }

    public XrSpaceQueryInfoFB maxResultCount(@NativeType(value="uint32_t") int value) {
        XrSpaceQueryInfoFB.nmaxResultCount(this.address(), value);
        return this;
    }

    public XrSpaceQueryInfoFB timeout(@NativeType(value="XrDuration") long value) {
        XrSpaceQueryInfoFB.ntimeout(this.address(), value);
        return this;
    }

    public XrSpaceQueryInfoFB filter(@Nullable @NativeType(value="XrSpaceFilterInfoBaseHeaderFB const *") XrSpaceFilterInfoBaseHeaderFB value) {
        XrSpaceQueryInfoFB.nfilter(this.address(), value);
        return this;
    }

    public XrSpaceQueryInfoFB excludeFilter(@Nullable @NativeType(value="XrSpaceFilterInfoBaseHeaderFB const *") XrSpaceFilterInfoBaseHeaderFB value) {
        XrSpaceQueryInfoFB.nexcludeFilter(this.address(), value);
        return this;
    }

    public XrSpaceQueryInfoFB set(int type, long next, int queryAction, int maxResultCount, long timeout, @Nullable XrSpaceFilterInfoBaseHeaderFB filter, @Nullable XrSpaceFilterInfoBaseHeaderFB excludeFilter) {
        this.type(type);
        this.next(next);
        this.queryAction(queryAction);
        this.maxResultCount(maxResultCount);
        this.timeout(timeout);
        this.filter(filter);
        this.excludeFilter(excludeFilter);
        return this;
    }

    public XrSpaceQueryInfoFB set(XrSpaceQueryInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpaceQueryInfoFB malloc() {
        return (XrSpaceQueryInfoFB)XrSpaceQueryInfoFB.wrap(XrSpaceQueryInfoFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSpaceQueryInfoFB calloc() {
        return (XrSpaceQueryInfoFB)XrSpaceQueryInfoFB.wrap(XrSpaceQueryInfoFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSpaceQueryInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSpaceQueryInfoFB)XrSpaceQueryInfoFB.wrap(XrSpaceQueryInfoFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSpaceQueryInfoFB create(long address) {
        return (XrSpaceQueryInfoFB)XrSpaceQueryInfoFB.wrap(XrSpaceQueryInfoFB.class, (long)address);
    }

    @Nullable
    public static XrSpaceQueryInfoFB createSafe(long address) {
        return address == 0L ? null : (XrSpaceQueryInfoFB)XrSpaceQueryInfoFB.wrap(XrSpaceQueryInfoFB.class, (long)address);
    }

    public static XrSpaceQueryInfoFB create(XrSpaceQueryInfoBaseHeaderFB value) {
        return (XrSpaceQueryInfoFB)XrSpaceQueryInfoFB.wrap(XrSpaceQueryInfoFB.class, (Struct)value);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSpaceQueryInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSpaceQueryInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSpaceQueryInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceQueryInfoFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSpaceQueryInfoFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSpaceQueryInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSpaceQueryInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static Buffer create(XrSpaceQueryInfoBaseHeaderFB.Buffer value) {
        return (Buffer)XrSpaceQueryInfoFB.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static XrSpaceQueryInfoFB malloc(MemoryStack stack) {
        return (XrSpaceQueryInfoFB)XrSpaceQueryInfoFB.wrap(XrSpaceQueryInfoFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSpaceQueryInfoFB calloc(MemoryStack stack) {
        return (XrSpaceQueryInfoFB)XrSpaceQueryInfoFB.wrap(XrSpaceQueryInfoFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSpaceQueryInfoFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSpaceQueryInfoFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nqueryAction(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUERYACTION);
    }

    public static int nmaxResultCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXRESULTCOUNT);
    }

    public static long ntimeout(long struct) {
        return UNSAFE.getLong(null, struct + (long)TIMEOUT);
    }

    @Nullable
    public static XrSpaceFilterInfoBaseHeaderFB nfilter(long struct) {
        return XrSpaceFilterInfoBaseHeaderFB.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)FILTER)));
    }

    @Nullable
    public static XrSpaceFilterInfoBaseHeaderFB nexcludeFilter(long struct) {
        return XrSpaceFilterInfoBaseHeaderFB.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)EXCLUDEFILTER)));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nqueryAction(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUERYACTION, value);
    }

    public static void nmaxResultCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXRESULTCOUNT, value);
    }

    public static void ntimeout(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TIMEOUT, value);
    }

    public static void nfilter(long struct, @Nullable XrSpaceFilterInfoBaseHeaderFB value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FILTER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nexcludeFilter(long struct, @Nullable XrSpaceFilterInfoBaseHeaderFB value) {
        MemoryUtil.memPutAddress((long)(struct + (long)EXCLUDEFILTER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = XrSpaceQueryInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrSpaceQueryInfoFB.__member((int)4), XrSpaceQueryInfoFB.__member((int)POINTER_SIZE), XrSpaceQueryInfoFB.__member((int)4), XrSpaceQueryInfoFB.__member((int)4), XrSpaceQueryInfoFB.__member((int)8), XrSpaceQueryInfoFB.__member((int)POINTER_SIZE), XrSpaceQueryInfoFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        QUERYACTION = layout.offsetof(2);
        MAXRESULTCOUNT = layout.offsetof(3);
        TIMEOUT = layout.offsetof(4);
        FILTER = layout.offsetof(5);
        EXCLUDEFILTER = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceQueryInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceQueryInfoFB ELEMENT_FACTORY = XrSpaceQueryInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpaceQueryInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceQueryInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceQueryInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSpaceQueryActionFB")
        public int queryAction() {
            return XrSpaceQueryInfoFB.nqueryAction(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxResultCount() {
            return XrSpaceQueryInfoFB.nmaxResultCount(this.address());
        }

        @NativeType(value="XrDuration")
        public long timeout() {
            return XrSpaceQueryInfoFB.ntimeout(this.address());
        }

        @Nullable
        @NativeType(value="XrSpaceFilterInfoBaseHeaderFB const *")
        public XrSpaceFilterInfoBaseHeaderFB filter() {
            return XrSpaceQueryInfoFB.nfilter(this.address());
        }

        @Nullable
        @NativeType(value="XrSpaceFilterInfoBaseHeaderFB const *")
        public XrSpaceFilterInfoBaseHeaderFB excludeFilter() {
            return XrSpaceQueryInfoFB.nexcludeFilter(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceQueryInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000156001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceQueryInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer queryAction(@NativeType(value="XrSpaceQueryActionFB") int value) {
            XrSpaceQueryInfoFB.nqueryAction(this.address(), value);
            return this;
        }

        public Buffer maxResultCount(@NativeType(value="uint32_t") int value) {
            XrSpaceQueryInfoFB.nmaxResultCount(this.address(), value);
            return this;
        }

        public Buffer timeout(@NativeType(value="XrDuration") long value) {
            XrSpaceQueryInfoFB.ntimeout(this.address(), value);
            return this;
        }

        public Buffer filter(@Nullable @NativeType(value="XrSpaceFilterInfoBaseHeaderFB const *") XrSpaceFilterInfoBaseHeaderFB value) {
            XrSpaceQueryInfoFB.nfilter(this.address(), value);
            return this;
        }

        public Buffer excludeFilter(@Nullable @NativeType(value="XrSpaceFilterInfoBaseHeaderFB const *") XrSpaceFilterInfoBaseHeaderFB value) {
            XrSpaceQueryInfoFB.nexcludeFilter(this.address(), value);
            return this;
        }
    }
}

