/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceSaveInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACE;
    public static final int LOCATION;
    public static final int PERSISTENCEMODE;

    public XrSpaceSaveInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceSaveInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceSaveInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceSaveInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSpaceSaveInfoFB.nspace(this.address());
    }

    @NativeType(value="XrSpaceStorageLocationFB")
    public int location() {
        return XrSpaceSaveInfoFB.nlocation(this.address());
    }

    @NativeType(value="XrSpacePersistenceModeFB")
    public int persistenceMode() {
        return XrSpaceSaveInfoFB.npersistenceMode(this.address());
    }

    public XrSpaceSaveInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceSaveInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceSaveInfoFB type$Default() {
        return this.type(1000158000);
    }

    public XrSpaceSaveInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceSaveInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceSaveInfoFB space(XrSpace value) {
        XrSpaceSaveInfoFB.nspace(this.address(), value);
        return this;
    }

    public XrSpaceSaveInfoFB location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
        XrSpaceSaveInfoFB.nlocation(this.address(), value);
        return this;
    }

    public XrSpaceSaveInfoFB persistenceMode(@NativeType(value="XrSpacePersistenceModeFB") int value) {
        XrSpaceSaveInfoFB.npersistenceMode(this.address(), value);
        return this;
    }

    public XrSpaceSaveInfoFB set(int type, long next, XrSpace space, int location, int persistenceMode) {
        this.type(type);
        this.next(next);
        this.space(space);
        this.location(location);
        this.persistenceMode(persistenceMode);
        return this;
    }

    public XrSpaceSaveInfoFB set(XrSpaceSaveInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpaceSaveInfoFB malloc() {
        return (XrSpaceSaveInfoFB)XrSpaceSaveInfoFB.wrap(XrSpaceSaveInfoFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSpaceSaveInfoFB calloc() {
        return (XrSpaceSaveInfoFB)XrSpaceSaveInfoFB.wrap(XrSpaceSaveInfoFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSpaceSaveInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSpaceSaveInfoFB)XrSpaceSaveInfoFB.wrap(XrSpaceSaveInfoFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSpaceSaveInfoFB create(long address) {
        return (XrSpaceSaveInfoFB)XrSpaceSaveInfoFB.wrap(XrSpaceSaveInfoFB.class, (long)address);
    }

    @Nullable
    public static XrSpaceSaveInfoFB createSafe(long address) {
        return address == 0L ? null : (XrSpaceSaveInfoFB)XrSpaceSaveInfoFB.wrap(XrSpaceSaveInfoFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSpaceSaveInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSpaceSaveInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSpaceSaveInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceSaveInfoFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSpaceSaveInfoFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSpaceSaveInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSpaceSaveInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSpaceSaveInfoFB malloc(MemoryStack stack) {
        return (XrSpaceSaveInfoFB)XrSpaceSaveInfoFB.wrap(XrSpaceSaveInfoFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSpaceSaveInfoFB calloc(MemoryStack stack) {
        return (XrSpaceSaveInfoFB)XrSpaceSaveInfoFB.wrap(XrSpaceSaveInfoFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSpaceSaveInfoFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSpaceSaveInfoFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static int nlocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATION);
    }

    public static int npersistenceMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)PERSISTENCEMODE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void nlocation(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOCATION, value);
    }

    public static void npersistenceMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PERSISTENCEMODE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
    }

    static {
        Struct.Layout layout = XrSpaceSaveInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrSpaceSaveInfoFB.__member((int)4), XrSpaceSaveInfoFB.__member((int)POINTER_SIZE), XrSpaceSaveInfoFB.__member((int)POINTER_SIZE), XrSpaceSaveInfoFB.__member((int)4), XrSpaceSaveInfoFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACE = layout.offsetof(2);
        LOCATION = layout.offsetof(3);
        PERSISTENCEMODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceSaveInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceSaveInfoFB ELEMENT_FACTORY = XrSpaceSaveInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpaceSaveInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceSaveInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceSaveInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSpaceSaveInfoFB.nspace(this.address());
        }

        @NativeType(value="XrSpaceStorageLocationFB")
        public int location() {
            return XrSpaceSaveInfoFB.nlocation(this.address());
        }

        @NativeType(value="XrSpacePersistenceModeFB")
        public int persistenceMode() {
            return XrSpaceSaveInfoFB.npersistenceMode(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceSaveInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000158000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceSaveInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrSpaceSaveInfoFB.nspace(this.address(), value);
            return this;
        }

        public Buffer location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
            XrSpaceSaveInfoFB.nlocation(this.address(), value);
            return this;
        }

        public Buffer persistenceMode(@NativeType(value="XrSpacePersistenceModeFB") int value) {
            XrSpaceSaveInfoFB.npersistenceMode(this.address(), value);
            return this;
        }
    }
}

