/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceShareInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACECOUNT;
    public static final int SPACES;
    public static final int USERCOUNT;
    public static final int USERS;

    public XrSpaceShareInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceShareInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceShareInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceShareInfoFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int spaceCount() {
        return XrSpaceShareInfoFB.nspaceCount(this.address());
    }

    @NativeType(value="XrSpace *")
    public PointerBuffer spaces() {
        return XrSpaceShareInfoFB.nspaces(this.address());
    }

    @NativeType(value="uint32_t")
    public int userCount() {
        return XrSpaceShareInfoFB.nuserCount(this.address());
    }

    @NativeType(value="XrSpaceUserFB *")
    public PointerBuffer users() {
        return XrSpaceShareInfoFB.nusers(this.address());
    }

    public XrSpaceShareInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceShareInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceShareInfoFB type$Default() {
        return this.type(1000169001);
    }

    public XrSpaceShareInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceShareInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceShareInfoFB spaces(@NativeType(value="XrSpace *") PointerBuffer value) {
        XrSpaceShareInfoFB.nspaces(this.address(), value);
        return this;
    }

    public XrSpaceShareInfoFB users(@NativeType(value="XrSpaceUserFB *") PointerBuffer value) {
        XrSpaceShareInfoFB.nusers(this.address(), value);
        return this;
    }

    public XrSpaceShareInfoFB set(int type, long next, PointerBuffer spaces, PointerBuffer users) {
        this.type(type);
        this.next(next);
        this.spaces(spaces);
        this.users(users);
        return this;
    }

    public XrSpaceShareInfoFB set(XrSpaceShareInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpaceShareInfoFB malloc() {
        return (XrSpaceShareInfoFB)XrSpaceShareInfoFB.wrap(XrSpaceShareInfoFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSpaceShareInfoFB calloc() {
        return (XrSpaceShareInfoFB)XrSpaceShareInfoFB.wrap(XrSpaceShareInfoFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSpaceShareInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSpaceShareInfoFB)XrSpaceShareInfoFB.wrap(XrSpaceShareInfoFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSpaceShareInfoFB create(long address) {
        return (XrSpaceShareInfoFB)XrSpaceShareInfoFB.wrap(XrSpaceShareInfoFB.class, (long)address);
    }

    @Nullable
    public static XrSpaceShareInfoFB createSafe(long address) {
        return address == 0L ? null : (XrSpaceShareInfoFB)XrSpaceShareInfoFB.wrap(XrSpaceShareInfoFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSpaceShareInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSpaceShareInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSpaceShareInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceShareInfoFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSpaceShareInfoFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSpaceShareInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSpaceShareInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSpaceShareInfoFB malloc(MemoryStack stack) {
        return (XrSpaceShareInfoFB)XrSpaceShareInfoFB.wrap(XrSpaceShareInfoFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSpaceShareInfoFB calloc(MemoryStack stack) {
        return (XrSpaceShareInfoFB)XrSpaceShareInfoFB.wrap(XrSpaceShareInfoFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSpaceShareInfoFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSpaceShareInfoFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nspaceCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SPACECOUNT);
    }

    public static PointerBuffer nspaces(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACES)), (int)XrSpaceShareInfoFB.nspaceCount(struct));
    }

    public static int nuserCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)USERCOUNT);
    }

    public static PointerBuffer nusers(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)USERS)), (int)XrSpaceShareInfoFB.nuserCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nspaceCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SPACECOUNT, value);
    }

    public static void nspaces(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACES), (long)MemoryUtil.memAddress((CustomBuffer)value));
        XrSpaceShareInfoFB.nspaceCount(struct, value.remaining());
    }

    public static void nuserCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)USERCOUNT, value);
    }

    public static void nusers(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERS), (long)MemoryUtil.memAddress((CustomBuffer)value));
        XrSpaceShareInfoFB.nuserCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACES)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)USERS)));
    }

    static {
        Struct.Layout layout = XrSpaceShareInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrSpaceShareInfoFB.__member((int)4), XrSpaceShareInfoFB.__member((int)POINTER_SIZE), XrSpaceShareInfoFB.__member((int)4), XrSpaceShareInfoFB.__member((int)POINTER_SIZE), XrSpaceShareInfoFB.__member((int)4), XrSpaceShareInfoFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACECOUNT = layout.offsetof(2);
        SPACES = layout.offsetof(3);
        USERCOUNT = layout.offsetof(4);
        USERS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceShareInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceShareInfoFB ELEMENT_FACTORY = XrSpaceShareInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpaceShareInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceShareInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceShareInfoFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int spaceCount() {
            return XrSpaceShareInfoFB.nspaceCount(this.address());
        }

        @NativeType(value="XrSpace *")
        public PointerBuffer spaces() {
            return XrSpaceShareInfoFB.nspaces(this.address());
        }

        @NativeType(value="uint32_t")
        public int userCount() {
            return XrSpaceShareInfoFB.nuserCount(this.address());
        }

        @NativeType(value="XrSpaceUserFB *")
        public PointerBuffer users() {
            return XrSpaceShareInfoFB.nusers(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceShareInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000169001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceShareInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer spaces(@NativeType(value="XrSpace *") PointerBuffer value) {
            XrSpaceShareInfoFB.nspaces(this.address(), value);
            return this;
        }

        public Buffer users(@NativeType(value="XrSpaceUserFB *") PointerBuffer value) {
            XrSpaceShareInfoFB.nusers(this.address(), value);
            return this;
        }
    }
}

