/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSecondaryViewConfigurationSwapchainCreateInfoMSFT;
import org.lwjgl.openxr.XrSwapchainCreateInfoFoveationFB;
import org.lwjgl.openxr.XrVulkanSwapchainCreateInfoMETA;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSwapchainCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CREATEFLAGS;
    public static final int USAGEFLAGS;
    public static final int FORMAT;
    public static final int SAMPLECOUNT;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int FACECOUNT;
    public static final int ARRAYSIZE;
    public static final int MIPCOUNT;

    public XrSwapchainCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSwapchainCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSwapchainCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSwapchainCreateInfo.nnext(this.address());
    }

    @NativeType(value="XrSwapchainCreateFlags")
    public long createFlags() {
        return XrSwapchainCreateInfo.ncreateFlags(this.address());
    }

    @NativeType(value="XrSwapchainUsageFlags")
    public long usageFlags() {
        return XrSwapchainCreateInfo.nusageFlags(this.address());
    }

    @NativeType(value="int64_t")
    public long format() {
        return XrSwapchainCreateInfo.nformat(this.address());
    }

    @NativeType(value="uint32_t")
    public int sampleCount() {
        return XrSwapchainCreateInfo.nsampleCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int width() {
        return XrSwapchainCreateInfo.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return XrSwapchainCreateInfo.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int faceCount() {
        return XrSwapchainCreateInfo.nfaceCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int arraySize() {
        return XrSwapchainCreateInfo.narraySize(this.address());
    }

    @NativeType(value="uint32_t")
    public int mipCount() {
        return XrSwapchainCreateInfo.nmipCount(this.address());
    }

    public XrSwapchainCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrSwapchainCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo type$Default() {
        return this.type(9);
    }

    public XrSwapchainCreateInfo next(@NativeType(value="void const *") long value) {
        XrSwapchainCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo next(XrSecondaryViewConfigurationSwapchainCreateInfoMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSwapchainCreateInfo next(XrSwapchainCreateInfoFoveationFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSwapchainCreateInfo next(XrVulkanSwapchainCreateInfoMETA value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSwapchainCreateInfo createFlags(@NativeType(value="XrSwapchainCreateFlags") long value) {
        XrSwapchainCreateInfo.ncreateFlags(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo usageFlags(@NativeType(value="XrSwapchainUsageFlags") long value) {
        XrSwapchainCreateInfo.nusageFlags(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo format(@NativeType(value="int64_t") long value) {
        XrSwapchainCreateInfo.nformat(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo sampleCount(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.nsampleCount(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo width(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.nwidth(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo height(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.nheight(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo faceCount(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.nfaceCount(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo arraySize(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.narraySize(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo mipCount(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.nmipCount(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo set(int type, long next, long createFlags, long usageFlags, long format, int sampleCount, int width, int height, int faceCount, int arraySize, int mipCount) {
        this.type(type);
        this.next(next);
        this.createFlags(createFlags);
        this.usageFlags(usageFlags);
        this.format(format);
        this.sampleCount(sampleCount);
        this.width(width);
        this.height(height);
        this.faceCount(faceCount);
        this.arraySize(arraySize);
        this.mipCount(mipCount);
        return this;
    }

    public XrSwapchainCreateInfo set(XrSwapchainCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSwapchainCreateInfo malloc() {
        return (XrSwapchainCreateInfo)XrSwapchainCreateInfo.wrap(XrSwapchainCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSwapchainCreateInfo calloc() {
        return (XrSwapchainCreateInfo)XrSwapchainCreateInfo.wrap(XrSwapchainCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSwapchainCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSwapchainCreateInfo)XrSwapchainCreateInfo.wrap(XrSwapchainCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSwapchainCreateInfo create(long address) {
        return (XrSwapchainCreateInfo)XrSwapchainCreateInfo.wrap(XrSwapchainCreateInfo.class, (long)address);
    }

    @Nullable
    public static XrSwapchainCreateInfo createSafe(long address) {
        return address == 0L ? null : (XrSwapchainCreateInfo)XrSwapchainCreateInfo.wrap(XrSwapchainCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSwapchainCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSwapchainCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSwapchainCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSwapchainCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSwapchainCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSwapchainCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSwapchainCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSwapchainCreateInfo malloc(MemoryStack stack) {
        return (XrSwapchainCreateInfo)XrSwapchainCreateInfo.wrap(XrSwapchainCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSwapchainCreateInfo calloc(MemoryStack stack) {
        return (XrSwapchainCreateInfo)XrSwapchainCreateInfo.wrap(XrSwapchainCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSwapchainCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSwapchainCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long ncreateFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)CREATEFLAGS);
    }

    public static long nusageFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)USAGEFLAGS);
    }

    public static long nformat(long struct) {
        return UNSAFE.getLong(null, struct + (long)FORMAT);
    }

    public static int nsampleCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLECOUNT);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int nfaceCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)FACECOUNT);
    }

    public static int narraySize(long struct) {
        return UNSAFE.getInt(null, struct + (long)ARRAYSIZE);
    }

    public static int nmipCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIPCOUNT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ncreateFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)CREATEFLAGS, value);
    }

    public static void nusageFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)USAGEFLAGS, value);
    }

    public static void nformat(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FORMAT, value);
    }

    public static void nsampleCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLECOUNT, value);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void nfaceCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FACECOUNT, value);
    }

    public static void narraySize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ARRAYSIZE, value);
    }

    public static void nmipCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIPCOUNT, value);
    }

    static {
        Struct.Layout layout = XrSwapchainCreateInfo.__struct((Struct.Member[])new Struct.Member[]{XrSwapchainCreateInfo.__member((int)4), XrSwapchainCreateInfo.__member((int)POINTER_SIZE), XrSwapchainCreateInfo.__member((int)8), XrSwapchainCreateInfo.__member((int)8), XrSwapchainCreateInfo.__member((int)8), XrSwapchainCreateInfo.__member((int)4), XrSwapchainCreateInfo.__member((int)4), XrSwapchainCreateInfo.__member((int)4), XrSwapchainCreateInfo.__member((int)4), XrSwapchainCreateInfo.__member((int)4), XrSwapchainCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CREATEFLAGS = layout.offsetof(2);
        USAGEFLAGS = layout.offsetof(3);
        FORMAT = layout.offsetof(4);
        SAMPLECOUNT = layout.offsetof(5);
        WIDTH = layout.offsetof(6);
        HEIGHT = layout.offsetof(7);
        FACECOUNT = layout.offsetof(8);
        ARRAYSIZE = layout.offsetof(9);
        MIPCOUNT = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<XrSwapchainCreateInfo, Buffer>
    implements NativeResource {
        private static final XrSwapchainCreateInfo ELEMENT_FACTORY = XrSwapchainCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSwapchainCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSwapchainCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSwapchainCreateInfo.nnext(this.address());
        }

        @NativeType(value="XrSwapchainCreateFlags")
        public long createFlags() {
            return XrSwapchainCreateInfo.ncreateFlags(this.address());
        }

        @NativeType(value="XrSwapchainUsageFlags")
        public long usageFlags() {
            return XrSwapchainCreateInfo.nusageFlags(this.address());
        }

        @NativeType(value="int64_t")
        public long format() {
            return XrSwapchainCreateInfo.nformat(this.address());
        }

        @NativeType(value="uint32_t")
        public int sampleCount() {
            return XrSwapchainCreateInfo.nsampleCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int width() {
            return XrSwapchainCreateInfo.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return XrSwapchainCreateInfo.nheight(this.address());
        }

        @NativeType(value="uint32_t")
        public int faceCount() {
            return XrSwapchainCreateInfo.nfaceCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int arraySize() {
            return XrSwapchainCreateInfo.narraySize(this.address());
        }

        @NativeType(value="uint32_t")
        public int mipCount() {
            return XrSwapchainCreateInfo.nmipCount(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSwapchainCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(9);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSwapchainCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrSecondaryViewConfigurationSwapchainCreateInfoMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSwapchainCreateInfoFoveationFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrVulkanSwapchainCreateInfoMETA value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer createFlags(@NativeType(value="XrSwapchainCreateFlags") long value) {
            XrSwapchainCreateInfo.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer usageFlags(@NativeType(value="XrSwapchainUsageFlags") long value) {
            XrSwapchainCreateInfo.nusageFlags(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="int64_t") long value) {
            XrSwapchainCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer sampleCount(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.nsampleCount(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.nheight(this.address(), value);
            return this;
        }

        public Buffer faceCount(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.nfaceCount(this.address(), value);
            return this;
        }

        public Buffer arraySize(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.narraySize(this.address(), value);
            return this;
        }

        public Buffer mipCount(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.nmipCount(this.address(), value);
            return this;
        }
    }
}

