/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIType;
import org.lwjgl.system.libffi.LibFFI;

public class Opus {
    private static final SharedLibrary OPUS = Library.loadNative(Opus.class, (String)"org.lwjgl.opus", (String)((String)Configuration.OPUS_LIBRARY_NAME.get((Object)Platform.mapLibraryNameBundled((String)"opus"))), (boolean)true);
    public static final int OPUS_OK = 0;
    public static final int OPUS_BAD_ARG = -1;
    public static final int OPUS_BUFFER_TOO_SMALL = -2;
    public static final int OPUS_INTERNAL_ERROR = -3;
    public static final int OPUS_INVALID_PACKET = -4;
    public static final int OPUS_UNIMPLEMENTED = -5;
    public static final int OPUS_INVALID_STATE = -6;
    public static final int OPUS_ALLOC_FAIL = -7;
    public static final int OPUS_SET_APPLICATION_REQUEST = 4000;
    public static final int OPUS_GET_APPLICATION_REQUEST = 4001;
    public static final int OPUS_SET_BITRATE_REQUEST = 4002;
    public static final int OPUS_GET_BITRATE_REQUEST = 4003;
    public static final int OPUS_SET_MAX_BANDWIDTH_REQUEST = 4004;
    public static final int OPUS_GET_MAX_BANDWIDTH_REQUEST = 4005;
    public static final int OPUS_SET_VBR_REQUEST = 4006;
    public static final int OPUS_GET_VBR_REQUEST = 4007;
    public static final int OPUS_SET_BANDWIDTH_REQUEST = 4008;
    public static final int OPUS_GET_BANDWIDTH_REQUEST = 4009;
    public static final int OPUS_SET_COMPLEXITY_REQUEST = 4010;
    public static final int OPUS_GET_COMPLEXITY_REQUEST = 4011;
    public static final int OPUS_SET_INBAND_FEC_REQUEST = 4012;
    public static final int OPUS_GET_INBAND_FEC_REQUEST = 4013;
    public static final int OPUS_SET_PACKET_LOSS_PERC_REQUEST = 4014;
    public static final int OPUS_GET_PACKET_LOSS_PERC_REQUEST = 4015;
    public static final int OPUS_SET_DTX_REQUEST = 4016;
    public static final int OPUS_GET_DTX_REQUEST = 4017;
    public static final int OPUS_SET_VBR_CONSTRAINT_REQUEST = 4020;
    public static final int OPUS_GET_VBR_CONSTRAINT_REQUEST = 4021;
    public static final int OPUS_SET_FORCE_CHANNELS_REQUEST = 4022;
    public static final int OPUS_GET_FORCE_CHANNELS_REQUEST = 4023;
    public static final int OPUS_SET_SIGNAL_REQUEST = 4024;
    public static final int OPUS_GET_SIGNAL_REQUEST = 4025;
    public static final int OPUS_GET_LOOKAHEAD_REQUEST = 4027;
    public static final int OPUS_RESET_STATE = 4028;
    public static final int OPUS_GET_SAMPLE_RATE_REQUEST = 4029;
    public static final int OPUS_GET_FINAL_RANGE_REQUEST = 4031;
    public static final int OPUS_GET_PITCH_REQUEST = 4033;
    public static final int OPUS_SET_GAIN_REQUEST = 4034;
    public static final int OPUS_GET_GAIN_REQUEST = 4045;
    public static final int OPUS_SET_LSB_DEPTH_REQUEST = 4036;
    public static final int OPUS_GET_LSB_DEPTH_REQUEST = 4037;
    public static final int OPUS_GET_LAST_PACKET_DURATION_REQUEST = 4039;
    public static final int OPUS_SET_EXPERT_FRAME_DURATION_REQUEST = 4040;
    public static final int OPUS_GET_EXPERT_FRAME_DURATION_REQUEST = 4041;
    public static final int OPUS_SET_PREDICTION_DISABLED_REQUEST = 4042;
    public static final int OPUS_GET_PREDICTION_DISABLED_REQUEST = 4043;
    public static final int OPUS_SET_PHASE_INVERSION_DISABLED_REQUEST = 4046;
    public static final int OPUS_GET_PHASE_INVERSION_DISABLED_REQUEST = 4047;
    public static final int OPUS_GET_IN_DTX_REQUEST = 4049;
    public static final int OPUS_SET_DRED_DURATION_REQUEST = 4050;
    public static final int OPUS_GET_DRED_DURATION_REQUEST = 4051;
    public static final int OPUS_SET_DNN_BLOB_REQUEST = 4052;
    public static final int OPUS_AUTO = -1000;
    public static final int OPUS_BITRATE_MAX = -1;
    public static final int OPUS_APPLICATION_VOIP = 2048;
    public static final int OPUS_APPLICATION_AUDIO = 2049;
    public static final int OPUS_APPLICATION_RESTRICTED_LOWDELAY = 2051;
    public static final int OPUS_SIGNAL_VOICE = 3001;
    public static final int OPUS_SIGNAL_MUSIC = 3002;
    public static final int OPUS_BANDWIDTH_NARROWBAND = 1101;
    public static final int OPUS_BANDWIDTH_MEDIUMBAND = 1102;
    public static final int OPUS_BANDWIDTH_WIDEBAND = 1103;
    public static final int OPUS_BANDWIDTH_SUPERWIDEBAND = 1104;
    public static final int OPUS_BANDWIDTH_FULLBAND = 1105;
    public static final int OPUS_FRAMESIZE_ARG = 5000;
    public static final int OPUS_FRAMESIZE_2_5_MS = 5001;
    public static final int OPUS_FRAMESIZE_5_MS = 5002;
    public static final int OPUS_FRAMESIZE_10_MS = 5003;
    public static final int OPUS_FRAMESIZE_20_MS = 5004;
    public static final int OPUS_FRAMESIZE_40_MS = 5005;
    public static final int OPUS_FRAMESIZE_60_MS = 5006;
    public static final int OPUS_FRAMESIZE_80_MS = 5007;
    public static final int OPUS_FRAMESIZE_100_MS = 5008;
    public static final int OPUS_FRAMESIZE_120_MS = 5009;

    public static SharedLibrary getLibrary() {
        return OPUS;
    }

    protected Opus() {
        throw new UnsupportedOperationException();
    }

    public static int opus_encoder_get_size(int channels) {
        long __functionAddress = Functions.encoder_get_size;
        return JNI.invokeI((int)channels, (long)__functionAddress);
    }

    public static long nopus_encoder_create(int Fs, int channels, int application, long error) {
        long __functionAddress = Functions.encoder_create;
        return JNI.invokePP((int)Fs, (int)channels, (int)application, (long)error, (long)__functionAddress);
    }

    @NativeType(value="OpusEncoder *")
    public static long opus_encoder_create(@NativeType(value="opus_int32") int Fs, int channels, int application, @NativeType(value="int *") @Nullable IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, (int)1);
        }
        return Opus.nopus_encoder_create(Fs, channels, application, MemoryUtil.memAddressSafe((IntBuffer)error));
    }

    public static int opus_encoder_init(@NativeType(value="OpusEncoder *") long st, @NativeType(value="opus_int32") int Fs, int channels, int application) {
        long __functionAddress = Functions.encoder_init;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePI((long)st, (int)Fs, (int)channels, (int)application, (long)__functionAddress);
    }

    public static int nopus_encode(long st, long pcm, int frame_size, long data, int max_data_bytes) {
        long __functionAddress = Functions.encode;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePPPI((long)st, (long)pcm, (int)frame_size, (long)data, (int)max_data_bytes, (long)__functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int opus_encode(@NativeType(value="OpusEncoder *") long st, @NativeType(value="opus_int16 const *") ShortBuffer pcm, int frame_size, @NativeType(value="unsigned char *") ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * MemoryUtil.memGetInt((long)(st + 8L))));
        }
        return Opus.nopus_encode(st, MemoryUtil.memAddress((ShortBuffer)pcm), frame_size, MemoryUtil.memAddress((ByteBuffer)data), data.remaining());
    }

    public static int nopus_encode_float(long st, long pcm, int frame_size, long data, int max_data_bytes) {
        long __functionAddress = Functions.encode_float;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePPPI((long)st, (long)pcm, (int)frame_size, (long)data, (int)max_data_bytes, (long)__functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int opus_encode_float(@NativeType(value="OpusEncoder *") long st, @NativeType(value="float const *") FloatBuffer pcm, int frame_size, @NativeType(value="unsigned char *") ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * MemoryUtil.memGetInt((long)(st + 8L))));
        }
        return Opus.nopus_encode_float(st, MemoryUtil.memAddress((FloatBuffer)pcm), frame_size, MemoryUtil.memAddress((ByteBuffer)data), data.remaining());
    }

    public static void opus_encoder_destroy(@NativeType(value="OpusEncoder *") long st) {
        long __functionAddress = Functions.encoder_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        JNI.invokePV((long)st, (long)__functionAddress);
    }

    private static int opus_encoder_ctl(@NativeType(value="OpusEncoder *") long st) {
        long __functionAddress = Functions.encoder_ctl;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePI((long)st, (long)__functionAddress);
    }

    public static int opus_decoder_get_size(int channels) {
        long __functionAddress = Functions.decoder_get_size;
        return JNI.invokeI((int)channels, (long)__functionAddress);
    }

    public static long nopus_decoder_create(int Fs, int channels, long error) {
        long __functionAddress = Functions.decoder_create;
        return JNI.invokePP((int)Fs, (int)channels, (long)error, (long)__functionAddress);
    }

    @NativeType(value="OpusDecoder *")
    public static long opus_decoder_create(@NativeType(value="opus_int32") int Fs, int channels, @NativeType(value="int *") @Nullable IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, (int)1);
        }
        return Opus.nopus_decoder_create(Fs, channels, MemoryUtil.memAddressSafe((IntBuffer)error));
    }

    public static int opus_decoder_init(@NativeType(value="OpusDecoder *") long st, @NativeType(value="opus_int32") int Fs, int channels) {
        long __functionAddress = Functions.decoder_init;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePI((long)st, (int)Fs, (int)channels, (long)__functionAddress);
    }

    public static int nopus_decode(long st, long data, int len, long pcm, int frame_size, int decode_fec) {
        long __functionAddress = Functions.decode;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePPPI((long)st, (long)data, (int)len, (long)pcm, (int)frame_size, (int)decode_fec, (long)__functionAddress);
    }

    public static int opus_decode(@NativeType(value="OpusDecoder *") long st, @NativeType(value="unsigned char const *") @Nullable ByteBuffer data, @NativeType(value="opus_int16 *") ShortBuffer pcm, int frame_size, int decode_fec) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * MemoryUtil.memGetInt((long)(st + 8L))));
        }
        return Opus.nopus_decode(st, MemoryUtil.memAddressSafe((ByteBuffer)data), Checks.remainingSafe((Buffer)data), MemoryUtil.memAddress((ShortBuffer)pcm), frame_size, decode_fec);
    }

    public static int nopus_decode_float(long st, long data, int len, long pcm, int frame_size, int decode_fec) {
        long __functionAddress = Functions.decode_float;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePPPI((long)st, (long)data, (int)len, (long)pcm, (int)frame_size, (int)decode_fec, (long)__functionAddress);
    }

    public static int opus_decode_float(@NativeType(value="OpusDecoder *") long st, @NativeType(value="unsigned char const *") @Nullable ByteBuffer data, @NativeType(value="float *") FloatBuffer pcm, int frame_size, int decode_fec) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * MemoryUtil.memGetInt((long)(st + 8L))));
        }
        return Opus.nopus_decode_float(st, MemoryUtil.memAddressSafe((ByteBuffer)data), Checks.remainingSafe((Buffer)data), MemoryUtil.memAddress((FloatBuffer)pcm), frame_size, decode_fec);
    }

    private static int opus_decoder_ctl(@NativeType(value="OpusDecoder *") long st) {
        long __functionAddress = Functions.decoder_ctl;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePI((long)st, (long)__functionAddress);
    }

    public static void opus_decoder_destroy(@NativeType(value="OpusDecoder *") long st) {
        long __functionAddress = Functions.decoder_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        JNI.invokePV((long)st, (long)__functionAddress);
    }

    public static int opus_dred_decoder_get_size() {
        long __functionAddress = Functions.dred_decoder_get_size;
        return JNI.invokeI((long)__functionAddress);
    }

    public static long nopus_dred_decoder_create(long error) {
        long __functionAddress = Functions.dred_decoder_create;
        return JNI.invokePP((long)error, (long)__functionAddress);
    }

    @NativeType(value="OpusDREDDecoder *")
    public static long opus_dred_decoder_create(@NativeType(value="int *") @Nullable IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, (int)1);
        }
        return Opus.nopus_dred_decoder_create(MemoryUtil.memAddressSafe((IntBuffer)error));
    }

    public static int opus_dred_decoder_init(@NativeType(value="OpusDREDDecoder *") long dec) {
        long __functionAddress = Functions.dred_decoder_init;
        if (Checks.CHECKS) {
            Checks.check((long)dec);
        }
        return JNI.invokePI((long)dec, (long)__functionAddress);
    }

    public static void opus_dred_decoder_destroy(@NativeType(value="OpusDREDDecoder *") long dec) {
        long __functionAddress = Functions.dred_decoder_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)dec);
        }
        JNI.invokePV((long)dec, (long)__functionAddress);
    }

    private static int opus_dred_decoder_ctl(@NativeType(value="OpusDREDDecoder *") long dred_dec) {
        long __functionAddress = Functions.dred_decoder_ctl;
        if (Checks.CHECKS) {
            Checks.check((long)dred_dec);
        }
        return JNI.invokePI((long)dred_dec, (long)__functionAddress);
    }

    public static int opus_dred_get_size() {
        long __functionAddress = Functions.dred_get_size;
        return JNI.invokeI((long)__functionAddress);
    }

    public static long nopus_dred_alloc(long error) {
        long __functionAddress = Functions.dred_alloc;
        return JNI.invokePP((long)error, (long)__functionAddress);
    }

    @NativeType(value="OpusDRED *")
    public static long opus_dred_alloc(@NativeType(value="int *") @Nullable IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, (int)1);
        }
        return Opus.nopus_dred_alloc(MemoryUtil.memAddressSafe((IntBuffer)error));
    }

    public static void opus_dred_free(@NativeType(value="OpusDRED *") long dec) {
        long __functionAddress = Functions.dred_free;
        if (Checks.CHECKS) {
            Checks.check((long)dec);
        }
        JNI.invokePV((long)dec, (long)__functionAddress);
    }

    public static int nopus_dred_parse(long dred_dec, long dred, long data, int len, int max_dred_samples, int sampling_rate, long dred_end, int defer_processing) {
        long __functionAddress = Functions.dred_parse;
        if (Checks.CHECKS) {
            Checks.check((long)dred_dec);
            Checks.check((long)dred);
        }
        return JNI.invokePPPPI((long)dred_dec, (long)dred, (long)data, (int)len, (int)max_dred_samples, (int)sampling_rate, (long)dred_end, (int)defer_processing, (long)__functionAddress);
    }

    public static int opus_dred_parse(@NativeType(value="OpusDREDDecoder *") long dred_dec, @NativeType(value="OpusDRED *") long dred, @NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="opus_int32") int max_dred_samples, @NativeType(value="opus_int32") int sampling_rate, @NativeType(value="int *") @Nullable IntBuffer dred_end, @NativeType(value="int") boolean defer_processing) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)dred_end, (int)1);
        }
        return Opus.nopus_dred_parse(dred_dec, dred, MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), max_dred_samples, sampling_rate, MemoryUtil.memAddressSafe((IntBuffer)dred_end), defer_processing ? 1 : 0);
    }

    public static int opus_dred_process(@NativeType(value="OpusDREDDecoder *") long dred_dec, @NativeType(value="OpusDRED const *") long src, @NativeType(value="OpusDRED *") long dst) {
        long __functionAddress = Functions.dred_process;
        if (Checks.CHECKS) {
            Checks.check((long)dred_dec);
            Checks.check((long)src);
            Checks.check((long)dst);
        }
        return JNI.invokePPPI((long)dred_dec, (long)src, (long)dst, (long)__functionAddress);
    }

    public static int nopus_decoder_dred_decode(long st, long dred, int dred_offset, long pcm, int frame_size) {
        long __functionAddress = Functions.decoder_dred_decode;
        if (Checks.CHECKS) {
            Checks.check((long)st);
            Checks.check((long)dred);
        }
        return JNI.invokePPPI((long)st, (long)dred, (int)dred_offset, (long)pcm, (int)frame_size, (long)__functionAddress);
    }

    public static int opus_decoder_dred_decode(@NativeType(value="OpusDecoder *") long st, @NativeType(value="OpusDRED const *") long dred, @NativeType(value="opus_int32") int dred_offset, @NativeType(value="opus_int16 *") ShortBuffer pcm, int frame_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * MemoryUtil.memGetInt((long)(st + 8L))));
        }
        return Opus.nopus_decoder_dred_decode(st, dred, dred_offset, MemoryUtil.memAddress((ShortBuffer)pcm), frame_size);
    }

    public static int nopus_decoder_dred_decode_float(long st, long dred, int dred_offset, long pcm, int frame_size) {
        long __functionAddress = Functions.decoder_dred_decode_float;
        if (Checks.CHECKS) {
            Checks.check((long)st);
            Checks.check((long)dred);
        }
        return JNI.invokePPPI((long)st, (long)dred, (int)dred_offset, (long)pcm, (int)frame_size, (long)__functionAddress);
    }

    public static int opus_decoder_dred_decode_float(@NativeType(value="OpusDecoder *") long st, @NativeType(value="OpusDRED const *") long dred, @NativeType(value="opus_int32") int dred_offset, @NativeType(value="float *") FloatBuffer pcm, int frame_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * MemoryUtil.memGetInt((long)(st + 8L))));
        }
        return Opus.nopus_decoder_dred_decode_float(st, dred, dred_offset, MemoryUtil.memAddress((FloatBuffer)pcm), frame_size);
    }

    public static int nopus_packet_parse(long data, int len, long out_toc, long frames, long size, long payload_offset) {
        long __functionAddress = Functions.packet_parse;
        return JNI.invokePPPPPI((long)data, (int)len, (long)out_toc, (long)frames, (long)size, (long)payload_offset, (long)__functionAddress);
    }

    public static int opus_packet_parse(@NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="unsigned char *") @Nullable ByteBuffer out_toc, @NativeType(value="unsigned char const **") @Nullable PointerBuffer frames, @NativeType(value="opus_int16 *") ShortBuffer size, @NativeType(value="int *") @Nullable IntBuffer payload_offset) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)out_toc, (int)1);
            Checks.checkSafe((CustomBuffer)frames, (int)48);
            Checks.check((Buffer)size, (int)48);
            Checks.checkSafe((Buffer)payload_offset, (int)1);
        }
        return Opus.nopus_packet_parse(MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), MemoryUtil.memAddressSafe((ByteBuffer)out_toc), MemoryUtil.memAddressSafe((Pointer)frames), MemoryUtil.memAddress((ShortBuffer)size), MemoryUtil.memAddressSafe((IntBuffer)payload_offset));
    }

    public static int nopus_packet_get_bandwidth(long data) {
        long __functionAddress = Functions.packet_get_bandwidth;
        return JNI.invokePI((long)data, (long)__functionAddress);
    }

    public static int opus_packet_get_bandwidth(@NativeType(value="unsigned char const *") ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        return Opus.nopus_packet_get_bandwidth(MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static int nopus_packet_get_samples_per_frame(long data, int Fs) {
        long __functionAddress = Functions.packet_get_samples_per_frame;
        return JNI.invokePI((long)data, (int)Fs, (long)__functionAddress);
    }

    public static int opus_packet_get_samples_per_frame(@NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="opus_int32") int Fs) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        return Opus.nopus_packet_get_samples_per_frame(MemoryUtil.memAddress((ByteBuffer)data), Fs);
    }

    public static int nopus_packet_get_nb_channels(long data) {
        long __functionAddress = Functions.packet_get_nb_channels;
        return JNI.invokePI((long)data, (long)__functionAddress);
    }

    public static int opus_packet_get_nb_channels(@NativeType(value="unsigned char const *") ByteBuffer data) {
        return Opus.nopus_packet_get_nb_channels(MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static int nopus_packet_get_nb_frames(long packet, int len) {
        long __functionAddress = Functions.packet_get_nb_frames;
        return JNI.invokePI((long)packet, (int)len, (long)__functionAddress);
    }

    public static int opus_packet_get_nb_frames(@NativeType(value="unsigned char const *") ByteBuffer packet) {
        return Opus.nopus_packet_get_nb_frames(MemoryUtil.memAddress((ByteBuffer)packet), packet.remaining());
    }

    public static int nopus_packet_get_nb_samples(long packet, int len, int Fs) {
        long __functionAddress = Functions.packet_get_nb_samples;
        return JNI.invokePI((long)packet, (int)len, (int)Fs, (long)__functionAddress);
    }

    public static int opus_packet_get_nb_samples(@NativeType(value="unsigned char const *") ByteBuffer packet, @NativeType(value="opus_int32") int Fs) {
        return Opus.nopus_packet_get_nb_samples(MemoryUtil.memAddress((ByteBuffer)packet), packet.remaining(), Fs);
    }

    public static int nopus_packet_has_lbrr(long packet, int len) {
        long __functionAddress = Functions.packet_has_lbrr;
        return JNI.invokePI((long)packet, (int)len, (long)__functionAddress);
    }

    public static int opus_packet_has_lbrr(@NativeType(value="unsigned char const *") ByteBuffer packet) {
        return Opus.nopus_packet_has_lbrr(MemoryUtil.memAddress((ByteBuffer)packet), packet.remaining());
    }

    public static int nopus_decoder_get_nb_samples(long dec, long packet, int len) {
        long __functionAddress = Functions.decoder_get_nb_samples;
        if (Checks.CHECKS) {
            Checks.check((long)dec);
        }
        return JNI.invokePPI((long)dec, (long)packet, (int)len, (long)__functionAddress);
    }

    public static int opus_decoder_get_nb_samples(@NativeType(value="OpusDecoder const *") long dec, @NativeType(value="unsigned char const *") ByteBuffer packet) {
        return Opus.nopus_decoder_get_nb_samples(dec, MemoryUtil.memAddress((ByteBuffer)packet), packet.remaining());
    }

    public static void nopus_pcm_soft_clip(long pcm, int frame_size, int channels, long softclip_mem) {
        long __functionAddress = Functions.pcm_soft_clip;
        JNI.invokePPV((long)pcm, (int)frame_size, (int)channels, (long)softclip_mem, (long)__functionAddress);
    }

    public static void opus_pcm_soft_clip(@NativeType(value="float *") FloatBuffer pcm, int frame_size, @NativeType(value="float *") FloatBuffer softclip_mem) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * softclip_mem.remaining()));
        }
        Opus.nopus_pcm_soft_clip(MemoryUtil.memAddress((FloatBuffer)pcm), frame_size, softclip_mem.remaining(), MemoryUtil.memAddress((FloatBuffer)softclip_mem));
    }

    public static int opus_repacketizer_get_size() {
        long __functionAddress = Functions.repacketizer_get_size;
        return JNI.invokeI((long)__functionAddress);
    }

    @NativeType(value="OpusRepacketizer *")
    public static long opus_repacketizer_init(@NativeType(value="OpusRepacketizer *") long rp) {
        long __functionAddress = Functions.repacketizer_init;
        if (Checks.CHECKS) {
            Checks.check((long)rp);
        }
        return JNI.invokePP((long)rp, (long)__functionAddress);
    }

    @NativeType(value="OpusRepacketizer *")
    public static long opus_repacketizer_create() {
        long __functionAddress = Functions.repacketizer_create;
        return JNI.invokeP((long)__functionAddress);
    }

    public static void opus_repacketizer_destroy(@NativeType(value="OpusRepacketizer *") long rp) {
        long __functionAddress = Functions.repacketizer_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)rp);
        }
        JNI.invokePV((long)rp, (long)__functionAddress);
    }

    public static int nopus_repacketizer_cat(long rp, long data, int len) {
        long __functionAddress = Functions.repacketizer_cat;
        if (Checks.CHECKS) {
            Checks.check((long)rp);
        }
        return JNI.invokePPI((long)rp, (long)data, (int)len, (long)__functionAddress);
    }

    public static int opus_repacketizer_cat(@NativeType(value="OpusRepacketizer *") long rp, @NativeType(value="unsigned char const *") ByteBuffer data) {
        return Opus.nopus_repacketizer_cat(rp, MemoryUtil.memAddress((ByteBuffer)data), data.remaining());
    }

    public static int nopus_repacketizer_out_range(long rp, int begin, int end, long data, int maxlen) {
        long __functionAddress = Functions.repacketizer_out_range;
        if (Checks.CHECKS) {
            Checks.check((long)rp);
        }
        return JNI.invokePPI((long)rp, (int)begin, (int)end, (long)data, (int)maxlen, (long)__functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int opus_repacketizer_out_range(@NativeType(value="OpusRepacketizer *") long rp, int begin, int end, @NativeType(value="unsigned char const *") ByteBuffer data) {
        return Opus.nopus_repacketizer_out_range(rp, begin, end, MemoryUtil.memAddress((ByteBuffer)data), data.remaining());
    }

    public static int opus_repacketizer_get_nb_frames(@NativeType(value="OpusRepacketizer *") long rp) {
        long __functionAddress = Functions.repacketizer_get_nb_frames;
        if (Checks.CHECKS) {
            Checks.check((long)rp);
        }
        return JNI.invokePI((long)rp, (long)__functionAddress);
    }

    public static int nopus_repacketizer_out(long rp, long data, int maxlen) {
        long __functionAddress = Functions.repacketizer_out;
        if (Checks.CHECKS) {
            Checks.check((long)rp);
        }
        return JNI.invokePPI((long)rp, (long)data, (int)maxlen, (long)__functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int opus_repacketizer_out(@NativeType(value="OpusRepacketizer *") long rp, @NativeType(value="unsigned char const *") ByteBuffer data) {
        return Opus.nopus_repacketizer_out(rp, MemoryUtil.memAddress((ByteBuffer)data), data.remaining());
    }

    public static int nopus_packet_pad(long data, int len, int new_len) {
        long __functionAddress = Functions.packet_pad;
        return JNI.invokePI((long)data, (int)len, (int)new_len, (long)__functionAddress);
    }

    public static int opus_packet_pad(@NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="opus_int32") int len, @NativeType(value="opus_int32") int new_len) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)Math.max(len, new_len));
        }
        return Opus.nopus_packet_pad(MemoryUtil.memAddress((ByteBuffer)data), len, new_len);
    }

    public static int nopus_packet_unpad(long data, int len) {
        long __functionAddress = Functions.packet_unpad;
        return JNI.invokePI((long)data, (int)len, (long)__functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int opus_packet_unpad(@NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="opus_int32") int len) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)len);
        }
        return Opus.nopus_packet_unpad(MemoryUtil.memAddress((ByteBuffer)data), len);
    }

    public static int nopus_multistream_packet_pad(long data, int len, int new_len, int nb_streams) {
        long __functionAddress = Functions.multistream_packet_pad;
        return JNI.invokePI((long)data, (int)len, (int)new_len, (int)nb_streams, (long)__functionAddress);
    }

    public static int opus_multistream_packet_pad(@NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="opus_int32") int len, @NativeType(value="opus_int32") int new_len, int nb_streams) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)Math.max(len, new_len));
        }
        return Opus.nopus_multistream_packet_pad(MemoryUtil.memAddress((ByteBuffer)data), len, new_len, nb_streams);
    }

    public static int nopus_multistream_packet_unpad(long data, int len, int nb_streams) {
        long __functionAddress = Functions.multistream_packet_unpad;
        return JNI.invokePI((long)data, (int)len, (int)nb_streams, (long)__functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int opus_multistream_packet_unpad(@NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="opus_int32") int len, int nb_streams) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)len);
        }
        return Opus.nopus_multistream_packet_unpad(MemoryUtil.memAddress((ByteBuffer)data), len, nb_streams);
    }

    public static long nopus_strerror(int error) {
        long __functionAddress = Functions.strerror;
        return JNI.invokeP((int)error, (long)__functionAddress);
    }

    @NativeType(value="char *")
    public static @Nullable String opus_strerror(int error) {
        long __result = Opus.nopus_strerror(error);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static long nopus_get_version_string() {
        long __functionAddress = Functions.get_version_string;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="char *")
    public static @Nullable String opus_get_version_string() {
        long __result = Opus.nopus_get_version_string();
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static int opus_encoder_ctl(@NativeType(value="OpusEncoder *") long st, int request) {
        return new CTLRequestV(request).apply(st, Functions.encoder_ctl);
    }

    public static int opus_encoder_ctl(@NativeType(value="OpusEncoder *") long st, CTLRequest request) {
        return request.apply(st, Functions.encoder_ctl);
    }

    public static int opus_decoder_ctl(@NativeType(value="OpusDecoder *") long st, int request) {
        return new CTLRequestV(request).apply(st, Functions.decoder_ctl);
    }

    public static int opus_decoder_ctl(@NativeType(value="OpusDecoder *") long st, CTLRequest request) {
        return request.apply(st, Functions.decoder_ctl);
    }

    public static int opus_dred_decoder_ctl(@NativeType(value="OpusDredDecoder *") long dred_dec, int request) {
        return new CTLRequestV(request).apply(dred_dec, Functions.dred_decoder_ctl);
    }

    public static int opus_dred_decoder_ctl(@NativeType(value="OpusDredDecoder *") long dred_dec, CTLRequest request) {
        return request.apply(dred_dec, Functions.dred_decoder_ctl);
    }

    public static CTLRequest OPUS_SET_COMPLEXITY(int value) {
        return new CTLRequestI(4010, value);
    }

    public static CTLRequest OPUS_GET_COMPLEXITY(IntBuffer value) {
        return new CTLRequestP(4011, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_BITRATE(int value) {
        return new CTLRequestI(4002, value);
    }

    public static CTLRequest OPUS_GET_BITRATE(IntBuffer value) {
        return new CTLRequestP(4003, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_VBR(int value) {
        return new CTLRequestI(4006, value);
    }

    public static CTLRequest OPUS_GET_VBR(IntBuffer value) {
        return new CTLRequestP(4007, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_VBR_CONSTRAINT(int value) {
        return new CTLRequestI(4020, value);
    }

    public static CTLRequest OPUS_GET_VBR_CONSTRAINT(IntBuffer value) {
        return new CTLRequestP(4021, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_FORCE_CHANNELS(int value) {
        return new CTLRequestI(4022, value);
    }

    public static CTLRequest OPUS_GET_FORCE_CHANNELS(IntBuffer value) {
        return new CTLRequestP(4023, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_MAX_BANDWIDTH(int value) {
        return new CTLRequestI(4004, value);
    }

    public static CTLRequest OPUS_GET_MAX_BANDWIDTH(IntBuffer value) {
        return new CTLRequestP(4005, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_BANDWIDTH(int value) {
        return new CTLRequestI(4008, value);
    }

    public static CTLRequest OPUS_GET_BANDWIDTH(IntBuffer value) {
        return new CTLRequestP(4009, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_SIGNAL(int value) {
        return new CTLRequestI(4024, value);
    }

    public static CTLRequest OPUS_GET_SIGNAL(IntBuffer value) {
        return new CTLRequestP(4025, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_APPLICATION(int value) {
        return new CTLRequestI(4000, value);
    }

    public static CTLRequest OPUS_GET_APPLICATION(IntBuffer value) {
        return new CTLRequestP(4001, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_GET_LOOKAHEAD(IntBuffer value) {
        return new CTLRequestP(4027, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_INBAND_FEC(int value) {
        return new CTLRequestI(4012, value);
    }

    public static CTLRequest OPUS_GET_INBAND_FEC(IntBuffer value) {
        return new CTLRequestP(4013, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_PACKET_LOSS_PERC(int value) {
        return new CTLRequestI(4014, value);
    }

    public static CTLRequest OPUS_GET_PACKET_LOSS_PERC(IntBuffer value) {
        return new CTLRequestP(4015, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_DTX(int value) {
        return new CTLRequestI(4016, value);
    }

    public static CTLRequest OPUS_GET_DTX(IntBuffer value) {
        return new CTLRequestP(4017, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_LSB_DEPTH(int value) {
        return new CTLRequestI(4036, value);
    }

    public static CTLRequest OPUS_GET_LSB_DEPTH(IntBuffer value) {
        return new CTLRequestP(4037, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_EXPERT_FRAME_DURATION(int value) {
        return new CTLRequestI(4040, value);
    }

    public static CTLRequest OPUS_GET_EXPERT_FRAME_DURATION(IntBuffer value) {
        return new CTLRequestP(4041, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_PREDICTION_DISABLED(int value) {
        return new CTLRequestI(4042, value);
    }

    public static CTLRequest OPUS_GET_PREDICTION_DISABLED(IntBuffer value) {
        return new CTLRequestP(4043, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_DRED_DURATION_REQUEST(int value) {
        return new CTLRequestI(4050, value);
    }

    public static CTLRequest OPUS_GET_DRED_DURATION_REQUEST(IntBuffer value) {
        return new CTLRequestP(4051, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_DNN_BLOB_REQUEST(ByteBuffer data, int len) {
        return new CTLRequestPI(4052, MemoryUtil.memAddress((ByteBuffer)data), len);
    }

    public static CTLRequest OPUS_GET_FINAL_RANGE(IntBuffer value) {
        return new CTLRequestP(4031, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_GET_SAMPLE_RATE(IntBuffer value) {
        return new CTLRequestP(4029, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_PHASE_INVERSION_DISABLED(int value) {
        return new CTLRequestI(4046, value);
    }

    public static CTLRequest OPUS_GET_PHASE_INVERSION_DISABLED(IntBuffer value) {
        return new CTLRequestP(4047, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_GET_IN_DTX(IntBuffer value) {
        return new CTLRequestP(4049, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_SET_GAIN(int value) {
        return new CTLRequestI(4034, value);
    }

    public static CTLRequest OPUS_GET_GAIN(IntBuffer value) {
        return new CTLRequestP(4045, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_GET_LAST_PACKET_DURATION(IntBuffer value) {
        return new CTLRequestP(4039, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static CTLRequest OPUS_GET_PITCH(IntBuffer value) {
        return new CTLRequestP(4033, MemoryUtil.memAddress((IntBuffer)value));
    }

    static /* synthetic */ SharedLibrary access$000() {
        return OPUS;
    }

    public static class CTLRequestPI
    extends CTLRequest {
        private static final FFICIF CIF = APIUtil.apiCreateCIFVar((int)LibFFI.FFI_DEFAULT_ABI, (int)2, (FFIType)LibFFI.ffi_type_sint, (FFIType[])new FFIType[]{LibFFI.ffi_type_pointer, LibFFI.ffi_type_sint, LibFFI.ffi_type_pointer, LibFFI.ffi_type_sint32});
        private long address;
        private int value;

        CTLRequestPI(int request, long address, int value) {
            super(CIF, request);
            this.address = address;
            this.value = value;
        }

        @Override
        int apply(long st, long __functionAddress) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer arguments = stack.malloc(MemoryStack.POINTER_SIZE * 2 + 8);
                PointerBuffer.put((ByteBuffer)arguments, (int)0, (long)st);
                PointerBuffer.put((ByteBuffer)arguments, (int)MemoryStack.POINTER_SIZE, (long)this.address);
                arguments.putInt(MemoryStack.POINTER_SIZE * 2, this.request);
                arguments.putInt(MemoryStack.POINTER_SIZE * 2 + 4, this.value);
                ByteBuffer rvalue = stack.calloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE);
                long avalues = MemoryUtil.memAddress((ByteBuffer)arguments);
                LibFFI.ffi_call((FFICIF)this.cif, (long)__functionAddress, (ByteBuffer)rvalue, (PointerBuffer)stack.mallocPointer(4).put(0, avalues).put(1, avalues + (long)(MemoryStack.POINTER_SIZE * 2)).put(2, avalues + (long)MemoryStack.POINTER_SIZE).put(3, avalues + (long)(MemoryStack.POINTER_SIZE * 2) + 4L));
                int n = rvalue.getInt(0);
                return n;
            }
        }
    }

    public static class CTLRequestP
    extends CTLRequest {
        private static final FFICIF CIF = APIUtil.apiCreateCIFVar((int)LibFFI.FFI_DEFAULT_ABI, (int)2, (FFIType)LibFFI.ffi_type_sint, (FFIType[])new FFIType[]{LibFFI.ffi_type_pointer, LibFFI.ffi_type_sint, LibFFI.ffi_type_pointer});
        private long address;

        CTLRequestP(int request, long address) {
            super(CIF, request);
            this.address = address;
        }

        @Override
        int apply(long st, long __functionAddress) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer arguments = stack.malloc(MemoryStack.POINTER_SIZE * 2 + 4);
                PointerBuffer.put((ByteBuffer)arguments, (int)0, (long)st);
                PointerBuffer.put((ByteBuffer)arguments, (int)MemoryStack.POINTER_SIZE, (long)this.address);
                arguments.putInt(MemoryStack.POINTER_SIZE * 2, this.request);
                ByteBuffer rvalue = stack.calloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE);
                long avalues = MemoryUtil.memAddress((ByteBuffer)arguments);
                LibFFI.ffi_call((FFICIF)this.cif, (long)__functionAddress, (ByteBuffer)rvalue, (PointerBuffer)stack.mallocPointer(3).put(0, avalues).put(1, avalues + (long)(MemoryStack.POINTER_SIZE * 2)).put(2, avalues + (long)MemoryStack.POINTER_SIZE));
                int n = rvalue.getInt(0);
                return n;
            }
        }
    }

    public static class CTLRequestI
    extends CTLRequest {
        private static final FFICIF CIF = APIUtil.apiCreateCIFVar((int)LibFFI.FFI_DEFAULT_ABI, (int)2, (FFIType)LibFFI.ffi_type_sint, (FFIType[])new FFIType[]{LibFFI.ffi_type_pointer, LibFFI.ffi_type_sint, LibFFI.ffi_type_sint32});
        private int value;

        CTLRequestI(int request, int value) {
            super(CIF, request);
            this.value = value;
        }

        @Override
        int apply(long st, long __functionAddress) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer arguments = stack.malloc(MemoryStack.POINTER_SIZE + 8);
                PointerBuffer.put((ByteBuffer)arguments, (int)0, (long)st);
                arguments.putInt(MemoryStack.POINTER_SIZE, this.request);
                arguments.putInt(MemoryStack.POINTER_SIZE + 4, this.value);
                ByteBuffer rvalue = stack.calloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE);
                long avalues = MemoryUtil.memAddress((ByteBuffer)arguments);
                LibFFI.ffi_call((FFICIF)this.cif, (long)__functionAddress, (ByteBuffer)rvalue, (PointerBuffer)stack.mallocPointer(3).put(0, avalues).put(1, avalues + (long)MemoryStack.POINTER_SIZE).put(2, avalues + (long)MemoryStack.POINTER_SIZE + 4L));
                int n = rvalue.getInt(0);
                return n;
            }
        }
    }

    public static class CTLRequestV
    extends CTLRequest {
        private static final FFICIF CIF = APIUtil.apiCreateCIFVar((int)LibFFI.FFI_DEFAULT_ABI, (int)2, (FFIType)LibFFI.ffi_type_sint, (FFIType[])new FFIType[]{LibFFI.ffi_type_pointer, LibFFI.ffi_type_sint});

        CTLRequestV(int request) {
            super(CIF, request);
        }

        @Override
        int apply(long st, long __functionAddress) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer arguments = stack.malloc(MemoryStack.POINTER_SIZE + 4);
                PointerBuffer.put((ByteBuffer)arguments, (int)0, (long)st);
                arguments.putInt(MemoryStack.POINTER_SIZE, this.request);
                ByteBuffer rvalue = stack.calloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE);
                long avalues = MemoryUtil.memAddress((ByteBuffer)arguments);
                LibFFI.ffi_call((FFICIF)this.cif, (long)__functionAddress, (ByteBuffer)rvalue, (PointerBuffer)stack.mallocPointer(2).put(0, avalues).put(1, avalues + (long)MemoryStack.POINTER_SIZE));
                int n = rvalue.getInt(0);
                return n;
            }
        }
    }

    public static abstract class CTLRequest {
        protected final FFICIF cif;
        protected final int request;

        CTLRequest(FFICIF cif, int request) {
            this.cif = cif;
            this.request = request;
        }

        abstract int apply(long var1, long var3);
    }

    public static final class Functions {
        public static final long encoder_get_size = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_encoder_get_size");
        public static final long encoder_create = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_encoder_create");
        public static final long encoder_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_encoder_init");
        public static final long encode = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_encode");
        public static final long encode_float = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_encode_float");
        public static final long encoder_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_encoder_destroy");
        public static final long encoder_ctl = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_encoder_ctl");
        public static final long decoder_get_size = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_decoder_get_size");
        public static final long decoder_create = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_decoder_create");
        public static final long decoder_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_decoder_init");
        public static final long decode = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_decode");
        public static final long decode_float = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_decode_float");
        public static final long decoder_ctl = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_decoder_ctl");
        public static final long decoder_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_decoder_destroy");
        public static final long dred_decoder_get_size = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_dred_decoder_get_size");
        public static final long dred_decoder_create = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_dred_decoder_create");
        public static final long dred_decoder_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_dred_decoder_init");
        public static final long dred_decoder_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_dred_decoder_destroy");
        public static final long dred_decoder_ctl = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_dred_decoder_ctl");
        public static final long dred_get_size = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_dred_get_size");
        public static final long dred_alloc = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_dred_alloc");
        public static final long dred_free = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_dred_free");
        public static final long dred_parse = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_dred_parse");
        public static final long dred_process = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_dred_process");
        public static final long decoder_dred_decode = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_decoder_dred_decode");
        public static final long decoder_dred_decode_float = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_decoder_dred_decode_float");
        public static final long packet_parse = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_packet_parse");
        public static final long packet_get_bandwidth = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_packet_get_bandwidth");
        public static final long packet_get_samples_per_frame = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_packet_get_samples_per_frame");
        public static final long packet_get_nb_channels = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_packet_get_nb_channels");
        public static final long packet_get_nb_frames = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_packet_get_nb_frames");
        public static final long packet_get_nb_samples = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_packet_get_nb_samples");
        public static final long packet_has_lbrr = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_packet_has_lbrr");
        public static final long decoder_get_nb_samples = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_decoder_get_nb_samples");
        public static final long pcm_soft_clip = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_pcm_soft_clip");
        public static final long repacketizer_get_size = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_repacketizer_get_size");
        public static final long repacketizer_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_repacketizer_init");
        public static final long repacketizer_create = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_repacketizer_create");
        public static final long repacketizer_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_repacketizer_destroy");
        public static final long repacketizer_cat = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_repacketizer_cat");
        public static final long repacketizer_out_range = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_repacketizer_out_range");
        public static final long repacketizer_get_nb_frames = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_repacketizer_get_nb_frames");
        public static final long repacketizer_out = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_repacketizer_out");
        public static final long packet_pad = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_packet_pad");
        public static final long packet_unpad = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_packet_unpad");
        public static final long multistream_packet_pad = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_multistream_packet_pad");
        public static final long multistream_packet_unpad = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_multistream_packet_unpad");
        public static final long strerror = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_strerror");
        public static final long get_version_string = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.access$000(), (String)"opus_get_version_string");

        private Functions() {
        }
    }
}

