/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OpusPictureTag
extends Struct<OpusPictureTag>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int MIME_TYPE;
    public static final int DESCRIPTION;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;
    public static final int COLORS;
    public static final int DATA_LENGTH;
    public static final int DATA;
    public static final int FORMAT;

    protected OpusPictureTag(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OpusPictureTag create(long address, @Nullable ByteBuffer container) {
        return new OpusPictureTag(address, container);
    }

    public OpusPictureTag(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OpusPictureTag.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="opus_int32")
    public int type() {
        return OpusPictureTag.ntype(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer mime_type(int capacity) {
        return OpusPictureTag.nmime_type(this.address(), capacity);
    }

    @NativeType(value="char *")
    public ByteBuffer description() {
        return OpusPictureTag.ndescription(this.address());
    }

    @NativeType(value="char *")
    public String descriptionString() {
        return OpusPictureTag.ndescriptionString(this.address());
    }

    @NativeType(value="opus_uint32")
    public int width() {
        return OpusPictureTag.nwidth(this.address());
    }

    @NativeType(value="opus_uint32")
    public int height() {
        return OpusPictureTag.nheight(this.address());
    }

    @NativeType(value="opus_uint32")
    public int depth() {
        return OpusPictureTag.ndepth(this.address());
    }

    @NativeType(value="opus_uint32")
    public int colors() {
        return OpusPictureTag.ncolors(this.address());
    }

    @NativeType(value="opus_uint32")
    public int data_length() {
        return OpusPictureTag.ndata_length(this.address());
    }

    @NativeType(value="unsigned char *")
    public ByteBuffer data() {
        return OpusPictureTag.ndata(this.address());
    }

    public int format() {
        return OpusPictureTag.nformat(this.address());
    }

    public static OpusPictureTag malloc() {
        return new OpusPictureTag(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OpusPictureTag calloc() {
        return new OpusPictureTag(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OpusPictureTag create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OpusPictureTag(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OpusPictureTag create(long address) {
        return new OpusPictureTag(address, null);
    }

    public static @Nullable OpusPictureTag createSafe(long address) {
        return address == 0L ? null : new OpusPictureTag(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OpusPictureTag.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OpusPictureTag.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static OpusPictureTag malloc(MemoryStack stack) {
        return new OpusPictureTag(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OpusPictureTag calloc(MemoryStack stack) {
        return new OpusPictureTag(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static ByteBuffer nmime_type(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MIME_TYPE)), (int)capacity);
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)DESCRIPTION)));
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)DESCRIPTION)));
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WIDTH));
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEIGHT));
    }

    public static int ndepth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEPTH));
    }

    public static int ncolors(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COLORS));
    }

    public static int ndata_length(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DATA_LENGTH));
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)OpusPictureTag.ndata_length(struct));
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FORMAT));
    }

    static {
        Struct.Layout layout = OpusPictureTag.__struct((Struct.Member[])new Struct.Member[]{OpusPictureTag.__member((int)4), OpusPictureTag.__member((int)POINTER_SIZE), OpusPictureTag.__member((int)POINTER_SIZE), OpusPictureTag.__member((int)4), OpusPictureTag.__member((int)4), OpusPictureTag.__member((int)4), OpusPictureTag.__member((int)4), OpusPictureTag.__member((int)4), OpusPictureTag.__member((int)POINTER_SIZE), OpusPictureTag.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        MIME_TYPE = layout.offsetof(1);
        DESCRIPTION = layout.offsetof(2);
        WIDTH = layout.offsetof(3);
        HEIGHT = layout.offsetof(4);
        DEPTH = layout.offsetof(5);
        COLORS = layout.offsetof(6);
        DATA_LENGTH = layout.offsetof(7);
        DATA = layout.offsetof(8);
        FORMAT = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<OpusPictureTag, Buffer>
    implements NativeResource {
        private static final OpusPictureTag ELEMENT_FACTORY = OpusPictureTag.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OpusPictureTag getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="opus_int32")
        public int type() {
            return OpusPictureTag.ntype(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer mime_type(int capacity) {
            return OpusPictureTag.nmime_type(this.address(), capacity);
        }

        @NativeType(value="char *")
        public ByteBuffer description() {
            return OpusPictureTag.ndescription(this.address());
        }

        @NativeType(value="char *")
        public String descriptionString() {
            return OpusPictureTag.ndescriptionString(this.address());
        }

        @NativeType(value="opus_uint32")
        public int width() {
            return OpusPictureTag.nwidth(this.address());
        }

        @NativeType(value="opus_uint32")
        public int height() {
            return OpusPictureTag.nheight(this.address());
        }

        @NativeType(value="opus_uint32")
        public int depth() {
            return OpusPictureTag.ndepth(this.address());
        }

        @NativeType(value="opus_uint32")
        public int colors() {
            return OpusPictureTag.ncolors(this.address());
        }

        @NativeType(value="opus_uint32")
        public int data_length() {
            return OpusPictureTag.ndata_length(this.address());
        }

        @NativeType(value="unsigned char *")
        public ByteBuffer data() {
            return OpusPictureTag.ndata(this.address());
        }

        public int format() {
            return OpusPictureTag.nformat(this.address());
        }
    }
}

