/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrColorf")
public class OVRColorf
extends Struct<OVRColorf>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    protected OVRColorf(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRColorf create(long address, @Nullable ByteBuffer container) {
        return new OVRColorf(address, container);
    }

    public OVRColorf(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRColorf.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return OVRColorf.nr(this.address());
    }

    public float g() {
        return OVRColorf.ng(this.address());
    }

    public float b() {
        return OVRColorf.nb(this.address());
    }

    public float a() {
        return OVRColorf.na(this.address());
    }

    public OVRColorf r(float value) {
        OVRColorf.nr(this.address(), value);
        return this;
    }

    public OVRColorf g(float value) {
        OVRColorf.ng(this.address(), value);
        return this;
    }

    public OVRColorf b(float value) {
        OVRColorf.nb(this.address(), value);
        return this;
    }

    public OVRColorf a(float value) {
        OVRColorf.na(this.address(), value);
        return this;
    }

    public OVRColorf set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public OVRColorf set(OVRColorf src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRColorf malloc() {
        return new OVRColorf(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRColorf calloc() {
        return new OVRColorf(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRColorf create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRColorf(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRColorf create(long address) {
        return new OVRColorf(address, null);
    }

    @Nullable
    public static OVRColorf createSafe(long address) {
        return address == 0L ? null : new OVRColorf(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRColorf.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRColorf.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRColorf mallocStack() {
        return OVRColorf.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRColorf callocStack() {
        return OVRColorf.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRColorf mallocStack(MemoryStack stack) {
        return OVRColorf.malloc(stack);
    }

    @Deprecated
    public static OVRColorf callocStack(MemoryStack stack) {
        return OVRColorf.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRColorf.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRColorf.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRColorf.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRColorf.calloc(capacity, stack);
    }

    public static OVRColorf malloc(MemoryStack stack) {
        return new OVRColorf(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRColorf calloc(MemoryStack stack) {
        return new OVRColorf(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)R);
    }

    public static float ng(long struct) {
        return UNSAFE.getFloat(null, struct + (long)G);
    }

    public static float nb(long struct) {
        return UNSAFE.getFloat(null, struct + (long)B);
    }

    public static float na(long struct) {
        return UNSAFE.getFloat(null, struct + (long)A);
    }

    public static void nr(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)B, value);
    }

    public static void na(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)A, value);
    }

    static {
        Struct.Layout layout = OVRColorf.__struct((Struct.Member[])new Struct.Member[]{OVRColorf.__member((int)4), OVRColorf.__member((int)4), OVRColorf.__member((int)4), OVRColorf.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRColorf, Buffer>
    implements NativeResource {
        private static final OVRColorf ELEMENT_FACTORY = OVRColorf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRColorf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float r() {
            return OVRColorf.nr(this.address());
        }

        public float g() {
            return OVRColorf.ng(this.address());
        }

        public float b() {
            return OVRColorf.nb(this.address());
        }

        public float a() {
            return OVRColorf.na(this.address());
        }

        public Buffer r(float value) {
            OVRColorf.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            OVRColorf.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            OVRColorf.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            OVRColorf.na(this.address(), value);
            return this;
        }
    }
}

