/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;

@NativeType(value="struct ovrHmdDesc")
public class OVRHmdDesc
extends Struct<OVRHmdDesc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int PRODUCTNAME;
    public static final int MANUFACTURER;
    public static final int VENDORID;
    public static final int PRODUCTID;
    public static final int SERIALNUMBER;
    public static final int FIRMWAREMAJOR;
    public static final int FIRMWAREMINOR;
    public static final int AVAILABLEHMDCAPS;
    public static final int DEFAULTHMDCAPS;
    public static final int AVAILABLETRACKINGCAPS;
    public static final int DEFAULTTRACKINGCAPS;
    public static final int DEFAULTEYEFOV;
    public static final int MAXEYEFOV;
    public static final int RESOLUTION;
    public static final int DISPLAYREFRESHRATE;

    protected OVRHmdDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRHmdDesc create(long address, @Nullable ByteBuffer container) {
        return new OVRHmdDesc(address, container);
    }

    public OVRHmdDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRHmdDesc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrHmdType")
    public int Type() {
        return OVRHmdDesc.nType(this.address());
    }

    @NativeType(value="char[64]")
    public ByteBuffer ProductName() {
        return OVRHmdDesc.nProductName(this.address());
    }

    @NativeType(value="char[64]")
    public String ProductNameString() {
        return OVRHmdDesc.nProductNameString(this.address());
    }

    @NativeType(value="char[64]")
    public ByteBuffer Manufacturer() {
        return OVRHmdDesc.nManufacturer(this.address());
    }

    @NativeType(value="char[64]")
    public String ManufacturerString() {
        return OVRHmdDesc.nManufacturerString(this.address());
    }

    public short VendorId() {
        return OVRHmdDesc.nVendorId(this.address());
    }

    public short ProductId() {
        return OVRHmdDesc.nProductId(this.address());
    }

    @NativeType(value="char[24]")
    public ByteBuffer SerialNumber() {
        return OVRHmdDesc.nSerialNumber(this.address());
    }

    @NativeType(value="char[24]")
    public String SerialNumberString() {
        return OVRHmdDesc.nSerialNumberString(this.address());
    }

    public short FirmwareMajor() {
        return OVRHmdDesc.nFirmwareMajor(this.address());
    }

    public short FirmwareMinor() {
        return OVRHmdDesc.nFirmwareMinor(this.address());
    }

    @NativeType(value="unsigned int")
    public int AvailableHmdCaps() {
        return OVRHmdDesc.nAvailableHmdCaps(this.address());
    }

    @NativeType(value="unsigned int")
    public int DefaultHmdCaps() {
        return OVRHmdDesc.nDefaultHmdCaps(this.address());
    }

    @NativeType(value="unsigned int")
    public int AvailableTrackingCaps() {
        return OVRHmdDesc.nAvailableTrackingCaps(this.address());
    }

    @NativeType(value="unsigned int")
    public int DefaultTrackingCaps() {
        return OVRHmdDesc.nDefaultTrackingCaps(this.address());
    }

    @NativeType(value="ovrFovPort[ovrEye_Count]")
    public OVRFovPort.Buffer DefaultEyeFov() {
        return OVRHmdDesc.nDefaultEyeFov(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort DefaultEyeFov(int index) {
        return OVRHmdDesc.nDefaultEyeFov(this.address(), index);
    }

    @NativeType(value="ovrFovPort[ovrEye_Count]")
    public OVRFovPort.Buffer MaxEyeFov() {
        return OVRHmdDesc.nMaxEyeFov(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort MaxEyeFov(int index) {
        return OVRHmdDesc.nMaxEyeFov(this.address(), index);
    }

    @NativeType(value="ovrSizei")
    public OVRSizei Resolution() {
        return OVRHmdDesc.nResolution(this.address());
    }

    public float DisplayRefreshRate() {
        return OVRHmdDesc.nDisplayRefreshRate(this.address());
    }

    public static OVRHmdDesc malloc() {
        return new OVRHmdDesc(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRHmdDesc calloc() {
        return new OVRHmdDesc(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRHmdDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRHmdDesc(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRHmdDesc create(long address) {
        return new OVRHmdDesc(address, null);
    }

    @Nullable
    public static OVRHmdDesc createSafe(long address) {
        return address == 0L ? null : new OVRHmdDesc(address, null);
    }

    @Deprecated
    public static OVRHmdDesc mallocStack() {
        return OVRHmdDesc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRHmdDesc callocStack() {
        return OVRHmdDesc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRHmdDesc mallocStack(MemoryStack stack) {
        return OVRHmdDesc.malloc(stack);
    }

    @Deprecated
    public static OVRHmdDesc callocStack(MemoryStack stack) {
        return OVRHmdDesc.calloc(stack);
    }

    public static OVRHmdDesc malloc(MemoryStack stack) {
        return new OVRHmdDesc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRHmdDesc calloc(MemoryStack stack) {
        return new OVRHmdDesc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static int nType(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static ByteBuffer nProductName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)PRODUCTNAME), (int)64);
    }

    public static String nProductNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)PRODUCTNAME));
    }

    public static ByteBuffer nManufacturer(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)MANUFACTURER), (int)64);
    }

    public static String nManufacturerString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)MANUFACTURER));
    }

    public static short nVendorId(long struct) {
        return UNSAFE.getShort(null, struct + (long)VENDORID);
    }

    public static short nProductId(long struct) {
        return UNSAFE.getShort(null, struct + (long)PRODUCTID);
    }

    public static ByteBuffer nSerialNumber(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)SERIALNUMBER), (int)24);
    }

    public static String nSerialNumberString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)SERIALNUMBER));
    }

    public static short nFirmwareMajor(long struct) {
        return UNSAFE.getShort(null, struct + (long)FIRMWAREMAJOR);
    }

    public static short nFirmwareMinor(long struct) {
        return UNSAFE.getShort(null, struct + (long)FIRMWAREMINOR);
    }

    public static int nAvailableHmdCaps(long struct) {
        return UNSAFE.getInt(null, struct + (long)AVAILABLEHMDCAPS);
    }

    public static int nDefaultHmdCaps(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEFAULTHMDCAPS);
    }

    public static int nAvailableTrackingCaps(long struct) {
        return UNSAFE.getInt(null, struct + (long)AVAILABLETRACKINGCAPS);
    }

    public static int nDefaultTrackingCaps(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEFAULTTRACKINGCAPS);
    }

    public static OVRFovPort.Buffer nDefaultEyeFov(long struct) {
        return OVRFovPort.create(struct + (long)DEFAULTEYEFOV, 2);
    }

    public static OVRFovPort nDefaultEyeFov(long struct, int index) {
        return OVRFovPort.create(struct + (long)DEFAULTEYEFOV + Checks.check((int)index, (int)2) * (long)OVRFovPort.SIZEOF);
    }

    public static OVRFovPort.Buffer nMaxEyeFov(long struct) {
        return OVRFovPort.create(struct + (long)MAXEYEFOV, 2);
    }

    public static OVRFovPort nMaxEyeFov(long struct, int index) {
        return OVRFovPort.create(struct + (long)MAXEYEFOV + Checks.check((int)index, (int)2) * (long)OVRFovPort.SIZEOF);
    }

    public static OVRSizei nResolution(long struct) {
        return OVRSizei.create(struct + (long)RESOLUTION);
    }

    public static float nDisplayRefreshRate(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DISPLAYREFRESHRATE);
    }

    static {
        Struct.Layout layout = OVRHmdDesc.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)POINTER_SIZE, (Struct.Member[])new Struct.Member[]{OVRHmdDesc.__member((int)4), OVRHmdDesc.__padding((int)4, (boolean)Pointer.BITS64), OVRHmdDesc.__array((int)1, (int)64), OVRHmdDesc.__array((int)1, (int)64), OVRHmdDesc.__member((int)2), OVRHmdDesc.__member((int)2), OVRHmdDesc.__array((int)1, (int)24), OVRHmdDesc.__member((int)2), OVRHmdDesc.__member((int)2), OVRHmdDesc.__member((int)4), OVRHmdDesc.__member((int)4), OVRHmdDesc.__member((int)4), OVRHmdDesc.__member((int)4), OVRHmdDesc.__array((int)OVRFovPort.SIZEOF, (int)OVRFovPort.ALIGNOF, (int)2), OVRHmdDesc.__array((int)OVRFovPort.SIZEOF, (int)OVRFovPort.ALIGNOF, (int)2), OVRHmdDesc.__member((int)OVRSizei.SIZEOF, (int)OVRSizei.ALIGNOF), OVRHmdDesc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        PRODUCTNAME = layout.offsetof(2);
        MANUFACTURER = layout.offsetof(3);
        VENDORID = layout.offsetof(4);
        PRODUCTID = layout.offsetof(5);
        SERIALNUMBER = layout.offsetof(6);
        FIRMWAREMAJOR = layout.offsetof(7);
        FIRMWAREMINOR = layout.offsetof(8);
        AVAILABLEHMDCAPS = layout.offsetof(9);
        DEFAULTHMDCAPS = layout.offsetof(10);
        AVAILABLETRACKINGCAPS = layout.offsetof(11);
        DEFAULTTRACKINGCAPS = layout.offsetof(12);
        DEFAULTEYEFOV = layout.offsetof(13);
        MAXEYEFOV = layout.offsetof(14);
        RESOLUTION = layout.offsetof(15);
        DISPLAYREFRESHRATE = layout.offsetof(16);
    }
}

