/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct parsl_annotation")
public class ParSLAnnotation
extends Struct<ParSLAnnotation> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int U_ALONG_CURVE;
    public static final int V_ACROSS_CURVE;
    public static final int SPINE_TO_EDGE_X;
    public static final int SPINE_TO_EDGE_Y;

    protected ParSLAnnotation(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ParSLAnnotation create(long address, @Nullable ByteBuffer container) {
        return new ParSLAnnotation(address, container);
    }

    public ParSLAnnotation(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ParSLAnnotation.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float u_along_curve() {
        return ParSLAnnotation.nu_along_curve(this.address());
    }

    public float v_across_curve() {
        return ParSLAnnotation.nv_across_curve(this.address());
    }

    public float spine_to_edge_x() {
        return ParSLAnnotation.nspine_to_edge_x(this.address());
    }

    public float spine_to_edge_y() {
        return ParSLAnnotation.nspine_to_edge_y(this.address());
    }

    public static ParSLAnnotation create(long address) {
        return new ParSLAnnotation(address, null);
    }

    public static @Nullable ParSLAnnotation createSafe(long address) {
        return address == 0L ? null : new ParSLAnnotation(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static float nu_along_curve(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)U_ALONG_CURVE));
    }

    public static float nv_across_curve(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)V_ACROSS_CURVE));
    }

    public static float nspine_to_edge_x(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)SPINE_TO_EDGE_X));
    }

    public static float nspine_to_edge_y(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)SPINE_TO_EDGE_Y));
    }

    static {
        Struct.Layout layout = ParSLAnnotation.__struct((Struct.Member[])new Struct.Member[]{ParSLAnnotation.__member((int)4), ParSLAnnotation.__member((int)4), ParSLAnnotation.__member((int)4), ParSLAnnotation.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        U_ALONG_CURVE = layout.offsetof(0);
        V_ACROSS_CURVE = layout.offsetof(1);
        SPINE_TO_EDGE_X = layout.offsetof(2);
        SPINE_TO_EDGE_Y = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<ParSLAnnotation, Buffer> {
        private static final ParSLAnnotation ELEMENT_FACTORY = ParSLAnnotation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ParSLAnnotation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float u_along_curve() {
            return ParSLAnnotation.nu_along_curve(this.address());
        }

        public float v_across_curve() {
            return ParSLAnnotation.nv_across_curve(this.address());
        }

        public float spine_to_edge_x() {
            return ParSLAnnotation.nspine_to_edge_x(this.address());
        }

        public float spine_to_edge_y() {
            return ParSLAnnotation.nspine_to_edge_y(this.address());
        }
    }
}

