/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.par.ParSLViewport;

@NativeType(value="struct parsl_config")
public class ParSLConfig
extends Struct<ParSLConfig>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int THICKNESS;
    public static final int FLAGS;
    public static final int U_MODE;
    public static final int CURVES_MAX_FLATNESS;
    public static final int STREAMLINES_SEED_SPACING;
    public static final int STREAMLINES_SEED_VIEWPORT;
    public static final int MITER_LIMIT;

    protected ParSLConfig(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ParSLConfig create(long address, @Nullable ByteBuffer container) {
        return new ParSLConfig(address, container);
    }

    public ParSLConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ParSLConfig.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float thickness() {
        return ParSLConfig.nthickness(this.address());
    }

    @NativeType(value="uint32_t")
    public int flags() {
        return ParSLConfig.nflags(this.address());
    }

    public int u_mode() {
        return ParSLConfig.nu_mode(this.address());
    }

    public float curves_max_flatness() {
        return ParSLConfig.ncurves_max_flatness(this.address());
    }

    public float streamlines_seed_spacing() {
        return ParSLConfig.nstreamlines_seed_spacing(this.address());
    }

    @NativeType(value="parsl_viewport")
    public ParSLViewport streamlines_seed_viewport() {
        return ParSLConfig.nstreamlines_seed_viewport(this.address());
    }

    public float miter_limit() {
        return ParSLConfig.nmiter_limit(this.address());
    }

    public ParSLConfig thickness(float value) {
        ParSLConfig.nthickness(this.address(), value);
        return this;
    }

    public ParSLConfig flags(@NativeType(value="uint32_t") int value) {
        ParSLConfig.nflags(this.address(), value);
        return this;
    }

    public ParSLConfig u_mode(int value) {
        ParSLConfig.nu_mode(this.address(), value);
        return this;
    }

    public ParSLConfig curves_max_flatness(float value) {
        ParSLConfig.ncurves_max_flatness(this.address(), value);
        return this;
    }

    public ParSLConfig streamlines_seed_spacing(float value) {
        ParSLConfig.nstreamlines_seed_spacing(this.address(), value);
        return this;
    }

    public ParSLConfig streamlines_seed_viewport(@NativeType(value="parsl_viewport") ParSLViewport value) {
        ParSLConfig.nstreamlines_seed_viewport(this.address(), value);
        return this;
    }

    public ParSLConfig streamlines_seed_viewport(Consumer<ParSLViewport> consumer) {
        consumer.accept(this.streamlines_seed_viewport());
        return this;
    }

    public ParSLConfig miter_limit(float value) {
        ParSLConfig.nmiter_limit(this.address(), value);
        return this;
    }

    public ParSLConfig set(float thickness, int flags, int u_mode, float curves_max_flatness, float streamlines_seed_spacing, ParSLViewport streamlines_seed_viewport, float miter_limit) {
        this.thickness(thickness);
        this.flags(flags);
        this.u_mode(u_mode);
        this.curves_max_flatness(curves_max_flatness);
        this.streamlines_seed_spacing(streamlines_seed_spacing);
        this.streamlines_seed_viewport(streamlines_seed_viewport);
        this.miter_limit(miter_limit);
        return this;
    }

    public ParSLConfig set(ParSLConfig src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ParSLConfig malloc() {
        return new ParSLConfig(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ParSLConfig calloc() {
        return new ParSLConfig(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ParSLConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ParSLConfig(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ParSLConfig create(long address) {
        return new ParSLConfig(address, null);
    }

    public static @Nullable ParSLConfig createSafe(long address) {
        return address == 0L ? null : new ParSLConfig(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ParSLConfig.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ParSLConfig.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ParSLConfig mallocStack() {
        return ParSLConfig.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ParSLConfig callocStack() {
        return ParSLConfig.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ParSLConfig mallocStack(MemoryStack stack) {
        return ParSLConfig.malloc(stack);
    }

    @Deprecated
    public static ParSLConfig callocStack(MemoryStack stack) {
        return ParSLConfig.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ParSLConfig.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ParSLConfig.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ParSLConfig.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ParSLConfig.calloc(capacity, stack);
    }

    public static ParSLConfig malloc(MemoryStack stack) {
        return new ParSLConfig(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ParSLConfig calloc(MemoryStack stack) {
        return new ParSLConfig(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nthickness(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)THICKNESS));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nu_mode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)U_MODE));
    }

    public static float ncurves_max_flatness(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)CURVES_MAX_FLATNESS));
    }

    public static float nstreamlines_seed_spacing(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)STREAMLINES_SEED_SPACING));
    }

    public static ParSLViewport nstreamlines_seed_viewport(long struct) {
        return ParSLViewport.create(struct + (long)STREAMLINES_SEED_VIEWPORT);
    }

    public static float nmiter_limit(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)MITER_LIMIT));
    }

    public static void nthickness(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)THICKNESS), (float)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nu_mode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)U_MODE), (int)value);
    }

    public static void ncurves_max_flatness(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)CURVES_MAX_FLATNESS), (float)value);
    }

    public static void nstreamlines_seed_spacing(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)STREAMLINES_SEED_SPACING), (float)value);
    }

    public static void nstreamlines_seed_viewport(long struct, ParSLViewport value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)STREAMLINES_SEED_VIEWPORT), (long)ParSLViewport.SIZEOF);
    }

    public static void nmiter_limit(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)MITER_LIMIT), (float)value);
    }

    static {
        Struct.Layout layout = ParSLConfig.__struct((Struct.Member[])new Struct.Member[]{ParSLConfig.__member((int)4), ParSLConfig.__member((int)4), ParSLConfig.__member((int)4), ParSLConfig.__member((int)4), ParSLConfig.__member((int)4), ParSLConfig.__member((int)ParSLViewport.SIZEOF, (int)ParSLViewport.ALIGNOF), ParSLConfig.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        THICKNESS = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        U_MODE = layout.offsetof(2);
        CURVES_MAX_FLATNESS = layout.offsetof(3);
        STREAMLINES_SEED_SPACING = layout.offsetof(4);
        STREAMLINES_SEED_VIEWPORT = layout.offsetof(5);
        MITER_LIMIT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<ParSLConfig, Buffer>
    implements NativeResource {
        private static final ParSLConfig ELEMENT_FACTORY = ParSLConfig.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ParSLConfig getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float thickness() {
            return ParSLConfig.nthickness(this.address());
        }

        @NativeType(value="uint32_t")
        public int flags() {
            return ParSLConfig.nflags(this.address());
        }

        public int u_mode() {
            return ParSLConfig.nu_mode(this.address());
        }

        public float curves_max_flatness() {
            return ParSLConfig.ncurves_max_flatness(this.address());
        }

        public float streamlines_seed_spacing() {
            return ParSLConfig.nstreamlines_seed_spacing(this.address());
        }

        @NativeType(value="parsl_viewport")
        public ParSLViewport streamlines_seed_viewport() {
            return ParSLConfig.nstreamlines_seed_viewport(this.address());
        }

        public float miter_limit() {
            return ParSLConfig.nmiter_limit(this.address());
        }

        public Buffer thickness(float value) {
            ParSLConfig.nthickness(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="uint32_t") int value) {
            ParSLConfig.nflags(this.address(), value);
            return this;
        }

        public Buffer u_mode(int value) {
            ParSLConfig.nu_mode(this.address(), value);
            return this;
        }

        public Buffer curves_max_flatness(float value) {
            ParSLConfig.ncurves_max_flatness(this.address(), value);
            return this;
        }

        public Buffer streamlines_seed_spacing(float value) {
            ParSLConfig.nstreamlines_seed_spacing(this.address(), value);
            return this;
        }

        public Buffer streamlines_seed_viewport(@NativeType(value="parsl_viewport") ParSLViewport value) {
            ParSLConfig.nstreamlines_seed_viewport(this.address(), value);
            return this;
        }

        public Buffer streamlines_seed_viewport(Consumer<ParSLViewport> consumer) {
            consumer.accept(this.streamlines_seed_viewport());
            return this;
        }

        public Buffer miter_limit(float value) {
            ParSLConfig.nmiter_limit(this.address(), value);
            return this;
        }
    }
}

