/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct rmtSampleIterator")
public class RMTSampleIterator
extends Struct<RMTSampleIterator>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLE;
    public static final int INITIAL;

    protected RMTSampleIterator(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected RMTSampleIterator create(long address, @Nullable ByteBuffer container) {
        return new RMTSampleIterator(address, container);
    }

    public RMTSampleIterator(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), RMTSampleIterator.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="rmtSample *")
    public long sample() {
        return RMTSampleIterator.nsample(this.address());
    }

    public static RMTSampleIterator malloc() {
        return new RMTSampleIterator(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static RMTSampleIterator calloc() {
        return new RMTSampleIterator(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static RMTSampleIterator create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new RMTSampleIterator(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static RMTSampleIterator create(long address) {
        return new RMTSampleIterator(address, null);
    }

    @Nullable
    public static RMTSampleIterator createSafe(long address) {
        return address == 0L ? null : new RMTSampleIterator(address, null);
    }

    public static RMTSampleIterator malloc(MemoryStack stack) {
        return new RMTSampleIterator(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RMTSampleIterator calloc(MemoryStack stack) {
        return new RMTSampleIterator(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static long nsample(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SAMPLE));
    }

    public static long ninitial(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)INITIAL));
    }

    static {
        Struct.Layout layout = RMTSampleIterator.__struct((Struct.Member[])new Struct.Member[]{RMTSampleIterator.__member((int)POINTER_SIZE), RMTSampleIterator.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLE = layout.offsetof(0);
        INITIAL = layout.offsetof(1);
    }
}

