/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.util.remotery.RMTFree;
import org.lwjgl.util.remotery.RMTFreeI;
import org.lwjgl.util.remotery.RMTInputHandler;
import org.lwjgl.util.remotery.RMTInputHandlerI;
import org.lwjgl.util.remotery.RMTMalloc;
import org.lwjgl.util.remotery.RMTMallocI;
import org.lwjgl.util.remotery.RMTPropertyHandler;
import org.lwjgl.util.remotery.RMTPropertyHandlerI;
import org.lwjgl.util.remotery.RMTRealloc;
import org.lwjgl.util.remotery.RMTReallocI;
import org.lwjgl.util.remotery.RMTSampleTreeHandler;
import org.lwjgl.util.remotery.RMTSampleTreeHandlerI;

@NativeType(value="struct rmtSettings")
public class RMTSettings
extends Struct<RMTSettings>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PORT;
    public static final int REUSE_OPEN_PORT;
    public static final int LIMIT_CONNECTIONS_TO_LOCALHOST;
    public static final int ENABLETHREADSAMPLER;
    public static final int MSSLEEPBETWEENSERVERUPDATES;
    public static final int MESSAGEQUEUESIZEINBYTES;
    public static final int MAXNBMESSAGESPERUPDATE;
    public static final int _MALLOC;
    public static final int REALLOC;
    public static final int _FREE;
    public static final int MM_CONTEXT;
    public static final int INPUT_HANDLER;
    public static final int SAMPLETREE_HANDLER;
    public static final int SAMPLETREE_CONTEXT;
    public static final int SNAPSHOT_CALLBACK;
    public static final int SNAPSHOT_CONTEXT;
    public static final int INPUT_HANDLER_CONTEXT;
    public static final int LOGPATH;

    protected RMTSettings(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected RMTSettings create(long address, @Nullable ByteBuffer container) {
        return new RMTSettings(address, container);
    }

    public RMTSettings(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), RMTSettings.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="rmtU16")
    public short port() {
        return RMTSettings.nport(this.address());
    }

    @NativeType(value="rmtBool")
    public boolean reuse_open_port() {
        return RMTSettings.nreuse_open_port(this.address()) != 0;
    }

    @NativeType(value="rmtBool")
    public boolean limit_connections_to_localhost() {
        return RMTSettings.nlimit_connections_to_localhost(this.address()) != 0;
    }

    @NativeType(value="rmtBool")
    public boolean enableThreadSampler() {
        return RMTSettings.nenableThreadSampler(this.address()) != 0;
    }

    @NativeType(value="rmtU32")
    public int msSleepBetweenServerUpdates() {
        return RMTSettings.nmsSleepBetweenServerUpdates(this.address());
    }

    @NativeType(value="rmtU32")
    public int messageQueueSizeInBytes() {
        return RMTSettings.nmessageQueueSizeInBytes(this.address());
    }

    @NativeType(value="rmtU32")
    public int maxNbMessagesPerUpdate() {
        return RMTSettings.nmaxNbMessagesPerUpdate(this.address());
    }

    @NativeType(value="rmtMallocPtr")
    public RMTMalloc _malloc() {
        return RMTSettings.n_malloc(this.address());
    }

    @NativeType(value="rmtReallocPtr")
    public RMTRealloc realloc() {
        return RMTSettings.nrealloc(this.address());
    }

    @NativeType(value="rmtFreePtr")
    public RMTFree _free() {
        return RMTSettings.n_free(this.address());
    }

    @NativeType(value="void *")
    public long mm_context() {
        return RMTSettings.nmm_context(this.address());
    }

    @Nullable
    @NativeType(value="rmtInputHandlerPtr")
    public RMTInputHandler input_handler() {
        return RMTSettings.ninput_handler(this.address());
    }

    @Nullable
    @NativeType(value="rmtSampleTreeHandlerPtr")
    public RMTSampleTreeHandler sampletree_handler() {
        return RMTSettings.nsampletree_handler(this.address());
    }

    @NativeType(value="void *")
    public long sampletree_context() {
        return RMTSettings.nsampletree_context(this.address());
    }

    @Nullable
    @NativeType(value="rmtPropertyHandlerPtr")
    public RMTPropertyHandler snapshot_callback() {
        return RMTSettings.nsnapshot_callback(this.address());
    }

    @NativeType(value="void *")
    public long snapshot_context() {
        return RMTSettings.nsnapshot_context(this.address());
    }

    @NativeType(value="void *")
    public long input_handler_context() {
        return RMTSettings.ninput_handler_context(this.address());
    }

    @Nullable
    @NativeType(value="rmtPStr")
    public ByteBuffer logPath() {
        return RMTSettings.nlogPath(this.address());
    }

    @Nullable
    @NativeType(value="rmtPStr")
    public String logPathString() {
        return RMTSettings.nlogPathString(this.address());
    }

    public RMTSettings port(@NativeType(value="rmtU16") short value) {
        RMTSettings.nport(this.address(), value);
        return this;
    }

    public RMTSettings reuse_open_port(@NativeType(value="rmtBool") boolean value) {
        RMTSettings.nreuse_open_port(this.address(), value ? 1 : 0);
        return this;
    }

    public RMTSettings limit_connections_to_localhost(@NativeType(value="rmtBool") boolean value) {
        RMTSettings.nlimit_connections_to_localhost(this.address(), value ? 1 : 0);
        return this;
    }

    public RMTSettings enableThreadSampler(@NativeType(value="rmtBool") boolean value) {
        RMTSettings.nenableThreadSampler(this.address(), value ? 1 : 0);
        return this;
    }

    public RMTSettings msSleepBetweenServerUpdates(@NativeType(value="rmtU32") int value) {
        RMTSettings.nmsSleepBetweenServerUpdates(this.address(), value);
        return this;
    }

    public RMTSettings messageQueueSizeInBytes(@NativeType(value="rmtU32") int value) {
        RMTSettings.nmessageQueueSizeInBytes(this.address(), value);
        return this;
    }

    public RMTSettings maxNbMessagesPerUpdate(@NativeType(value="rmtU32") int value) {
        RMTSettings.nmaxNbMessagesPerUpdate(this.address(), value);
        return this;
    }

    public RMTSettings _malloc(@NativeType(value="rmtMallocPtr") RMTMallocI value) {
        RMTSettings.n_malloc(this.address(), value);
        return this;
    }

    public RMTSettings realloc(@NativeType(value="rmtReallocPtr") RMTReallocI value) {
        RMTSettings.nrealloc(this.address(), value);
        return this;
    }

    public RMTSettings _free(@NativeType(value="rmtFreePtr") RMTFreeI value) {
        RMTSettings.n_free(this.address(), value);
        return this;
    }

    public RMTSettings mm_context(@NativeType(value="void *") long value) {
        RMTSettings.nmm_context(this.address(), value);
        return this;
    }

    public RMTSettings input_handler(@Nullable @NativeType(value="rmtInputHandlerPtr") RMTInputHandlerI value) {
        RMTSettings.ninput_handler(this.address(), value);
        return this;
    }

    public RMTSettings sampletree_handler(@Nullable @NativeType(value="rmtSampleTreeHandlerPtr") RMTSampleTreeHandlerI value) {
        RMTSettings.nsampletree_handler(this.address(), value);
        return this;
    }

    public RMTSettings sampletree_context(@NativeType(value="void *") long value) {
        RMTSettings.nsampletree_context(this.address(), value);
        return this;
    }

    public RMTSettings snapshot_callback(@Nullable @NativeType(value="rmtPropertyHandlerPtr") RMTPropertyHandlerI value) {
        RMTSettings.nsnapshot_callback(this.address(), value);
        return this;
    }

    public RMTSettings snapshot_context(@NativeType(value="void *") long value) {
        RMTSettings.nsnapshot_context(this.address(), value);
        return this;
    }

    public RMTSettings input_handler_context(@NativeType(value="void *") long value) {
        RMTSettings.ninput_handler_context(this.address(), value);
        return this;
    }

    public RMTSettings logPath(@Nullable @NativeType(value="rmtPStr") ByteBuffer value) {
        RMTSettings.nlogPath(this.address(), value);
        return this;
    }

    public RMTSettings set(short port, boolean reuse_open_port, boolean limit_connections_to_localhost, boolean enableThreadSampler, int msSleepBetweenServerUpdates, int messageQueueSizeInBytes, int maxNbMessagesPerUpdate, RMTMallocI _malloc, RMTReallocI realloc, RMTFreeI _free, long mm_context, @Nullable RMTInputHandlerI input_handler, @Nullable RMTSampleTreeHandlerI sampletree_handler, long sampletree_context, @Nullable RMTPropertyHandlerI snapshot_callback, long snapshot_context, long input_handler_context, @Nullable ByteBuffer logPath) {
        this.port(port);
        this.reuse_open_port(reuse_open_port);
        this.limit_connections_to_localhost(limit_connections_to_localhost);
        this.enableThreadSampler(enableThreadSampler);
        this.msSleepBetweenServerUpdates(msSleepBetweenServerUpdates);
        this.messageQueueSizeInBytes(messageQueueSizeInBytes);
        this.maxNbMessagesPerUpdate(maxNbMessagesPerUpdate);
        this._malloc(_malloc);
        this.realloc(realloc);
        this._free(_free);
        this.mm_context(mm_context);
        this.input_handler(input_handler);
        this.sampletree_handler(sampletree_handler);
        this.sampletree_context(sampletree_context);
        this.snapshot_callback(snapshot_callback);
        this.snapshot_context(snapshot_context);
        this.input_handler_context(input_handler_context);
        this.logPath(logPath);
        return this;
    }

    public RMTSettings set(RMTSettings src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static RMTSettings malloc() {
        return new RMTSettings(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static RMTSettings calloc() {
        return new RMTSettings(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static RMTSettings create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new RMTSettings(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static RMTSettings create(long address) {
        return new RMTSettings(address, null);
    }

    @Nullable
    public static RMTSettings createSafe(long address) {
        return address == 0L ? null : new RMTSettings(address, null);
    }

    @Deprecated
    public static RMTSettings mallocStack() {
        return RMTSettings.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RMTSettings callocStack() {
        return RMTSettings.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RMTSettings mallocStack(MemoryStack stack) {
        return RMTSettings.malloc(stack);
    }

    @Deprecated
    public static RMTSettings callocStack(MemoryStack stack) {
        return RMTSettings.calloc(stack);
    }

    public static RMTSettings malloc(MemoryStack stack) {
        return new RMTSettings(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RMTSettings calloc(MemoryStack stack) {
        return new RMTSettings(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static short nport(long struct) {
        return UNSAFE.getShort(null, struct + (long)PORT);
    }

    public static int nreuse_open_port(long struct) {
        return UNSAFE.getInt(null, struct + (long)REUSE_OPEN_PORT);
    }

    public static int nlimit_connections_to_localhost(long struct) {
        return UNSAFE.getInt(null, struct + (long)LIMIT_CONNECTIONS_TO_LOCALHOST);
    }

    public static int nenableThreadSampler(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENABLETHREADSAMPLER);
    }

    public static int nmsSleepBetweenServerUpdates(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSSLEEPBETWEENSERVERUPDATES);
    }

    public static int nmessageQueueSizeInBytes(long struct) {
        return UNSAFE.getInt(null, struct + (long)MESSAGEQUEUESIZEINBYTES);
    }

    public static int nmaxNbMessagesPerUpdate(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXNBMESSAGESPERUPDATE);
    }

    public static RMTMalloc n_malloc(long struct) {
        return RMTMalloc.create(MemoryUtil.memGetAddress((long)(struct + (long)_MALLOC)));
    }

    public static RMTRealloc nrealloc(long struct) {
        return RMTRealloc.create(MemoryUtil.memGetAddress((long)(struct + (long)REALLOC)));
    }

    public static RMTFree n_free(long struct) {
        return RMTFree.create(MemoryUtil.memGetAddress((long)(struct + (long)_FREE)));
    }

    public static long nmm_context(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MM_CONTEXT));
    }

    @Nullable
    public static RMTInputHandler ninput_handler(long struct) {
        return RMTInputHandler.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)INPUT_HANDLER)));
    }

    @Nullable
    public static RMTSampleTreeHandler nsampletree_handler(long struct) {
        return RMTSampleTreeHandler.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)SAMPLETREE_HANDLER)));
    }

    public static long nsampletree_context(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SAMPLETREE_CONTEXT));
    }

    @Nullable
    public static RMTPropertyHandler nsnapshot_callback(long struct) {
        return RMTPropertyHandler.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)SNAPSHOT_CALLBACK)));
    }

    public static long nsnapshot_context(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SNAPSHOT_CONTEXT));
    }

    public static long ninput_handler_context(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)INPUT_HANDLER_CONTEXT));
    }

    @Nullable
    public static ByteBuffer nlogPath(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)LOGPATH)));
    }

    @Nullable
    public static String nlogPathString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)LOGPATH)));
    }

    public static void nport(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)PORT, value);
    }

    public static void nreuse_open_port(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REUSE_OPEN_PORT, value);
    }

    public static void nlimit_connections_to_localhost(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LIMIT_CONNECTIONS_TO_LOCALHOST, value);
    }

    public static void nenableThreadSampler(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENABLETHREADSAMPLER, value);
    }

    public static void nmsSleepBetweenServerUpdates(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MSSLEEPBETWEENSERVERUPDATES, value);
    }

    public static void nmessageQueueSizeInBytes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MESSAGEQUEUESIZEINBYTES, value);
    }

    public static void nmaxNbMessagesPerUpdate(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXNBMESSAGESPERUPDATE, value);
    }

    public static void n_malloc(long struct, RMTMallocI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)_MALLOC), (long)value.address());
    }

    public static void nrealloc(long struct, RMTReallocI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)REALLOC), (long)value.address());
    }

    public static void n_free(long struct, RMTFreeI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)_FREE), (long)value.address());
    }

    public static void nmm_context(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MM_CONTEXT), (long)value);
    }

    public static void ninput_handler(long struct, @Nullable RMTInputHandlerI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INPUT_HANDLER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nsampletree_handler(long struct, @Nullable RMTSampleTreeHandlerI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SAMPLETREE_HANDLER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nsampletree_context(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SAMPLETREE_CONTEXT), (long)value);
    }

    public static void nsnapshot_callback(long struct, @Nullable RMTPropertyHandlerI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SNAPSHOT_CALLBACK), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nsnapshot_context(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SNAPSHOT_CONTEXT), (long)value);
    }

    public static void ninput_handler_context(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INPUT_HANDLER_CONTEXT), (long)value);
    }

    public static void nlogPath(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)LOGPATH), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)_MALLOC)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)REALLOC)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)_FREE)));
    }

    static {
        Struct.Layout layout = RMTSettings.__struct((Struct.Member[])new Struct.Member[]{RMTSettings.__member((int)2), RMTSettings.__member((int)4), RMTSettings.__member((int)4), RMTSettings.__member((int)4), RMTSettings.__member((int)4), RMTSettings.__member((int)4), RMTSettings.__member((int)4), RMTSettings.__member((int)POINTER_SIZE), RMTSettings.__member((int)POINTER_SIZE), RMTSettings.__member((int)POINTER_SIZE), RMTSettings.__member((int)POINTER_SIZE), RMTSettings.__member((int)POINTER_SIZE), RMTSettings.__member((int)POINTER_SIZE), RMTSettings.__member((int)POINTER_SIZE), RMTSettings.__member((int)POINTER_SIZE), RMTSettings.__member((int)POINTER_SIZE), RMTSettings.__member((int)POINTER_SIZE), RMTSettings.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PORT = layout.offsetof(0);
        REUSE_OPEN_PORT = layout.offsetof(1);
        LIMIT_CONNECTIONS_TO_LOCALHOST = layout.offsetof(2);
        ENABLETHREADSAMPLER = layout.offsetof(3);
        MSSLEEPBETWEENSERVERUPDATES = layout.offsetof(4);
        MESSAGEQUEUESIZEINBYTES = layout.offsetof(5);
        MAXNBMESSAGESPERUPDATE = layout.offsetof(6);
        _MALLOC = layout.offsetof(7);
        REALLOC = layout.offsetof(8);
        _FREE = layout.offsetof(9);
        MM_CONTEXT = layout.offsetof(10);
        INPUT_HANDLER = layout.offsetof(11);
        SAMPLETREE_HANDLER = layout.offsetof(12);
        SAMPLETREE_CONTEXT = layout.offsetof(13);
        SNAPSHOT_CALLBACK = layout.offsetof(14);
        SNAPSHOT_CONTEXT = layout.offsetof(15);
        INPUT_HANDLER_CONTEXT = layout.offsetof(16);
        LOGPATH = layout.offsetof(17);
    }
}

