/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.remotery.RMTPropertyValue;

@NativeType(value="struct rmtProperty")
public class RMTProperty
extends Struct<RMTProperty>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INITIALISED;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int VALUE;
    public static final int LASTFRAMEVALUE;
    public static final int PREVVALUE;
    public static final int PREVVALUEFRAME;
    public static final int NAME;
    public static final int DESCRIPTION;
    public static final int DEFAULTVALUE;
    public static final int PARENT;
    public static final int FIRSTCHILD;
    public static final int LASTCHILD;
    public static final int NEXTSIBLING;
    public static final int NAMEHASH;
    public static final int UNIQUEID;

    protected RMTProperty(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected RMTProperty create(long address, @Nullable ByteBuffer container) {
        return new RMTProperty(address, container);
    }

    public RMTProperty(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), RMTProperty.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="rmtBool")
    public boolean initialised() {
        return RMTProperty.ninitialised(this.address()) != 0;
    }

    @NativeType(value="rmtPropertyType")
    public int type() {
        return RMTProperty.ntype(this.address());
    }

    @NativeType(value="rmtPropertyFlags")
    public int flags() {
        return RMTProperty.nflags(this.address());
    }

    @NativeType(value="rmtPropertyValue")
    public RMTPropertyValue value() {
        return RMTProperty.nvalue(this.address());
    }

    @NativeType(value="rmtPropertyValue")
    public RMTPropertyValue lastFrameValue() {
        return RMTProperty.nlastFrameValue(this.address());
    }

    @NativeType(value="rmtPropertyValue")
    public RMTPropertyValue prevValue() {
        return RMTProperty.nprevValue(this.address());
    }

    @NativeType(value="rmtU32")
    public int prevValueFrame() {
        return RMTProperty.nprevValueFrame(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer name() {
        return RMTProperty.nname(this.address());
    }

    @NativeType(value="char const *")
    public String nameString() {
        return RMTProperty.nnameString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer description() {
        return RMTProperty.ndescription(this.address());
    }

    @NativeType(value="char const *")
    public String descriptionString() {
        return RMTProperty.ndescriptionString(this.address());
    }

    @NativeType(value="rmtPropertyValue")
    public RMTPropertyValue defaultValue() {
        return RMTProperty.ndefaultValue(this.address());
    }

    @NativeType(value="rmtProperty *")
    public @Nullable RMTProperty parent() {
        return RMTProperty.nparent(this.address());
    }

    @NativeType(value="rmtProperty *")
    public @Nullable RMTProperty firstChild() {
        return RMTProperty.nfirstChild(this.address());
    }

    @NativeType(value="rmtProperty *")
    public @Nullable RMTProperty lastChild() {
        return RMTProperty.nlastChild(this.address());
    }

    @NativeType(value="rmtProperty *")
    public @Nullable RMTProperty nextSibling() {
        return RMTProperty.nnextSibling(this.address());
    }

    @NativeType(value="rmtU32")
    public int nameHash() {
        return RMTProperty.nnameHash(this.address());
    }

    @NativeType(value="rmtU32")
    public int uniqueID() {
        return RMTProperty.nuniqueID(this.address());
    }

    public RMTProperty initialised(@NativeType(value="rmtBool") boolean value) {
        RMTProperty.ninitialised(this.address(), value ? 1 : 0);
        return this;
    }

    public RMTProperty type(@NativeType(value="rmtPropertyType") int value) {
        RMTProperty.ntype(this.address(), value);
        return this;
    }

    public RMTProperty flags(@NativeType(value="rmtPropertyFlags") int value) {
        RMTProperty.nflags(this.address(), value);
        return this;
    }

    public RMTProperty value(@NativeType(value="rmtPropertyValue") RMTPropertyValue value) {
        RMTProperty.nvalue(this.address(), value);
        return this;
    }

    public RMTProperty value(Consumer<RMTPropertyValue> consumer) {
        consumer.accept(this.value());
        return this;
    }

    public RMTProperty lastFrameValue(@NativeType(value="rmtPropertyValue") RMTPropertyValue value) {
        RMTProperty.nlastFrameValue(this.address(), value);
        return this;
    }

    public RMTProperty lastFrameValue(Consumer<RMTPropertyValue> consumer) {
        consumer.accept(this.lastFrameValue());
        return this;
    }

    public RMTProperty prevValue(@NativeType(value="rmtPropertyValue") RMTPropertyValue value) {
        RMTProperty.nprevValue(this.address(), value);
        return this;
    }

    public RMTProperty prevValue(Consumer<RMTPropertyValue> consumer) {
        consumer.accept(this.prevValue());
        return this;
    }

    public RMTProperty prevValueFrame(@NativeType(value="rmtU32") int value) {
        RMTProperty.nprevValueFrame(this.address(), value);
        return this;
    }

    public RMTProperty name(@NativeType(value="char const *") ByteBuffer value) {
        RMTProperty.nname(this.address(), value);
        return this;
    }

    public RMTProperty description(@NativeType(value="char const *") ByteBuffer value) {
        RMTProperty.ndescription(this.address(), value);
        return this;
    }

    public RMTProperty defaultValue(@NativeType(value="rmtPropertyValue") RMTPropertyValue value) {
        RMTProperty.ndefaultValue(this.address(), value);
        return this;
    }

    public RMTProperty defaultValue(Consumer<RMTPropertyValue> consumer) {
        consumer.accept(this.defaultValue());
        return this;
    }

    public RMTProperty parent(@NativeType(value="rmtProperty *") @Nullable RMTProperty value) {
        RMTProperty.nparent(this.address(), value);
        return this;
    }

    public RMTProperty firstChild(@NativeType(value="rmtProperty *") @Nullable RMTProperty value) {
        RMTProperty.nfirstChild(this.address(), value);
        return this;
    }

    public RMTProperty lastChild(@NativeType(value="rmtProperty *") @Nullable RMTProperty value) {
        RMTProperty.nlastChild(this.address(), value);
        return this;
    }

    public RMTProperty nextSibling(@NativeType(value="rmtProperty *") @Nullable RMTProperty value) {
        RMTProperty.nnextSibling(this.address(), value);
        return this;
    }

    public RMTProperty nameHash(@NativeType(value="rmtU32") int value) {
        RMTProperty.nnameHash(this.address(), value);
        return this;
    }

    public RMTProperty uniqueID(@NativeType(value="rmtU32") int value) {
        RMTProperty.nuniqueID(this.address(), value);
        return this;
    }

    public RMTProperty set(boolean initialised, int type, int flags, RMTPropertyValue value, RMTPropertyValue lastFrameValue, RMTPropertyValue prevValue, int prevValueFrame, ByteBuffer name, ByteBuffer description, RMTPropertyValue defaultValue, @Nullable RMTProperty parent, @Nullable RMTProperty firstChild, @Nullable RMTProperty lastChild, @Nullable RMTProperty nextSibling, int nameHash, int uniqueID) {
        this.initialised(initialised);
        this.type(type);
        this.flags(flags);
        this.value(value);
        this.lastFrameValue(lastFrameValue);
        this.prevValue(prevValue);
        this.prevValueFrame(prevValueFrame);
        this.name(name);
        this.description(description);
        this.defaultValue(defaultValue);
        this.parent(parent);
        this.firstChild(firstChild);
        this.lastChild(lastChild);
        this.nextSibling(nextSibling);
        this.nameHash(nameHash);
        this.uniqueID(uniqueID);
        return this;
    }

    public RMTProperty set(RMTProperty src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static RMTProperty malloc() {
        return new RMTProperty(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static RMTProperty calloc() {
        return new RMTProperty(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static RMTProperty create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new RMTProperty(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static RMTProperty create(long address) {
        return new RMTProperty(address, null);
    }

    public static @Nullable RMTProperty createSafe(long address) {
        return address == 0L ? null : new RMTProperty(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)RMTProperty.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = RMTProperty.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static RMTProperty malloc(MemoryStack stack) {
        return new RMTProperty(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RMTProperty calloc(MemoryStack stack) {
        return new RMTProperty(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ninitialised(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INITIALISED));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static RMTPropertyValue nvalue(long struct) {
        return RMTPropertyValue.create(struct + (long)VALUE);
    }

    public static RMTPropertyValue nlastFrameValue(long struct) {
        return RMTPropertyValue.create(struct + (long)LASTFRAMEVALUE);
    }

    public static RMTPropertyValue nprevValue(long struct) {
        return RMTPropertyValue.create(struct + (long)PREVVALUE);
    }

    public static int nprevValueFrame(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PREVVALUEFRAME));
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)DESCRIPTION)));
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)DESCRIPTION)));
    }

    public static RMTPropertyValue ndefaultValue(long struct) {
        return RMTPropertyValue.create(struct + (long)DEFAULTVALUE);
    }

    public static @Nullable RMTProperty nparent(long struct) {
        return RMTProperty.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PARENT)));
    }

    public static @Nullable RMTProperty nfirstChild(long struct) {
        return RMTProperty.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)FIRSTCHILD)));
    }

    public static @Nullable RMTProperty nlastChild(long struct) {
        return RMTProperty.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)LASTCHILD)));
    }

    public static @Nullable RMTProperty nnextSibling(long struct) {
        return RMTProperty.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)NEXTSIBLING)));
    }

    public static int nnameHash(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NAMEHASH));
    }

    public static int nuniqueID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)UNIQUEID));
    }

    public static void ninitialised(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INITIALISED), (int)value);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nvalue(long struct, RMTPropertyValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VALUE), (long)RMTPropertyValue.SIZEOF);
    }

    public static void nlastFrameValue(long struct, RMTPropertyValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LASTFRAMEVALUE), (long)RMTPropertyValue.SIZEOF);
    }

    public static void nprevValue(long struct, RMTPropertyValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PREVVALUE), (long)RMTPropertyValue.SIZEOF);
    }

    public static void nprevValueFrame(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PREVVALUEFRAME), (int)value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)NAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void ndescription(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)DESCRIPTION), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void ndefaultValue(long struct, RMTPropertyValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DEFAULTVALUE), (long)RMTPropertyValue.SIZEOF);
    }

    public static void nparent(long struct, @Nullable RMTProperty value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PARENT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nfirstChild(long struct, @Nullable RMTProperty value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FIRSTCHILD), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nlastChild(long struct, @Nullable RMTProperty value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LASTCHILD), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nnextSibling(long struct, @Nullable RMTProperty value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXTSIBLING), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nnameHash(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NAMEHASH), (int)value);
    }

    public static void nuniqueID(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)UNIQUEID), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DESCRIPTION)));
    }

    static {
        Struct.Layout layout = RMTProperty.__struct((Struct.Member[])new Struct.Member[]{RMTProperty.__member((int)4), RMTProperty.__member((int)4), RMTProperty.__member((int)4), RMTProperty.__member((int)RMTPropertyValue.SIZEOF, (int)RMTPropertyValue.ALIGNOF), RMTProperty.__member((int)RMTPropertyValue.SIZEOF, (int)RMTPropertyValue.ALIGNOF), RMTProperty.__member((int)RMTPropertyValue.SIZEOF, (int)RMTPropertyValue.ALIGNOF), RMTProperty.__member((int)4), RMTProperty.__member((int)POINTER_SIZE), RMTProperty.__member((int)POINTER_SIZE), RMTProperty.__member((int)RMTPropertyValue.SIZEOF, (int)RMTPropertyValue.ALIGNOF), RMTProperty.__member((int)POINTER_SIZE), RMTProperty.__member((int)POINTER_SIZE), RMTProperty.__member((int)POINTER_SIZE), RMTProperty.__member((int)POINTER_SIZE), RMTProperty.__member((int)4), RMTProperty.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INITIALISED = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        VALUE = layout.offsetof(3);
        LASTFRAMEVALUE = layout.offsetof(4);
        PREVVALUE = layout.offsetof(5);
        PREVVALUEFRAME = layout.offsetof(6);
        NAME = layout.offsetof(7);
        DESCRIPTION = layout.offsetof(8);
        DEFAULTVALUE = layout.offsetof(9);
        PARENT = layout.offsetof(10);
        FIRSTCHILD = layout.offsetof(11);
        LASTCHILD = layout.offsetof(12);
        NEXTSIBLING = layout.offsetof(13);
        NAMEHASH = layout.offsetof(14);
        UNIQUEID = layout.offsetof(15);
    }

    public static class Buffer
    extends StructBuffer<RMTProperty, Buffer>
    implements NativeResource {
        private static final RMTProperty ELEMENT_FACTORY = RMTProperty.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected RMTProperty getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="rmtBool")
        public boolean initialised() {
            return RMTProperty.ninitialised(this.address()) != 0;
        }

        @NativeType(value="rmtPropertyType")
        public int type() {
            return RMTProperty.ntype(this.address());
        }

        @NativeType(value="rmtPropertyFlags")
        public int flags() {
            return RMTProperty.nflags(this.address());
        }

        @NativeType(value="rmtPropertyValue")
        public RMTPropertyValue value() {
            return RMTProperty.nvalue(this.address());
        }

        @NativeType(value="rmtPropertyValue")
        public RMTPropertyValue lastFrameValue() {
            return RMTProperty.nlastFrameValue(this.address());
        }

        @NativeType(value="rmtPropertyValue")
        public RMTPropertyValue prevValue() {
            return RMTProperty.nprevValue(this.address());
        }

        @NativeType(value="rmtU32")
        public int prevValueFrame() {
            return RMTProperty.nprevValueFrame(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer name() {
            return RMTProperty.nname(this.address());
        }

        @NativeType(value="char const *")
        public String nameString() {
            return RMTProperty.nnameString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer description() {
            return RMTProperty.ndescription(this.address());
        }

        @NativeType(value="char const *")
        public String descriptionString() {
            return RMTProperty.ndescriptionString(this.address());
        }

        @NativeType(value="rmtPropertyValue")
        public RMTPropertyValue defaultValue() {
            return RMTProperty.ndefaultValue(this.address());
        }

        @NativeType(value="rmtProperty *")
        public @Nullable RMTProperty parent() {
            return RMTProperty.nparent(this.address());
        }

        @NativeType(value="rmtProperty *")
        public @Nullable RMTProperty firstChild() {
            return RMTProperty.nfirstChild(this.address());
        }

        @NativeType(value="rmtProperty *")
        public @Nullable RMTProperty lastChild() {
            return RMTProperty.nlastChild(this.address());
        }

        @NativeType(value="rmtProperty *")
        public @Nullable RMTProperty nextSibling() {
            return RMTProperty.nnextSibling(this.address());
        }

        @NativeType(value="rmtU32")
        public int nameHash() {
            return RMTProperty.nnameHash(this.address());
        }

        @NativeType(value="rmtU32")
        public int uniqueID() {
            return RMTProperty.nuniqueID(this.address());
        }

        public Buffer initialised(@NativeType(value="rmtBool") boolean value) {
            RMTProperty.ninitialised(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer type(@NativeType(value="rmtPropertyType") int value) {
            RMTProperty.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="rmtPropertyFlags") int value) {
            RMTProperty.nflags(this.address(), value);
            return this;
        }

        public Buffer value(@NativeType(value="rmtPropertyValue") RMTPropertyValue value) {
            RMTProperty.nvalue(this.address(), value);
            return this;
        }

        public Buffer value(Consumer<RMTPropertyValue> consumer) {
            consumer.accept(this.value());
            return this;
        }

        public Buffer lastFrameValue(@NativeType(value="rmtPropertyValue") RMTPropertyValue value) {
            RMTProperty.nlastFrameValue(this.address(), value);
            return this;
        }

        public Buffer lastFrameValue(Consumer<RMTPropertyValue> consumer) {
            consumer.accept(this.lastFrameValue());
            return this;
        }

        public Buffer prevValue(@NativeType(value="rmtPropertyValue") RMTPropertyValue value) {
            RMTProperty.nprevValue(this.address(), value);
            return this;
        }

        public Buffer prevValue(Consumer<RMTPropertyValue> consumer) {
            consumer.accept(this.prevValue());
            return this;
        }

        public Buffer prevValueFrame(@NativeType(value="rmtU32") int value) {
            RMTProperty.nprevValueFrame(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="char const *") ByteBuffer value) {
            RMTProperty.nname(this.address(), value);
            return this;
        }

        public Buffer description(@NativeType(value="char const *") ByteBuffer value) {
            RMTProperty.ndescription(this.address(), value);
            return this;
        }

        public Buffer defaultValue(@NativeType(value="rmtPropertyValue") RMTPropertyValue value) {
            RMTProperty.ndefaultValue(this.address(), value);
            return this;
        }

        public Buffer defaultValue(Consumer<RMTPropertyValue> consumer) {
            consumer.accept(this.defaultValue());
            return this;
        }

        public Buffer parent(@NativeType(value="rmtProperty *") @Nullable RMTProperty value) {
            RMTProperty.nparent(this.address(), value);
            return this;
        }

        public Buffer firstChild(@NativeType(value="rmtProperty *") @Nullable RMTProperty value) {
            RMTProperty.nfirstChild(this.address(), value);
            return this;
        }

        public Buffer lastChild(@NativeType(value="rmtProperty *") @Nullable RMTProperty value) {
            RMTProperty.nlastChild(this.address(), value);
            return this;
        }

        public Buffer nextSibling(@NativeType(value="rmtProperty *") @Nullable RMTProperty value) {
            RMTProperty.nnextSibling(this.address(), value);
            return this;
        }

        public Buffer nameHash(@NativeType(value="rmtU32") int value) {
            RMTProperty.nnameHash(this.address(), value);
            return this;
        }

        public Buffer uniqueID(@NativeType(value="rmtU32") int value) {
            RMTProperty.nuniqueID(this.address(), value);
            return this;
        }
    }
}

