/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_reflected_resource")
public class SpvcReflectedResource
extends Struct<SpvcReflectedResource>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int BASE_TYPE_ID;
    public static final int TYPE_ID;
    public static final int NAME;

    protected SpvcReflectedResource(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SpvcReflectedResource create(long address, @Nullable ByteBuffer container) {
        return new SpvcReflectedResource(address, container);
    }

    public SpvcReflectedResource(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcReflectedResource.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="spvc_variable_id")
    public int id() {
        return SpvcReflectedResource.nid(this.address());
    }

    @NativeType(value="spvc_type_id")
    public int base_type_id() {
        return SpvcReflectedResource.nbase_type_id(this.address());
    }

    @NativeType(value="spvc_type_id")
    public int type_id() {
        return SpvcReflectedResource.ntype_id(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer name() {
        return SpvcReflectedResource.nname(this.address());
    }

    @NativeType(value="char const *")
    public String nameString() {
        return SpvcReflectedResource.nnameString(this.address());
    }

    public SpvcReflectedResource id(@NativeType(value="spvc_variable_id") int value) {
        SpvcReflectedResource.nid(this.address(), value);
        return this;
    }

    public SpvcReflectedResource base_type_id(@NativeType(value="spvc_type_id") int value) {
        SpvcReflectedResource.nbase_type_id(this.address(), value);
        return this;
    }

    public SpvcReflectedResource type_id(@NativeType(value="spvc_type_id") int value) {
        SpvcReflectedResource.ntype_id(this.address(), value);
        return this;
    }

    public SpvcReflectedResource name(@NativeType(value="char const *") ByteBuffer value) {
        SpvcReflectedResource.nname(this.address(), value);
        return this;
    }

    public SpvcReflectedResource set(int id, int base_type_id, int type_id, ByteBuffer name) {
        this.id(id);
        this.base_type_id(base_type_id);
        this.type_id(type_id);
        this.name(name);
        return this;
    }

    public SpvcReflectedResource set(SpvcReflectedResource src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcReflectedResource malloc() {
        return new SpvcReflectedResource(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SpvcReflectedResource calloc() {
        return new SpvcReflectedResource(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SpvcReflectedResource create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SpvcReflectedResource(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SpvcReflectedResource create(long address) {
        return new SpvcReflectedResource(address, null);
    }

    @Nullable
    public static SpvcReflectedResource createSafe(long address) {
        return address == 0L ? null : new SpvcReflectedResource(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SpvcReflectedResource.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcReflectedResource.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcReflectedResource malloc(MemoryStack stack) {
        return new SpvcReflectedResource(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcReflectedResource calloc(MemoryStack stack) {
        return new SpvcReflectedResource(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nid(long struct) {
        return UNSAFE.getInt(null, struct + (long)ID);
    }

    public static int nbase_type_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASE_TYPE_ID);
    }

    public static int ntype_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE_ID);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static void nid(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ID, value);
    }

    public static void nbase_type_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASE_TYPE_ID, value);
    }

    public static void ntype_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE_ID, value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)NAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    static {
        Struct.Layout layout = SpvcReflectedResource.__struct((Struct.Member[])new Struct.Member[]{SpvcReflectedResource.__member((int)4), SpvcReflectedResource.__member((int)4), SpvcReflectedResource.__member((int)4), SpvcReflectedResource.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        BASE_TYPE_ID = layout.offsetof(1);
        TYPE_ID = layout.offsetof(2);
        NAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SpvcReflectedResource, Buffer>
    implements NativeResource {
        private static final SpvcReflectedResource ELEMENT_FACTORY = SpvcReflectedResource.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SpvcReflectedResource getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="spvc_variable_id")
        public int id() {
            return SpvcReflectedResource.nid(this.address());
        }

        @NativeType(value="spvc_type_id")
        public int base_type_id() {
            return SpvcReflectedResource.nbase_type_id(this.address());
        }

        @NativeType(value="spvc_type_id")
        public int type_id() {
            return SpvcReflectedResource.ntype_id(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer name() {
            return SpvcReflectedResource.nname(this.address());
        }

        @NativeType(value="char const *")
        public String nameString() {
            return SpvcReflectedResource.nnameString(this.address());
        }

        public Buffer id(@NativeType(value="spvc_variable_id") int value) {
            SpvcReflectedResource.nid(this.address(), value);
            return this;
        }

        public Buffer base_type_id(@NativeType(value="spvc_type_id") int value) {
            SpvcReflectedResource.nbase_type_id(this.address(), value);
            return this;
        }

        public Buffer type_id(@NativeType(value="spvc_type_id") int value) {
            SpvcReflectedResource.ntype_id(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="char const *") ByteBuffer value) {
            SpvcReflectedResource.nname(this.address(), value);
            return this;
        }
    }
}

