/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_entry_point")
public class SpvcEntryPoint
extends Struct<SpvcEntryPoint>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXECUTION_MODEL;
    public static final int NAME;

    protected SpvcEntryPoint(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SpvcEntryPoint create(long address, @Nullable ByteBuffer container) {
        return new SpvcEntryPoint(address, container);
    }

    public SpvcEntryPoint(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcEntryPoint.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SpvExecutionModel")
    public int execution_model() {
        return SpvcEntryPoint.nexecution_model(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer name() {
        return SpvcEntryPoint.nname(this.address());
    }

    @NativeType(value="char const *")
    public String nameString() {
        return SpvcEntryPoint.nnameString(this.address());
    }

    public SpvcEntryPoint execution_model(@NativeType(value="SpvExecutionModel") int value) {
        SpvcEntryPoint.nexecution_model(this.address(), value);
        return this;
    }

    public SpvcEntryPoint name(@NativeType(value="char const *") ByteBuffer value) {
        SpvcEntryPoint.nname(this.address(), value);
        return this;
    }

    public SpvcEntryPoint set(int execution_model, ByteBuffer name) {
        this.execution_model(execution_model);
        this.name(name);
        return this;
    }

    public SpvcEntryPoint set(SpvcEntryPoint src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcEntryPoint malloc() {
        return new SpvcEntryPoint(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SpvcEntryPoint calloc() {
        return new SpvcEntryPoint(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SpvcEntryPoint create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SpvcEntryPoint(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SpvcEntryPoint create(long address) {
        return new SpvcEntryPoint(address, null);
    }

    public static @Nullable SpvcEntryPoint createSafe(long address) {
        return address == 0L ? null : new SpvcEntryPoint(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SpvcEntryPoint.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcEntryPoint.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcEntryPoint malloc(MemoryStack stack) {
        return new SpvcEntryPoint(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcEntryPoint calloc(MemoryStack stack) {
        return new SpvcEntryPoint(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nexecution_model(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)EXECUTION_MODEL));
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static void nexecution_model(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)EXECUTION_MODEL), (int)value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)NAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    static {
        Struct.Layout layout = SpvcEntryPoint.__struct((Struct.Member[])new Struct.Member[]{SpvcEntryPoint.__member((int)4), SpvcEntryPoint.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXECUTION_MODEL = layout.offsetof(0);
        NAME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SpvcEntryPoint, Buffer>
    implements NativeResource {
        private static final SpvcEntryPoint ELEMENT_FACTORY = SpvcEntryPoint.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SpvcEntryPoint getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SpvExecutionModel")
        public int execution_model() {
            return SpvcEntryPoint.nexecution_model(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer name() {
            return SpvcEntryPoint.nname(this.address());
        }

        @NativeType(value="char const *")
        public String nameString() {
            return SpvcEntryPoint.nnameString(this.address());
        }

        public Buffer execution_model(@NativeType(value="SpvExecutionModel") int value) {
            SpvcEntryPoint.nexecution_model(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="char const *") ByteBuffer value) {
            SpvcEntryPoint.nname(this.address(), value);
            return this;
        }
    }
}

