/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.spvc.SpvcHLSLResourceBindingMapping;

@NativeType(value="struct spvc_hlsl_resource_binding")
public class SpvcHLSLResourceBinding
extends Struct<SpvcHLSLResourceBinding>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STAGE;
    public static final int DESC_SET;
    public static final int BINDING;
    public static final int CBV;
    public static final int UAV;
    public static final int SRV;
    public static final int SAMPLER;

    protected SpvcHLSLResourceBinding(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SpvcHLSLResourceBinding create(long address, @Nullable ByteBuffer container) {
        return new SpvcHLSLResourceBinding(address, container);
    }

    public SpvcHLSLResourceBinding(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcHLSLResourceBinding.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SpvExecutionModel")
    public int stage() {
        return SpvcHLSLResourceBinding.nstage(this.address());
    }

    @NativeType(value="unsigned")
    public int desc_set() {
        return SpvcHLSLResourceBinding.ndesc_set(this.address());
    }

    @NativeType(value="unsigned")
    public int binding() {
        return SpvcHLSLResourceBinding.nbinding(this.address());
    }

    @NativeType(value="spvc_hlsl_resource_binding_mapping")
    public SpvcHLSLResourceBindingMapping cbv() {
        return SpvcHLSLResourceBinding.ncbv(this.address());
    }

    @NativeType(value="spvc_hlsl_resource_binding_mapping")
    public SpvcHLSLResourceBindingMapping uav() {
        return SpvcHLSLResourceBinding.nuav(this.address());
    }

    @NativeType(value="spvc_hlsl_resource_binding_mapping")
    public SpvcHLSLResourceBindingMapping srv() {
        return SpvcHLSLResourceBinding.nsrv(this.address());
    }

    @NativeType(value="spvc_hlsl_resource_binding_mapping")
    public SpvcHLSLResourceBindingMapping sampler() {
        return SpvcHLSLResourceBinding.nsampler(this.address());
    }

    public SpvcHLSLResourceBinding stage(@NativeType(value="SpvExecutionModel") int value) {
        SpvcHLSLResourceBinding.nstage(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBinding desc_set(@NativeType(value="unsigned") int value) {
        SpvcHLSLResourceBinding.ndesc_set(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBinding binding(@NativeType(value="unsigned") int value) {
        SpvcHLSLResourceBinding.nbinding(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBinding cbv(@NativeType(value="spvc_hlsl_resource_binding_mapping") SpvcHLSLResourceBindingMapping value) {
        SpvcHLSLResourceBinding.ncbv(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBinding cbv(Consumer<SpvcHLSLResourceBindingMapping> consumer) {
        consumer.accept(this.cbv());
        return this;
    }

    public SpvcHLSLResourceBinding uav(@NativeType(value="spvc_hlsl_resource_binding_mapping") SpvcHLSLResourceBindingMapping value) {
        SpvcHLSLResourceBinding.nuav(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBinding uav(Consumer<SpvcHLSLResourceBindingMapping> consumer) {
        consumer.accept(this.uav());
        return this;
    }

    public SpvcHLSLResourceBinding srv(@NativeType(value="spvc_hlsl_resource_binding_mapping") SpvcHLSLResourceBindingMapping value) {
        SpvcHLSLResourceBinding.nsrv(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBinding srv(Consumer<SpvcHLSLResourceBindingMapping> consumer) {
        consumer.accept(this.srv());
        return this;
    }

    public SpvcHLSLResourceBinding sampler(@NativeType(value="spvc_hlsl_resource_binding_mapping") SpvcHLSLResourceBindingMapping value) {
        SpvcHLSLResourceBinding.nsampler(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBinding sampler(Consumer<SpvcHLSLResourceBindingMapping> consumer) {
        consumer.accept(this.sampler());
        return this;
    }

    public SpvcHLSLResourceBinding set(int stage, int desc_set, int binding, SpvcHLSLResourceBindingMapping cbv, SpvcHLSLResourceBindingMapping uav, SpvcHLSLResourceBindingMapping srv, SpvcHLSLResourceBindingMapping sampler) {
        this.stage(stage);
        this.desc_set(desc_set);
        this.binding(binding);
        this.cbv(cbv);
        this.uav(uav);
        this.srv(srv);
        this.sampler(sampler);
        return this;
    }

    public SpvcHLSLResourceBinding set(SpvcHLSLResourceBinding src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcHLSLResourceBinding malloc() {
        return new SpvcHLSLResourceBinding(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SpvcHLSLResourceBinding calloc() {
        return new SpvcHLSLResourceBinding(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SpvcHLSLResourceBinding create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SpvcHLSLResourceBinding(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SpvcHLSLResourceBinding create(long address) {
        return new SpvcHLSLResourceBinding(address, null);
    }

    public static @Nullable SpvcHLSLResourceBinding createSafe(long address) {
        return address == 0L ? null : new SpvcHLSLResourceBinding(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SpvcHLSLResourceBinding.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcHLSLResourceBinding.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcHLSLResourceBinding malloc(MemoryStack stack) {
        return new SpvcHLSLResourceBinding(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcHLSLResourceBinding calloc(MemoryStack stack) {
        return new SpvcHLSLResourceBinding(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstage(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STAGE));
    }

    public static int ndesc_set(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DESC_SET));
    }

    public static int nbinding(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BINDING));
    }

    public static SpvcHLSLResourceBindingMapping ncbv(long struct) {
        return SpvcHLSLResourceBindingMapping.create(struct + (long)CBV);
    }

    public static SpvcHLSLResourceBindingMapping nuav(long struct) {
        return SpvcHLSLResourceBindingMapping.create(struct + (long)UAV);
    }

    public static SpvcHLSLResourceBindingMapping nsrv(long struct) {
        return SpvcHLSLResourceBindingMapping.create(struct + (long)SRV);
    }

    public static SpvcHLSLResourceBindingMapping nsampler(long struct) {
        return SpvcHLSLResourceBindingMapping.create(struct + (long)SAMPLER);
    }

    public static void nstage(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STAGE), (int)value);
    }

    public static void ndesc_set(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DESC_SET), (int)value);
    }

    public static void nbinding(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BINDING), (int)value);
    }

    public static void ncbv(long struct, SpvcHLSLResourceBindingMapping value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CBV), (long)SpvcHLSLResourceBindingMapping.SIZEOF);
    }

    public static void nuav(long struct, SpvcHLSLResourceBindingMapping value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)UAV), (long)SpvcHLSLResourceBindingMapping.SIZEOF);
    }

    public static void nsrv(long struct, SpvcHLSLResourceBindingMapping value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SRV), (long)SpvcHLSLResourceBindingMapping.SIZEOF);
    }

    public static void nsampler(long struct, SpvcHLSLResourceBindingMapping value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SAMPLER), (long)SpvcHLSLResourceBindingMapping.SIZEOF);
    }

    static {
        Struct.Layout layout = SpvcHLSLResourceBinding.__struct((Struct.Member[])new Struct.Member[]{SpvcHLSLResourceBinding.__member((int)4), SpvcHLSLResourceBinding.__member((int)4), SpvcHLSLResourceBinding.__member((int)4), SpvcHLSLResourceBinding.__member((int)SpvcHLSLResourceBindingMapping.SIZEOF, (int)SpvcHLSLResourceBindingMapping.ALIGNOF), SpvcHLSLResourceBinding.__member((int)SpvcHLSLResourceBindingMapping.SIZEOF, (int)SpvcHLSLResourceBindingMapping.ALIGNOF), SpvcHLSLResourceBinding.__member((int)SpvcHLSLResourceBindingMapping.SIZEOF, (int)SpvcHLSLResourceBindingMapping.ALIGNOF), SpvcHLSLResourceBinding.__member((int)SpvcHLSLResourceBindingMapping.SIZEOF, (int)SpvcHLSLResourceBindingMapping.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STAGE = layout.offsetof(0);
        DESC_SET = layout.offsetof(1);
        BINDING = layout.offsetof(2);
        CBV = layout.offsetof(3);
        UAV = layout.offsetof(4);
        SRV = layout.offsetof(5);
        SAMPLER = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SpvcHLSLResourceBinding, Buffer>
    implements NativeResource {
        private static final SpvcHLSLResourceBinding ELEMENT_FACTORY = SpvcHLSLResourceBinding.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SpvcHLSLResourceBinding getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SpvExecutionModel")
        public int stage() {
            return SpvcHLSLResourceBinding.nstage(this.address());
        }

        @NativeType(value="unsigned")
        public int desc_set() {
            return SpvcHLSLResourceBinding.ndesc_set(this.address());
        }

        @NativeType(value="unsigned")
        public int binding() {
            return SpvcHLSLResourceBinding.nbinding(this.address());
        }

        @NativeType(value="spvc_hlsl_resource_binding_mapping")
        public SpvcHLSLResourceBindingMapping cbv() {
            return SpvcHLSLResourceBinding.ncbv(this.address());
        }

        @NativeType(value="spvc_hlsl_resource_binding_mapping")
        public SpvcHLSLResourceBindingMapping uav() {
            return SpvcHLSLResourceBinding.nuav(this.address());
        }

        @NativeType(value="spvc_hlsl_resource_binding_mapping")
        public SpvcHLSLResourceBindingMapping srv() {
            return SpvcHLSLResourceBinding.nsrv(this.address());
        }

        @NativeType(value="spvc_hlsl_resource_binding_mapping")
        public SpvcHLSLResourceBindingMapping sampler() {
            return SpvcHLSLResourceBinding.nsampler(this.address());
        }

        public Buffer stage(@NativeType(value="SpvExecutionModel") int value) {
            SpvcHLSLResourceBinding.nstage(this.address(), value);
            return this;
        }

        public Buffer desc_set(@NativeType(value="unsigned") int value) {
            SpvcHLSLResourceBinding.ndesc_set(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="unsigned") int value) {
            SpvcHLSLResourceBinding.nbinding(this.address(), value);
            return this;
        }

        public Buffer cbv(@NativeType(value="spvc_hlsl_resource_binding_mapping") SpvcHLSLResourceBindingMapping value) {
            SpvcHLSLResourceBinding.ncbv(this.address(), value);
            return this;
        }

        public Buffer cbv(Consumer<SpvcHLSLResourceBindingMapping> consumer) {
            consumer.accept(this.cbv());
            return this;
        }

        public Buffer uav(@NativeType(value="spvc_hlsl_resource_binding_mapping") SpvcHLSLResourceBindingMapping value) {
            SpvcHLSLResourceBinding.nuav(this.address(), value);
            return this;
        }

        public Buffer uav(Consumer<SpvcHLSLResourceBindingMapping> consumer) {
            consumer.accept(this.uav());
            return this;
        }

        public Buffer srv(@NativeType(value="spvc_hlsl_resource_binding_mapping") SpvcHLSLResourceBindingMapping value) {
            SpvcHLSLResourceBinding.nsrv(this.address(), value);
            return this;
        }

        public Buffer srv(Consumer<SpvcHLSLResourceBindingMapping> consumer) {
            consumer.accept(this.srv());
            return this;
        }

        public Buffer sampler(@NativeType(value="spvc_hlsl_resource_binding_mapping") SpvcHLSLResourceBindingMapping value) {
            SpvcHLSLResourceBinding.nsampler(this.address(), value);
            return this;
        }

        public Buffer sampler(Consumer<SpvcHLSLResourceBindingMapping> consumer) {
            consumer.accept(this.sampler());
            return this;
        }
    }
}

