/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_hlsl_root_constants")
public class SpvcHlslRootConstants
extends Struct<SpvcHlslRootConstants>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int START;
    public static final int END;
    public static final int BINDING;
    public static final int SPACE;

    protected SpvcHlslRootConstants(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SpvcHlslRootConstants create(long address, @Nullable ByteBuffer container) {
        return new SpvcHlslRootConstants(address, container);
    }

    public SpvcHlslRootConstants(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcHlslRootConstants.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int start() {
        return SpvcHlslRootConstants.nstart(this.address());
    }

    @NativeType(value="unsigned int")
    public int end() {
        return SpvcHlslRootConstants.nend(this.address());
    }

    @NativeType(value="unsigned int")
    public int binding() {
        return SpvcHlslRootConstants.nbinding(this.address());
    }

    @NativeType(value="unsigned int")
    public int space() {
        return SpvcHlslRootConstants.nspace(this.address());
    }

    public SpvcHlslRootConstants start(@NativeType(value="unsigned int") int value) {
        SpvcHlslRootConstants.nstart(this.address(), value);
        return this;
    }

    public SpvcHlslRootConstants end(@NativeType(value="unsigned int") int value) {
        SpvcHlslRootConstants.nend(this.address(), value);
        return this;
    }

    public SpvcHlslRootConstants binding(@NativeType(value="unsigned int") int value) {
        SpvcHlslRootConstants.nbinding(this.address(), value);
        return this;
    }

    public SpvcHlslRootConstants space(@NativeType(value="unsigned int") int value) {
        SpvcHlslRootConstants.nspace(this.address(), value);
        return this;
    }

    public SpvcHlslRootConstants set(int start, int end, int binding, int space) {
        this.start(start);
        this.end(end);
        this.binding(binding);
        this.space(space);
        return this;
    }

    public SpvcHlslRootConstants set(SpvcHlslRootConstants src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcHlslRootConstants malloc() {
        return new SpvcHlslRootConstants(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SpvcHlslRootConstants calloc() {
        return new SpvcHlslRootConstants(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SpvcHlslRootConstants create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SpvcHlslRootConstants(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SpvcHlslRootConstants create(long address) {
        return new SpvcHlslRootConstants(address, null);
    }

    public static @Nullable SpvcHlslRootConstants createSafe(long address) {
        return address == 0L ? null : new SpvcHlslRootConstants(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SpvcHlslRootConstants.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcHlslRootConstants.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcHlslRootConstants malloc(MemoryStack stack) {
        return new SpvcHlslRootConstants(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcHlslRootConstants calloc(MemoryStack stack) {
        return new SpvcHlslRootConstants(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstart(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)START));
    }

    public static int nend(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)END));
    }

    public static int nbinding(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BINDING));
    }

    public static int nspace(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SPACE));
    }

    public static void nstart(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)START), (int)value);
    }

    public static void nend(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)END), (int)value);
    }

    public static void nbinding(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BINDING), (int)value);
    }

    public static void nspace(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SPACE), (int)value);
    }

    static {
        Struct.Layout layout = SpvcHlslRootConstants.__struct((Struct.Member[])new Struct.Member[]{SpvcHlslRootConstants.__member((int)4), SpvcHlslRootConstants.__member((int)4), SpvcHlslRootConstants.__member((int)4), SpvcHlslRootConstants.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        START = layout.offsetof(0);
        END = layout.offsetof(1);
        BINDING = layout.offsetof(2);
        SPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SpvcHlslRootConstants, Buffer>
    implements NativeResource {
        private static final SpvcHlslRootConstants ELEMENT_FACTORY = SpvcHlslRootConstants.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SpvcHlslRootConstants getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int start() {
            return SpvcHlslRootConstants.nstart(this.address());
        }

        @NativeType(value="unsigned int")
        public int end() {
            return SpvcHlslRootConstants.nend(this.address());
        }

        @NativeType(value="unsigned int")
        public int binding() {
            return SpvcHlslRootConstants.nbinding(this.address());
        }

        @NativeType(value="unsigned int")
        public int space() {
            return SpvcHlslRootConstants.nspace(this.address());
        }

        public Buffer start(@NativeType(value="unsigned int") int value) {
            SpvcHlslRootConstants.nstart(this.address(), value);
            return this;
        }

        public Buffer end(@NativeType(value="unsigned int") int value) {
            SpvcHlslRootConstants.nend(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="unsigned int") int value) {
            SpvcHlslRootConstants.nbinding(this.address(), value);
            return this;
        }

        public Buffer space(@NativeType(value="unsigned int") int value) {
            SpvcHlslRootConstants.nspace(this.address(), value);
            return this;
        }
    }
}

