/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_msl_shader_input")
public class SpvcMslShaderInput
extends Struct<SpvcMslShaderInput>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATION;
    public static final int FORMAT;
    public static final int BUILTIN;
    public static final int VECSIZE;

    protected SpvcMslShaderInput(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SpvcMslShaderInput create(long address, @Nullable ByteBuffer container) {
        return new SpvcMslShaderInput(address, container);
    }

    public SpvcMslShaderInput(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcMslShaderInput.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int location() {
        return SpvcMslShaderInput.nlocation(this.address());
    }

    @NativeType(value="spvc_msl_vertex_format")
    public int format() {
        return SpvcMslShaderInput.nformat(this.address());
    }

    @NativeType(value="SpvBuiltIn")
    public int builtin() {
        return SpvcMslShaderInput.nbuiltin(this.address());
    }

    @NativeType(value="unsigned")
    public int vecsize() {
        return SpvcMslShaderInput.nvecsize(this.address());
    }

    public SpvcMslShaderInput location(@NativeType(value="unsigned") int value) {
        SpvcMslShaderInput.nlocation(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput format(@NativeType(value="spvc_msl_vertex_format") int value) {
        SpvcMslShaderInput.nformat(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput builtin(@NativeType(value="SpvBuiltIn") int value) {
        SpvcMslShaderInput.nbuiltin(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput vecsize(@NativeType(value="unsigned") int value) {
        SpvcMslShaderInput.nvecsize(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput set(int location, int format, int builtin, int vecsize) {
        this.location(location);
        this.format(format);
        this.builtin(builtin);
        this.vecsize(vecsize);
        return this;
    }

    public SpvcMslShaderInput set(SpvcMslShaderInput src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcMslShaderInput malloc() {
        return new SpvcMslShaderInput(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SpvcMslShaderInput calloc() {
        return new SpvcMslShaderInput(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SpvcMslShaderInput create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SpvcMslShaderInput(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SpvcMslShaderInput create(long address) {
        return new SpvcMslShaderInput(address, null);
    }

    public static @Nullable SpvcMslShaderInput createSafe(long address) {
        return address == 0L ? null : new SpvcMslShaderInput(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SpvcMslShaderInput.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcMslShaderInput.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcMslShaderInput malloc(MemoryStack stack) {
        return new SpvcMslShaderInput(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcMslShaderInput calloc(MemoryStack stack) {
        return new SpvcMslShaderInput(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlocation(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOCATION));
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FORMAT));
    }

    public static int nbuiltin(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUILTIN));
    }

    public static int nvecsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VECSIZE));
    }

    public static void nlocation(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LOCATION), (int)value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FORMAT), (int)value);
    }

    public static void nbuiltin(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BUILTIN), (int)value);
    }

    public static void nvecsize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)VECSIZE), (int)value);
    }

    static {
        Struct.Layout layout = SpvcMslShaderInput.__struct((Struct.Member[])new Struct.Member[]{SpvcMslShaderInput.__member((int)4), SpvcMslShaderInput.__member((int)4), SpvcMslShaderInput.__member((int)4), SpvcMslShaderInput.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATION = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        BUILTIN = layout.offsetof(2);
        VECSIZE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SpvcMslShaderInput, Buffer>
    implements NativeResource {
        private static final SpvcMslShaderInput ELEMENT_FACTORY = SpvcMslShaderInput.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SpvcMslShaderInput getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int location() {
            return SpvcMslShaderInput.nlocation(this.address());
        }

        @NativeType(value="spvc_msl_vertex_format")
        public int format() {
            return SpvcMslShaderInput.nformat(this.address());
        }

        @NativeType(value="SpvBuiltIn")
        public int builtin() {
            return SpvcMslShaderInput.nbuiltin(this.address());
        }

        @NativeType(value="unsigned")
        public int vecsize() {
            return SpvcMslShaderInput.nvecsize(this.address());
        }

        public Buffer location(@NativeType(value="unsigned") int value) {
            SpvcMslShaderInput.nlocation(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="spvc_msl_vertex_format") int value) {
            SpvcMslShaderInput.nformat(this.address(), value);
            return this;
        }

        public Buffer builtin(@NativeType(value="SpvBuiltIn") int value) {
            SpvcMslShaderInput.nbuiltin(this.address(), value);
            return this;
        }

        public Buffer vecsize(@NativeType(value="unsigned") int value) {
            SpvcMslShaderInput.nvecsize(this.address(), value);
            return this;
        }
    }
}

