/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.LibSTB;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBTTPackContext
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    STBTTPackContext(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBTTPackContext(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBTTPackContext.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public static STBTTPackContext malloc() {
        return STBTTPackContext.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static STBTTPackContext calloc() {
        return STBTTPackContext.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static STBTTPackContext create() {
        return new STBTTPackContext(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static STBTTPackContext create(long address) {
        return address == 0L ? null : new STBTTPackContext(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBTTPackContext.create(MemoryUtil.nmemAlloc((long)(capacity * SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBTTPackContext.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer((int)(capacity * SIZEOF)));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBTTPackContext mallocStack() {
        return STBTTPackContext.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTPackContext callocStack() {
        return STBTTPackContext.callocStack(MemoryStack.stackGet());
    }

    public static STBTTPackContext mallocStack(MemoryStack stack) {
        return STBTTPackContext.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTPackContext callocStack(MemoryStack stack) {
        return STBTTPackContext.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBTTPackContext.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBTTPackContext.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBTTPackContext.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBTTPackContext.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    static {
        LibSTB.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = STBTTPackContext.offsets(MemoryUtil.memAddress((IntBuffer)offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<STBTTPackContext, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBTTPackContext newInstance(long address) {
            return new STBTTPackContext(address, this.container);
        }

        protected int sizeof() {
            return SIZEOF;
        }
    }
}

