/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.LibSTB;
import org.lwjgl.stb.STBVorbisAlloc;
import org.lwjgl.stb.STBVorbisInfo;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class STBVorbis {
    public static final int VORBIS__no_error = 0;
    public static final int VORBIS_need_more_data = 1;
    public static final int VORBIS_invalid_api_mixing = 2;
    public static final int VORBIS_outofmem = 3;
    public static final int VORBIS_feature_not_supported = 4;
    public static final int VORBIS_too_many_channels = 5;
    public static final int VORBIS_file_open_failure = 6;
    public static final int VORBIS_seek_without_length = 7;
    public static final int VORBIS_unexpected_eof = 10;
    public static final int VORBIS_seek_invalid = 11;
    public static final int VORBIS_invalid_setup = 20;
    public static final int VORBIS_invalid_stream = 21;
    public static final int VORBIS_missing_capture_pattern = 30;
    public static final int VORBIS_invalid_stream_structure_version = 31;
    public static final int VORBIS_continued_packet_flag_invalid = 32;
    public static final int VORBIS_incorrect_stream_serial_number = 33;
    public static final int VORBIS_invalid_first_page = 34;
    public static final int VORBIS_bad_packet_type = 35;
    public static final int VORBIS_cant_find_last_page = 36;
    public static final int VORBIS_seek_failed = 37;

    protected STBVorbis() {
        throw new UnsupportedOperationException();
    }

    public static native void nstb_vorbis_get_info(long var0, long var2);

    public static STBVorbisInfo stb_vorbis_get_info(long f, STBVorbisInfo __result) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        STBVorbis.nstb_vorbis_get_info(f, __result.address());
        return __result;
    }

    public static native int nstb_vorbis_get_error(long var0);

    public static int stb_vorbis_get_error(long f) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_error(f);
    }

    public static native void nstb_vorbis_close(long var0);

    public static void stb_vorbis_close(long f) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        STBVorbis.nstb_vorbis_close(f);
    }

    public static native int nstb_vorbis_get_sample_offset(long var0);

    public static int stb_vorbis_get_sample_offset(long f) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_sample_offset(f);
    }

    public static native int nstb_vorbis_get_file_offset(long var0);

    public static int stb_vorbis_get_file_offset(long f) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_file_offset(f);
    }

    public static native long nstb_vorbis_open_pushdata(long var0, int var2, long var3, long var5, long var7);

    public static long stb_vorbis_open_pushdata(ByteBuffer datablock, IntBuffer datablock_memory_consumed_in_bytes, IntBuffer error, STBVorbisAlloc alloc_buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)datablock_memory_consumed_in_bytes, (int)1);
            Checks.check((Buffer)error, (int)1);
            if (alloc_buffer != null) {
                STBVorbisAlloc.validate(alloc_buffer.address());
            }
        }
        return STBVorbis.nstb_vorbis_open_pushdata(MemoryUtil.memAddress((ByteBuffer)datablock), datablock.remaining(), MemoryUtil.memAddress((IntBuffer)datablock_memory_consumed_in_bytes), MemoryUtil.memAddress((IntBuffer)error), MemoryUtil.memAddressSafe((Pointer)alloc_buffer));
    }

    public static native int nstb_vorbis_decode_frame_pushdata(long var0, long var2, int var4, long var5, long var7, long var9);

    public static int stb_vorbis_decode_frame_pushdata(long f, ByteBuffer datablock, IntBuffer channels, PointerBuffer output, IntBuffer samples) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
            Checks.checkSafe((Buffer)channels, (int)1);
            Checks.check((CustomBuffer)output, (int)1);
            Checks.check((Buffer)samples, (int)1);
        }
        return STBVorbis.nstb_vorbis_decode_frame_pushdata(f, MemoryUtil.memAddress((ByteBuffer)datablock), datablock.remaining(), MemoryUtil.memAddressSafe((IntBuffer)channels), MemoryUtil.memAddress((CustomBuffer)output), MemoryUtil.memAddress((IntBuffer)samples));
    }

    public static native void nstb_vorbis_flush_pushdata(long var0);

    public static void stb_vorbis_flush_pushdata(long f) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        STBVorbis.nstb_vorbis_flush_pushdata(f);
    }

    public static native int nstb_vorbis_decode_filename(long var0, long var2, long var4, long var6);

    public static int stb_vorbis_decode_filename(ByteBuffer filename, IntBuffer channels, IntBuffer sample_rate, PointerBuffer output) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((Buffer)channels, (int)1);
            Checks.check((Buffer)sample_rate, (int)1);
            Checks.check((CustomBuffer)output, (int)1);
        }
        return STBVorbis.nstb_vorbis_decode_filename(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((IntBuffer)channels), MemoryUtil.memAddress((IntBuffer)sample_rate), MemoryUtil.memAddress((CustomBuffer)output));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stb_vorbis_decode_filename(CharSequence filename, IntBuffer channels, IntBuffer sample_rate, PointerBuffer output) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)channels, (int)1);
            Checks.check((Buffer)sample_rate, (int)1);
            Checks.check((CustomBuffer)output, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = STBVorbis.nstb_vorbis_decode_filename(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)channels), MemoryUtil.memAddress((IntBuffer)sample_rate), MemoryUtil.memAddress((CustomBuffer)output));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShortBuffer stb_vorbis_decode_filename(CharSequence filename, IntBuffer channels, IntBuffer sample_rate) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)channels, (int)1);
            Checks.check((Buffer)sample_rate, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            PointerBuffer output = stack.pointers(0L);
            int __result = STBVorbis.nstb_vorbis_decode_filename(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)channels), MemoryUtil.memAddress((IntBuffer)sample_rate), MemoryUtil.memAddress((CustomBuffer)output));
            ShortBuffer shortBuffer = MemoryUtil.memShortBuffer((long)output.get(0), (int)(__result * channels.get(0)));
            return shortBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstb_vorbis_decode_memory(long var0, int var2, long var3, long var5, long var7);

    public static int stb_vorbis_decode_memory(ByteBuffer mem, IntBuffer channels, IntBuffer sample_rate, PointerBuffer output) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)channels, (int)1);
            Checks.check((Buffer)sample_rate, (int)1);
            Checks.check((CustomBuffer)output, (int)1);
        }
        return STBVorbis.nstb_vorbis_decode_memory(MemoryUtil.memAddress((ByteBuffer)mem), mem.remaining(), MemoryUtil.memAddress((IntBuffer)channels), MemoryUtil.memAddress((IntBuffer)sample_rate), MemoryUtil.memAddress((CustomBuffer)output));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShortBuffer stb_vorbis_decode_memory(ByteBuffer mem, IntBuffer channels, IntBuffer sample_rate) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)channels, (int)1);
            Checks.check((Buffer)sample_rate, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer output = stack.pointers(0L);
            int __result = STBVorbis.nstb_vorbis_decode_memory(MemoryUtil.memAddress((ByteBuffer)mem), mem.remaining(), MemoryUtil.memAddress((IntBuffer)channels), MemoryUtil.memAddress((IntBuffer)sample_rate), MemoryUtil.memAddress((CustomBuffer)output));
            ShortBuffer shortBuffer = MemoryUtil.memShortBuffer((long)output.get(0), (int)(__result * channels.get(0)));
            return shortBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstb_vorbis_open_memory(long var0, int var2, long var3, long var5);

    public static long stb_vorbis_open_memory(ByteBuffer mem, IntBuffer error, STBVorbisAlloc alloc_buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)error, (int)1);
            if (alloc_buffer != null) {
                STBVorbisAlloc.validate(alloc_buffer.address());
            }
        }
        return STBVorbis.nstb_vorbis_open_memory(MemoryUtil.memAddress((ByteBuffer)mem), mem.remaining(), MemoryUtil.memAddress((IntBuffer)error), MemoryUtil.memAddressSafe((Pointer)alloc_buffer));
    }

    public static native long nstb_vorbis_open_filename(long var0, long var2, long var4);

    public static long stb_vorbis_open_filename(ByteBuffer filename, IntBuffer error, STBVorbisAlloc alloc_buffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((Buffer)error, (int)1);
            if (alloc_buffer != null) {
                STBVorbisAlloc.validate(alloc_buffer.address());
            }
        }
        return STBVorbis.nstb_vorbis_open_filename(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((IntBuffer)error), MemoryUtil.memAddressSafe((Pointer)alloc_buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long stb_vorbis_open_filename(CharSequence filename, IntBuffer error, STBVorbisAlloc alloc_buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)error, (int)1);
            if (alloc_buffer != null) {
                STBVorbisAlloc.validate(alloc_buffer.address());
            }
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long l = STBVorbis.nstb_vorbis_open_filename(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)error), MemoryUtil.memAddressSafe((Pointer)alloc_buffer));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstb_vorbis_seek_frame(long var0, int var2);

    public static boolean stb_vorbis_seek_frame(long f, int sample_number) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_seek_frame(f, sample_number) != 0;
    }

    public static native int nstb_vorbis_seek(long var0, int var2);

    public static boolean stb_vorbis_seek(long f, int sample_number) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_seek(f, sample_number) != 0;
    }

    public static native void nstb_vorbis_seek_start(long var0);

    public static void stb_vorbis_seek_start(long f) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        STBVorbis.nstb_vorbis_seek_start(f);
    }

    public static native int nstb_vorbis_stream_length_in_samples(long var0);

    public static int stb_vorbis_stream_length_in_samples(long f) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_stream_length_in_samples(f);
    }

    public static native float nstb_vorbis_stream_length_in_seconds(long var0);

    public static float stb_vorbis_stream_length_in_seconds(long f) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_stream_length_in_seconds(f);
    }

    public static native int nstb_vorbis_get_frame_float(long var0, long var2, long var4);

    public static int stb_vorbis_get_frame_float(long f, IntBuffer channels, PointerBuffer output) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
            Checks.checkSafe((Buffer)channels, (int)1);
            Checks.check((CustomBuffer)output, (int)1);
        }
        return STBVorbis.nstb_vorbis_get_frame_float(f, MemoryUtil.memAddressSafe((IntBuffer)channels), MemoryUtil.memAddress((CustomBuffer)output));
    }

    public static native int nstb_vorbis_get_frame_short(long var0, int var2, long var3, int var5);

    public static int stb_vorbis_get_frame_short(long f, PointerBuffer buffer, int num_samples) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_frame_short(f, buffer.remaining(), MemoryUtil.memAddress((CustomBuffer)buffer), num_samples);
    }

    public static native int nstb_vorbis_get_frame_short_interleaved(long var0, int var2, long var3, int var5);

    public static int stb_vorbis_get_frame_short_interleaved(long f, int num_c, ShortBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_frame_short_interleaved(f, num_c, MemoryUtil.memAddress((ShortBuffer)buffer), buffer.remaining());
    }

    public static native int nstb_vorbis_get_samples_float(long var0, int var2, long var3, int var5);

    public static int stb_vorbis_get_samples_float(long f, PointerBuffer buffer, int num_samples) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_samples_float(f, buffer.remaining(), MemoryUtil.memAddress((CustomBuffer)buffer), num_samples);
    }

    public static native int nstb_vorbis_get_samples_float_interleaved(long var0, int var2, long var3, int var5);

    public static int stb_vorbis_get_samples_float_interleaved(long f, int channels, FloatBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_samples_float_interleaved(f, channels, MemoryUtil.memAddress((FloatBuffer)buffer), buffer.remaining());
    }

    public static native int nstb_vorbis_get_samples_short(long var0, int var2, long var3, int var5);

    public static int stb_vorbis_get_samples_short(long f, PointerBuffer buffer, int num_samples) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_samples_short(f, buffer.remaining(), MemoryUtil.memAddress((CustomBuffer)buffer), num_samples);
    }

    public static native int nstb_vorbis_get_samples_short_interleaved(long var0, int var2, long var3, int var5);

    public static int stb_vorbis_get_samples_short_interleaved(long f, int channels, ShortBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_samples_short_interleaved(f, channels, MemoryUtil.memAddress((ShortBuffer)buffer), buffer.remaining());
    }

    public static native long nstb_vorbis_open_pushdata(long var0, int var2, int[] var3, int[] var4, long var5);

    public static long stb_vorbis_open_pushdata(ByteBuffer datablock, int[] datablock_memory_consumed_in_bytes, int[] error, STBVorbisAlloc alloc_buffer) {
        if (Checks.CHECKS) {
            Checks.check((int[])datablock_memory_consumed_in_bytes, (int)1);
            Checks.check((int[])error, (int)1);
            if (alloc_buffer != null) {
                STBVorbisAlloc.validate(alloc_buffer.address());
            }
        }
        return STBVorbis.nstb_vorbis_open_pushdata(MemoryUtil.memAddress((ByteBuffer)datablock), datablock.remaining(), datablock_memory_consumed_in_bytes, error, MemoryUtil.memAddressSafe((Pointer)alloc_buffer));
    }

    public static native int nstb_vorbis_decode_frame_pushdata(long var0, long var2, int var4, int[] var5, long var6, int[] var8);

    public static int stb_vorbis_decode_frame_pushdata(long f, ByteBuffer datablock, int[] channels, PointerBuffer output, int[] samples) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
            Checks.checkSafe((int[])channels, (int)1);
            Checks.check((CustomBuffer)output, (int)1);
            Checks.check((int[])samples, (int)1);
        }
        return STBVorbis.nstb_vorbis_decode_frame_pushdata(f, MemoryUtil.memAddress((ByteBuffer)datablock), datablock.remaining(), channels, MemoryUtil.memAddress((CustomBuffer)output), samples);
    }

    public static native int nstb_vorbis_decode_filename(long var0, int[] var2, int[] var3, long var4);

    public static int stb_vorbis_decode_filename(ByteBuffer filename, int[] channels, int[] sample_rate, PointerBuffer output) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((int[])channels, (int)1);
            Checks.check((int[])sample_rate, (int)1);
            Checks.check((CustomBuffer)output, (int)1);
        }
        return STBVorbis.nstb_vorbis_decode_filename(MemoryUtil.memAddress((ByteBuffer)filename), channels, sample_rate, MemoryUtil.memAddress((CustomBuffer)output));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stb_vorbis_decode_filename(CharSequence filename, int[] channels, int[] sample_rate, PointerBuffer output) {
        if (Checks.CHECKS) {
            Checks.check((int[])channels, (int)1);
            Checks.check((int[])sample_rate, (int)1);
            Checks.check((CustomBuffer)output, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = STBVorbis.nstb_vorbis_decode_filename(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), channels, sample_rate, MemoryUtil.memAddress((CustomBuffer)output));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstb_vorbis_decode_memory(long var0, int var2, int[] var3, int[] var4, long var5);

    public static int stb_vorbis_decode_memory(ByteBuffer mem, int[] channels, int[] sample_rate, PointerBuffer output) {
        if (Checks.CHECKS) {
            Checks.check((int[])channels, (int)1);
            Checks.check((int[])sample_rate, (int)1);
            Checks.check((CustomBuffer)output, (int)1);
        }
        return STBVorbis.nstb_vorbis_decode_memory(MemoryUtil.memAddress((ByteBuffer)mem), mem.remaining(), channels, sample_rate, MemoryUtil.memAddress((CustomBuffer)output));
    }

    public static native long nstb_vorbis_open_memory(long var0, int var2, int[] var3, long var4);

    public static long stb_vorbis_open_memory(ByteBuffer mem, int[] error, STBVorbisAlloc alloc_buffer) {
        if (Checks.CHECKS) {
            Checks.check((int[])error, (int)1);
            if (alloc_buffer != null) {
                STBVorbisAlloc.validate(alloc_buffer.address());
            }
        }
        return STBVorbis.nstb_vorbis_open_memory(MemoryUtil.memAddress((ByteBuffer)mem), mem.remaining(), error, MemoryUtil.memAddressSafe((Pointer)alloc_buffer));
    }

    public static native long nstb_vorbis_open_filename(long var0, int[] var2, long var3);

    public static long stb_vorbis_open_filename(ByteBuffer filename, int[] error, STBVorbisAlloc alloc_buffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((int[])error, (int)1);
            if (alloc_buffer != null) {
                STBVorbisAlloc.validate(alloc_buffer.address());
            }
        }
        return STBVorbis.nstb_vorbis_open_filename(MemoryUtil.memAddress((ByteBuffer)filename), error, MemoryUtil.memAddressSafe((Pointer)alloc_buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long stb_vorbis_open_filename(CharSequence filename, int[] error, STBVorbisAlloc alloc_buffer) {
        if (Checks.CHECKS) {
            Checks.check((int[])error, (int)1);
            if (alloc_buffer != null) {
                STBVorbisAlloc.validate(alloc_buffer.address());
            }
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long l = STBVorbis.nstb_vorbis_open_filename(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), error, MemoryUtil.memAddressSafe((Pointer)alloc_buffer));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstb_vorbis_get_frame_float(long var0, int[] var2, long var3);

    public static int stb_vorbis_get_frame_float(long f, int[] channels, PointerBuffer output) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
            Checks.checkSafe((int[])channels, (int)1);
            Checks.check((CustomBuffer)output, (int)1);
        }
        return STBVorbis.nstb_vorbis_get_frame_float(f, channels, MemoryUtil.memAddress((CustomBuffer)output));
    }

    public static native int nstb_vorbis_get_frame_short_interleaved(long var0, int var2, short[] var3, int var4);

    public static int stb_vorbis_get_frame_short_interleaved(long f, int num_c, short[] buffer) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_frame_short_interleaved(f, num_c, buffer, buffer.length);
    }

    public static native int nstb_vorbis_get_samples_float_interleaved(long var0, int var2, float[] var3, int var4);

    public static int stb_vorbis_get_samples_float_interleaved(long f, int channels, float[] buffer) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_samples_float_interleaved(f, channels, buffer, buffer.length);
    }

    public static native int nstb_vorbis_get_samples_short_interleaved(long var0, int var2, short[] var3, int var4);

    public static int stb_vorbis_get_samples_short_interleaved(long f, int channels, short[] buffer) {
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return STBVorbis.nstb_vorbis_get_samples_short_interleaved(f, channels, buffer, buffer.length);
    }

    static {
        LibSTB.initialize();
    }
}

