/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.util.vma.VmaDeviceMemoryCallbacks;
import org.lwjgl.util.vma.VmaRecordSettings;
import org.lwjgl.util.vma.VmaVulkanFunctions;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class VmaAllocatorCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PHYSICALDEVICE;
    public static final int DEVICE;
    public static final int PREFERREDLARGEHEAPBLOCKSIZE;
    public static final int PALLOCATIONCALLBACKS;
    public static final int PDEVICEMEMORYCALLBACKS;
    public static final int FRAMEINUSECOUNT;
    public static final int PHEAPSIZELIMIT;
    public static final int PVULKANFUNCTIONS;
    public static final int PRECORDSETTINGS;
    public static final int INSTANCE;
    public static final int VULKANAPIVERSION;
    public static final int PTYPEEXTERNALMEMORYHANDLETYPES;

    public VmaAllocatorCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaAllocatorCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaAllocatorCreateFlags")
    public int flags() {
        return VmaAllocatorCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long physicalDevice() {
        return VmaAllocatorCreateInfo.nphysicalDevice(this.address());
    }

    @NativeType(value="VkDevice")
    public long device() {
        return VmaAllocatorCreateInfo.ndevice(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long preferredLargeHeapBlockSize() {
        return VmaAllocatorCreateInfo.npreferredLargeHeapBlockSize(this.address());
    }

    @Nullable
    @NativeType(value="VkAllocationCallbacks const *")
    public VkAllocationCallbacks pAllocationCallbacks() {
        return VmaAllocatorCreateInfo.npAllocationCallbacks(this.address());
    }

    @Nullable
    @NativeType(value="VmaDeviceMemoryCallbacks const *")
    public VmaDeviceMemoryCallbacks pDeviceMemoryCallbacks() {
        return VmaAllocatorCreateInfo.npDeviceMemoryCallbacks(this.address());
    }

    @NativeType(value="uint32_t")
    public int frameInUseCount() {
        return VmaAllocatorCreateInfo.nframeInUseCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDeviceSize const *")
    public LongBuffer pHeapSizeLimit(int capacity) {
        return VmaAllocatorCreateInfo.npHeapSizeLimit(this.address(), capacity);
    }

    @NativeType(value="VmaVulkanFunctions const *")
    public VmaVulkanFunctions pVulkanFunctions() {
        return VmaAllocatorCreateInfo.npVulkanFunctions(this.address());
    }

    @Nullable
    @NativeType(value="VmaRecordSettings const *")
    public VmaRecordSettings pRecordSettings() {
        return VmaAllocatorCreateInfo.npRecordSettings(this.address());
    }

    @NativeType(value="VkInstance")
    public long instance() {
        return VmaAllocatorCreateInfo.ninstance(this.address());
    }

    @NativeType(value="uint32_t")
    public int vulkanApiVersion() {
        return VmaAllocatorCreateInfo.nvulkanApiVersion(this.address());
    }

    @Nullable
    @NativeType(value="VkExternalMemoryHandleTypeFlagsKHR const *")
    public IntBuffer pTypeExternalMemoryHandleTypes(int capacity) {
        return VmaAllocatorCreateInfo.npTypeExternalMemoryHandleTypes(this.address(), capacity);
    }

    public VmaAllocatorCreateInfo flags(@NativeType(value="VmaAllocatorCreateFlags") int value) {
        VmaAllocatorCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo physicalDevice(VkPhysicalDevice value) {
        VmaAllocatorCreateInfo.nphysicalDevice(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo device(VkDevice value) {
        VmaAllocatorCreateInfo.ndevice(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo preferredLargeHeapBlockSize(@NativeType(value="VkDeviceSize") long value) {
        VmaAllocatorCreateInfo.npreferredLargeHeapBlockSize(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo pAllocationCallbacks(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
        VmaAllocatorCreateInfo.npAllocationCallbacks(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo pDeviceMemoryCallbacks(@Nullable @NativeType(value="VmaDeviceMemoryCallbacks const *") VmaDeviceMemoryCallbacks value) {
        VmaAllocatorCreateInfo.npDeviceMemoryCallbacks(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo frameInUseCount(@NativeType(value="uint32_t") int value) {
        VmaAllocatorCreateInfo.nframeInUseCount(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo pHeapSizeLimit(@Nullable @NativeType(value="VkDeviceSize const *") LongBuffer value) {
        VmaAllocatorCreateInfo.npHeapSizeLimit(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo pVulkanFunctions(@NativeType(value="VmaVulkanFunctions const *") VmaVulkanFunctions value) {
        VmaAllocatorCreateInfo.npVulkanFunctions(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo pRecordSettings(@Nullable @NativeType(value="VmaRecordSettings const *") VmaRecordSettings value) {
        VmaAllocatorCreateInfo.npRecordSettings(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo instance(VkInstance value) {
        VmaAllocatorCreateInfo.ninstance(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo vulkanApiVersion(@NativeType(value="uint32_t") int value) {
        VmaAllocatorCreateInfo.nvulkanApiVersion(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo pTypeExternalMemoryHandleTypes(@Nullable @NativeType(value="VkExternalMemoryHandleTypeFlagsKHR const *") IntBuffer value) {
        VmaAllocatorCreateInfo.npTypeExternalMemoryHandleTypes(this.address(), value);
        return this;
    }

    public VmaAllocatorCreateInfo set(int flags, VkPhysicalDevice physicalDevice, VkDevice device, long preferredLargeHeapBlockSize, @Nullable VkAllocationCallbacks pAllocationCallbacks, @Nullable VmaDeviceMemoryCallbacks pDeviceMemoryCallbacks, int frameInUseCount, @Nullable LongBuffer pHeapSizeLimit, VmaVulkanFunctions pVulkanFunctions, @Nullable VmaRecordSettings pRecordSettings, VkInstance instance, int vulkanApiVersion, @Nullable IntBuffer pTypeExternalMemoryHandleTypes) {
        this.flags(flags);
        this.physicalDevice(physicalDevice);
        this.device(device);
        this.preferredLargeHeapBlockSize(preferredLargeHeapBlockSize);
        this.pAllocationCallbacks(pAllocationCallbacks);
        this.pDeviceMemoryCallbacks(pDeviceMemoryCallbacks);
        this.frameInUseCount(frameInUseCount);
        this.pHeapSizeLimit(pHeapSizeLimit);
        this.pVulkanFunctions(pVulkanFunctions);
        this.pRecordSettings(pRecordSettings);
        this.instance(instance);
        this.vulkanApiVersion(vulkanApiVersion);
        this.pTypeExternalMemoryHandleTypes(pTypeExternalMemoryHandleTypes);
        return this;
    }

    public VmaAllocatorCreateInfo set(VmaAllocatorCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VmaAllocatorCreateInfo malloc() {
        return (VmaAllocatorCreateInfo)VmaAllocatorCreateInfo.wrap(VmaAllocatorCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaAllocatorCreateInfo calloc() {
        return (VmaAllocatorCreateInfo)VmaAllocatorCreateInfo.wrap(VmaAllocatorCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaAllocatorCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaAllocatorCreateInfo)VmaAllocatorCreateInfo.wrap(VmaAllocatorCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaAllocatorCreateInfo create(long address) {
        return (VmaAllocatorCreateInfo)VmaAllocatorCreateInfo.wrap(VmaAllocatorCreateInfo.class, (long)address);
    }

    @Nullable
    public static VmaAllocatorCreateInfo createSafe(long address) {
        return address == 0L ? null : (VmaAllocatorCreateInfo)VmaAllocatorCreateInfo.wrap(VmaAllocatorCreateInfo.class, (long)address);
    }

    @Deprecated
    public static VmaAllocatorCreateInfo mallocStack() {
        return VmaAllocatorCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaAllocatorCreateInfo callocStack() {
        return VmaAllocatorCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaAllocatorCreateInfo mallocStack(MemoryStack stack) {
        return VmaAllocatorCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VmaAllocatorCreateInfo callocStack(MemoryStack stack) {
        return VmaAllocatorCreateInfo.calloc(stack);
    }

    public static VmaAllocatorCreateInfo malloc(MemoryStack stack) {
        return (VmaAllocatorCreateInfo)VmaAllocatorCreateInfo.wrap(VmaAllocatorCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaAllocatorCreateInfo calloc(MemoryStack stack) {
        return (VmaAllocatorCreateInfo)VmaAllocatorCreateInfo.wrap(VmaAllocatorCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nphysicalDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PHYSICALDEVICE));
    }

    public static long ndevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DEVICE));
    }

    public static long npreferredLargeHeapBlockSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)PREFERREDLARGEHEAPBLOCKSIZE);
    }

    @Nullable
    public static VkAllocationCallbacks npAllocationCallbacks(long struct) {
        return VkAllocationCallbacks.createSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PALLOCATIONCALLBACKS)));
    }

    @Nullable
    public static VmaDeviceMemoryCallbacks npDeviceMemoryCallbacks(long struct) {
        return VmaDeviceMemoryCallbacks.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PDEVICEMEMORYCALLBACKS)));
    }

    public static int nframeInUseCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMEINUSECOUNT);
    }

    @Nullable
    public static LongBuffer npHeapSizeLimit(long struct, int capacity) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PHEAPSIZELIMIT)), (int)capacity);
    }

    public static VmaVulkanFunctions npVulkanFunctions(long struct) {
        return VmaVulkanFunctions.create(MemoryUtil.memGetAddress((long)(struct + (long)PVULKANFUNCTIONS)));
    }

    @Nullable
    public static VmaRecordSettings npRecordSettings(long struct) {
        return VmaRecordSettings.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PRECORDSETTINGS)));
    }

    public static long ninstance(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)INSTANCE));
    }

    public static int nvulkanApiVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)VULKANAPIVERSION);
    }

    @Nullable
    public static IntBuffer npTypeExternalMemoryHandleTypes(long struct, int capacity) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PTYPEEXTERNALMEMORYHANDLETYPES)), (int)capacity);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nphysicalDevice(long struct, VkPhysicalDevice value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PHYSICALDEVICE), (long)value.address());
    }

    public static void ndevice(long struct, VkDevice value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DEVICE), (long)value.address());
    }

    public static void npreferredLargeHeapBlockSize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PREFERREDLARGEHEAPBLOCKSIZE, value);
    }

    public static void npAllocationCallbacks(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PALLOCATIONCALLBACKS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npDeviceMemoryCallbacks(long struct, @Nullable VmaDeviceMemoryCallbacks value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEVICEMEMORYCALLBACKS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nframeInUseCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMEINUSECOUNT, value);
    }

    public static void npHeapSizeLimit(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PHEAPSIZELIMIT), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
    }

    public static void npVulkanFunctions(long struct, VmaVulkanFunctions value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVULKANFUNCTIONS), (long)value.address());
    }

    public static void npRecordSettings(long struct, @Nullable VmaRecordSettings value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PRECORDSETTINGS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ninstance(long struct, VkInstance value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INSTANCE), (long)value.address());
    }

    public static void nvulkanApiVersion(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VULKANAPIVERSION, value);
    }

    public static void npTypeExternalMemoryHandleTypes(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTYPEEXTERNALMEMORYHANDLETYPES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PHYSICALDEVICE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DEVICE)));
        long pAllocationCallbacks = MemoryUtil.memGetAddress((long)(struct + (long)PALLOCATIONCALLBACKS));
        if (pAllocationCallbacks != 0L) {
            VkAllocationCallbacks.validate((long)pAllocationCallbacks);
        }
        long pVulkanFunctions = MemoryUtil.memGetAddress((long)(struct + (long)PVULKANFUNCTIONS));
        Checks.check((long)pVulkanFunctions);
        VmaVulkanFunctions.validate(pVulkanFunctions);
        long pRecordSettings = MemoryUtil.memGetAddress((long)(struct + (long)PRECORDSETTINGS));
        if (pRecordSettings != 0L) {
            VmaRecordSettings.validate(pRecordSettings);
        }
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)INSTANCE)));
    }

    static {
        Struct.Layout layout = VmaAllocatorCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VmaAllocatorCreateInfo.__member((int)4), VmaAllocatorCreateInfo.__member((int)POINTER_SIZE), VmaAllocatorCreateInfo.__member((int)POINTER_SIZE), VmaAllocatorCreateInfo.__member((int)8), VmaAllocatorCreateInfo.__member((int)POINTER_SIZE), VmaAllocatorCreateInfo.__member((int)POINTER_SIZE), VmaAllocatorCreateInfo.__member((int)4), VmaAllocatorCreateInfo.__member((int)POINTER_SIZE), VmaAllocatorCreateInfo.__member((int)POINTER_SIZE), VmaAllocatorCreateInfo.__member((int)POINTER_SIZE), VmaAllocatorCreateInfo.__member((int)POINTER_SIZE), VmaAllocatorCreateInfo.__member((int)4), VmaAllocatorCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PHYSICALDEVICE = layout.offsetof(1);
        DEVICE = layout.offsetof(2);
        PREFERREDLARGEHEAPBLOCKSIZE = layout.offsetof(3);
        PALLOCATIONCALLBACKS = layout.offsetof(4);
        PDEVICEMEMORYCALLBACKS = layout.offsetof(5);
        FRAMEINUSECOUNT = layout.offsetof(6);
        PHEAPSIZELIMIT = layout.offsetof(7);
        PVULKANFUNCTIONS = layout.offsetof(8);
        PRECORDSETTINGS = layout.offsetof(9);
        INSTANCE = layout.offsetof(10);
        VULKANAPIVERSION = layout.offsetof(11);
        PTYPEEXTERNALMEMORYHANDLETYPES = layout.offsetof(12);
    }
}

