/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.vma.LibVma;
import org.lwjgl.util.vma.VmaAllocationCreateInfo;
import org.lwjgl.util.vma.VmaAllocationInfo;
import org.lwjgl.util.vma.VmaAllocationInfo2;
import org.lwjgl.util.vma.VmaAllocatorCreateInfo;
import org.lwjgl.util.vma.VmaAllocatorInfo;
import org.lwjgl.util.vma.VmaBudget;
import org.lwjgl.util.vma.VmaDefragmentationInfo;
import org.lwjgl.util.vma.VmaDefragmentationPassMoveInfo;
import org.lwjgl.util.vma.VmaDefragmentationStats;
import org.lwjgl.util.vma.VmaDetailedStatistics;
import org.lwjgl.util.vma.VmaPoolCreateInfo;
import org.lwjgl.util.vma.VmaStatistics;
import org.lwjgl.util.vma.VmaTotalStatistics;
import org.lwjgl.util.vma.VmaVirtualAllocationCreateInfo;
import org.lwjgl.util.vma.VmaVirtualAllocationInfo;
import org.lwjgl.util.vma.VmaVirtualBlockCreateInfo;
import org.lwjgl.vulkan.VkBufferCreateInfo;
import org.lwjgl.vulkan.VkImageCreateInfo;
import org.lwjgl.vulkan.VkMemoryRequirements;

public class Vma {
    public static final int VMA_ALLOCATOR_CREATE_EXTERNALLY_SYNCHRONIZED_BIT = 1;
    public static final int VMA_ALLOCATOR_CREATE_KHR_DEDICATED_ALLOCATION_BIT = 2;
    public static final int VMA_ALLOCATOR_CREATE_KHR_BIND_MEMORY2_BIT = 4;
    public static final int VMA_ALLOCATOR_CREATE_EXT_MEMORY_BUDGET_BIT = 8;
    public static final int VMA_ALLOCATOR_CREATE_AMD_DEVICE_COHERENT_MEMORY_BIT = 16;
    public static final int VMA_ALLOCATOR_CREATE_BUFFER_DEVICE_ADDRESS_BIT = 32;
    public static final int VMA_ALLOCATOR_CREATE_EXT_MEMORY_PRIORITY_BIT = 64;
    public static final int VMA_ALLOCATOR_CREATE_KHR_MAINTENANCE4_BIT = 128;
    public static final int VMA_ALLOCATOR_CREATE_KHR_MAINTENANCE5_BIT = 256;
    public static final int VMA_ALLOCATOR_CREATE_KHR_EXTERNAL_MEMORY_WIN32_BIT = 512;
    public static final int VMA_MEMORY_USAGE_UNKNOWN = 0;
    public static final int VMA_MEMORY_USAGE_GPU_ONLY = 1;
    public static final int VMA_MEMORY_USAGE_CPU_ONLY = 2;
    public static final int VMA_MEMORY_USAGE_CPU_TO_GPU = 3;
    public static final int VMA_MEMORY_USAGE_GPU_TO_CPU = 4;
    public static final int VMA_MEMORY_USAGE_CPU_COPY = 5;
    public static final int VMA_MEMORY_USAGE_GPU_LAZILY_ALLOCATED = 6;
    public static final int VMA_MEMORY_USAGE_AUTO = 7;
    public static final int VMA_MEMORY_USAGE_AUTO_PREFER_DEVICE = 8;
    public static final int VMA_MEMORY_USAGE_AUTO_PREFER_HOST = 9;
    public static final int VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT = 1;
    public static final int VMA_ALLOCATION_CREATE_NEVER_ALLOCATE_BIT = 2;
    public static final int VMA_ALLOCATION_CREATE_MAPPED_BIT = 4;
    public static final int VMA_ALLOCATION_CREATE_USER_DATA_COPY_STRING_BIT = 32;
    public static final int VMA_ALLOCATION_CREATE_UPPER_ADDRESS_BIT = 64;
    public static final int VMA_ALLOCATION_CREATE_DONT_BIND_BIT = 128;
    public static final int VMA_ALLOCATION_CREATE_WITHIN_BUDGET_BIT = 256;
    public static final int VMA_ALLOCATION_CREATE_CAN_ALIAS_BIT = 512;
    public static final int VMA_ALLOCATION_CREATE_HOST_ACCESS_SEQUENTIAL_WRITE_BIT = 1024;
    public static final int VMA_ALLOCATION_CREATE_HOST_ACCESS_RANDOM_BIT = 2048;
    public static final int VMA_ALLOCATION_CREATE_HOST_ACCESS_ALLOW_TRANSFER_INSTEAD_BIT = 4096;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MIN_MEMORY_BIT = 65536;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MIN_TIME_BIT = 131072;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MIN_OFFSET_BIT = 262144;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_BEST_FIT_BIT = 65536;
    public static final int VMA_VMA_ALLOCATION_CREATE_STRATEGY_FIRST_FIT_BIT = 131072;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MASK = 458752;
    public static final int VMA_POOL_CREATE_IGNORE_BUFFER_IMAGE_GRANULARITY_BIT = 2;
    public static final int VMA_POOL_CREATE_LINEAR_ALGORITHM_BIT = 4;
    public static final int VMA_POOL_CREATE_ALGORITHM_MASK = 4;
    public static final int VMA_DEFRAGMENTATION_FLAG_ALGORITHM_FAST_BIT = 1;
    public static final int VMA_DEFRAGMENTATION_FLAG_ALGORITHM_BALANCED_BIT = 2;
    public static final int VMA_DEFRAGMENTATION_FLAG_ALGORITHM_FULL_BIT = 4;
    public static final int VMA_DEFRAGMENTATION_FLAG_ALGORITHM_EXTENSIVE_BIT = 8;
    public static final int VMA_DEFRAGMENTATION_FLAG_ALGORITHM_MASK = 15;
    public static final int VMA_DEFRAGMENTATION_MOVE_OPERATION_COPY = 0;
    public static final int VMA_DEFRAGMENTATION_MOVE_OPERATION_IGNORE = 1;
    public static final int VMA_DEFRAGMENTATION_MOVE_OPERATION_DESTROY = 2;
    public static final int VMA_VIRTUAL_BLOCK_CREATE_LINEAR_ALGORITHM_BIT = 1;
    public static final int VMA_VIRTUAL_BLOCK_CREATE_ALGORITHM_MASK = 1;
    public static final int VMA_VIRTUAL_ALLOCATION_CREATE_UPPER_ADDRESS_BIT = 64;
    public static final int VMA_VIRTUAL_ALLOCATION_CREATE_STRATEGY_MIN_MEMORY_BIT = 65536;
    public static final int VMA_VIRTUAL_ALLOCATION_CREATE_STRATEGY_MIN_TIME_BIT = 131072;
    public static final int VMA_VIRTUAL_ALLOCATION_CREATE_STRATEGY_MIN_OFFSET_BIT = 262144;
    public static final int VMA_VIRTUAL_ALLOCATION_CREATE_STRATEGY_MASK = 458752;

    protected Vma() {
        throw new UnsupportedOperationException();
    }

    public static native int nvmaCreateAllocator(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaCreateAllocator(@NativeType(value="VmaAllocatorCreateInfo const *") VmaAllocatorCreateInfo pCreateInfo, @NativeType(value="VmaAllocator *") PointerBuffer pAllocator) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pAllocator, (int)1);
            VmaAllocatorCreateInfo.validate(pCreateInfo.address());
        }
        return Vma.nvmaCreateAllocator(pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pAllocator));
    }

    public static native void nvmaDestroyAllocator(long var0);

    public static void vmaDestroyAllocator(@NativeType(value="VmaAllocator") long allocator) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaDestroyAllocator(allocator);
    }

    public static native void nvmaGetAllocatorInfo(long var0, long var2);

    public static void vmaGetAllocatorInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocatorInfo *") VmaAllocatorInfo pAllocatorInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaGetAllocatorInfo(allocator, pAllocatorInfo.address());
    }

    public static native void nvmaGetPhysicalDeviceProperties(long var0, long var2);

    public static void vmaGetPhysicalDeviceProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkPhysicalDeviceProperties const **") PointerBuffer ppPhysicalDeviceProperties) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)ppPhysicalDeviceProperties, (int)1);
        }
        Vma.nvmaGetPhysicalDeviceProperties(allocator, MemoryUtil.memAddress((CustomBuffer)ppPhysicalDeviceProperties));
    }

    public static native void nvmaGetMemoryProperties(long var0, long var2);

    public static void vmaGetMemoryProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkPhysicalDeviceMemoryProperties const **") PointerBuffer ppPhysicalDeviceMemoryProperties) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)ppPhysicalDeviceMemoryProperties, (int)1);
        }
        Vma.nvmaGetMemoryProperties(allocator, MemoryUtil.memAddress((CustomBuffer)ppPhysicalDeviceMemoryProperties));
    }

    public static native void nvmaGetMemoryTypeProperties(long var0, int var2, long var3);

    public static void vmaGetMemoryTypeProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int memoryTypeIndex, @NativeType(value="VkMemoryPropertyFlags *") IntBuffer pFlags) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pFlags, (int)1);
        }
        Vma.nvmaGetMemoryTypeProperties(allocator, memoryTypeIndex, MemoryUtil.memAddress((IntBuffer)pFlags));
    }

    public static native void nvmaSetCurrentFrameIndex(long var0, int var2);

    public static void vmaSetCurrentFrameIndex(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int frameIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaSetCurrentFrameIndex(allocator, frameIndex);
    }

    public static native void nvmaCalculateStatistics(long var0, long var2);

    public static void vmaCalculateStatistics(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaTotalStatistics *") VmaTotalStatistics pStats) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaCalculateStatistics(allocator, pStats.address());
    }

    public static native void nvmaGetHeapBudgets(long var0, long var2);

    public static void vmaGetHeapBudgets(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaBudget *") VmaBudget.Buffer pBudget) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaGetHeapBudgets(allocator, pBudget.address());
    }

    public static native int nvmaFindMemoryTypeIndex(long var0, int var2, long var3, long var5);

    @NativeType(value="VkResult")
    public static int vmaFindMemoryTypeIndex(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int memoryTypeBits, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="uint32_t *") IntBuffer pMemoryTypeIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pMemoryTypeIndex, (int)1);
        }
        return Vma.nvmaFindMemoryTypeIndex(allocator, memoryTypeBits, pAllocationCreateInfo.address(), MemoryUtil.memAddress((IntBuffer)pMemoryTypeIndex));
    }

    public static native int nvmaFindMemoryTypeIndexForBufferInfo(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaFindMemoryTypeIndexForBufferInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo pBufferCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="uint32_t *") IntBuffer pMemoryTypeIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pMemoryTypeIndex, (int)1);
        }
        return Vma.nvmaFindMemoryTypeIndexForBufferInfo(allocator, pBufferCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress((IntBuffer)pMemoryTypeIndex));
    }

    public static native int nvmaFindMemoryTypeIndexForImageInfo(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaFindMemoryTypeIndexForImageInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo pImageCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="uint32_t *") IntBuffer pMemoryTypeIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pMemoryTypeIndex, (int)1);
        }
        return Vma.nvmaFindMemoryTypeIndexForImageInfo(allocator, pImageCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress((IntBuffer)pMemoryTypeIndex));
    }

    public static native int nvmaCreatePool(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaCreatePool(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPoolCreateInfo const *") VmaPoolCreateInfo pCreateInfo, @NativeType(value="VmaPool *") PointerBuffer pPool) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pPool, (int)1);
        }
        return Vma.nvmaCreatePool(allocator, pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pPool));
    }

    public static native void nvmaDestroyPool(long var0, long var2);

    public static void vmaDestroyPool(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
        }
        Vma.nvmaDestroyPool(allocator, pool);
    }

    public static native void nvmaGetPoolStatistics(long var0, long var2, long var4);

    public static void vmaGetPoolStatistics(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @NativeType(value="VmaStatistics *") VmaStatistics pPoolStats) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
        }
        Vma.nvmaGetPoolStatistics(allocator, pool, pPoolStats.address());
    }

    public static native void nvmaCalculatePoolStatistics(long var0, long var2, long var4);

    public static void vmaCalculatePoolStatistics(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @NativeType(value="VmaDetailedStatistics *") VmaDetailedStatistics pPoolStats) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
        }
        Vma.nvmaCalculatePoolStatistics(allocator, pool, pPoolStats.address());
    }

    public static native int nvmaCheckPoolCorruption(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaCheckPoolCorruption(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
        }
        return Vma.nvmaCheckPoolCorruption(allocator, pool);
    }

    public static native void nvmaGetPoolName(long var0, long var2, long var4);

    public static void vmaGetPoolName(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @NativeType(value="char const **") PointerBuffer ppName) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
            Checks.check((CustomBuffer)ppName, (int)1);
        }
        Vma.nvmaGetPoolName(allocator, pool, MemoryUtil.memAddress((CustomBuffer)ppName));
    }

    public static native void nvmaSetPoolName(long var0, long var2, long var4);

    public static void vmaSetPoolName(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @NativeType(value="char const *") @Nullable ByteBuffer pName) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
            Checks.checkNT1Safe((ByteBuffer)pName);
        }
        Vma.nvmaSetPoolName(allocator, pool, MemoryUtil.memAddressSafe((ByteBuffer)pName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void vmaSetPoolName(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @NativeType(value="char const *") @Nullable CharSequence pName) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCIISafe(pName, true);
            long pNameEncoded = pName == null ? 0L : stack.getPointerAddress();
            Vma.nvmaSetPoolName(allocator, pool, pNameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nvmaAllocateMemory(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkMemoryRequirements const *") VkMemoryRequirements pVkMemoryRequirements, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @NativeType(value="VmaAllocationInfo *") @Nullable VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pAllocation, (int)1);
        }
        return Vma.nvmaAllocateMemory(allocator, pVkMemoryRequirements.address(), pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native int nvmaAllocateMemoryPages(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemoryPages(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkMemoryRequirements const *") VkMemoryRequirements pVkMemoryRequirements, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocations, @NativeType(value="VmaAllocationInfo *") @Nullable VmaAllocationInfo.Buffer pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.checkSafe((CustomBuffer)pAllocationInfo, (int)pAllocations.remaining());
            Checks.check((CustomBuffer)pAllocations, (int)1);
        }
        return Vma.nvmaAllocateMemoryPages(allocator, pVkMemoryRequirements.address(), pCreateInfo.address(), pAllocations.remaining(), MemoryUtil.memAddress((CustomBuffer)pAllocations), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native int nvmaAllocateMemoryForBuffer(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemoryForBuffer(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBuffer") long buffer, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @NativeType(value="VmaAllocationInfo *") @Nullable VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pAllocation, (int)1);
        }
        return Vma.nvmaAllocateMemoryForBuffer(allocator, buffer, pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native int nvmaAllocateMemoryForImage(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemoryForImage(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImage") long image, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @NativeType(value="VmaAllocationInfo *") @Nullable VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pAllocation, (int)1);
        }
        return Vma.nvmaAllocateMemoryForImage(allocator, image, pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native void nvmaFreeMemory(long var0, long var2);

    public static void vmaFreeMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation const") long allocation) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaFreeMemory(allocator, allocation);
    }

    public static native void nvmaFreeMemoryPages(long var0, long var2, long var4);

    public static void vmaFreeMemoryPages(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation const *") PointerBuffer pAllocations) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaFreeMemoryPages(allocator, pAllocations.remaining(), MemoryUtil.memAddress((CustomBuffer)pAllocations));
    }

    public static native void nvmaGetAllocationInfo(long var0, long var2, long var4);

    public static void vmaGetAllocationInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaGetAllocationInfo(allocator, allocation, pAllocationInfo.address());
    }

    public static native void nvmaGetAllocationInfo2(long var0, long var2, long var4);

    public static void vmaGetAllocationInfo2(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VmaAllocationInfo2 *") VmaAllocationInfo2 pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaGetAllocationInfo2(allocator, allocation, pAllocationInfo.address());
    }

    public static native void nvmaSetAllocationUserData(long var0, long var2, long var4);

    public static void vmaSetAllocationUserData(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="void *") long pUserData) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaSetAllocationUserData(allocator, allocation, pUserData);
    }

    public static native void nvmaSetAllocationName(long var0, long var2, long var4);

    public static void vmaSetAllocationName(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="char const *") @Nullable ByteBuffer pName) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
            Checks.checkNT1Safe((ByteBuffer)pName);
        }
        Vma.nvmaSetAllocationName(allocator, allocation, MemoryUtil.memAddressSafe((ByteBuffer)pName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void vmaSetAllocationName(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="char const *") @Nullable CharSequence pName) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(pName, true);
            long pNameEncoded = pName == null ? 0L : stack.getPointerAddress();
            Vma.nvmaSetAllocationName(allocator, allocation, pNameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nvmaGetAllocationMemoryProperties(long var0, long var2, long var4);

    public static void vmaGetAllocationMemoryProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkMemoryPropertyFlags *") IntBuffer pFlags) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
            Checks.check((Buffer)pFlags, (int)1);
        }
        Vma.nvmaGetAllocationMemoryProperties(allocator, allocation, MemoryUtil.memAddress((IntBuffer)pFlags));
    }

    public static native int nvmaGetMemoryWin32Handle(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaGetMemoryWin32Handle(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="HANDLE") long hTargetProcess, @NativeType(value="HANDLE *") PointerBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
            Checks.check((CustomBuffer)pHandle, (int)1);
        }
        return Vma.nvmaGetMemoryWin32Handle(allocator, allocation, hTargetProcess, MemoryUtil.memAddress((CustomBuffer)pHandle));
    }

    public static native int nvmaMapMemory(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaMapMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="void **") PointerBuffer ppData) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
            Checks.check((CustomBuffer)ppData, (int)1);
        }
        return Vma.nvmaMapMemory(allocator, allocation, MemoryUtil.memAddress((CustomBuffer)ppData));
    }

    public static native void nvmaUnmapMemory(long var0, long var2);

    public static void vmaUnmapMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaUnmapMemory(allocator, allocation);
    }

    public static native void nvmaFlushAllocation(long var0, long var2, long var4, long var6);

    public static void vmaFlushAllocation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long offset, @NativeType(value="VkDeviceSize") long size) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaFlushAllocation(allocator, allocation, offset, size);
    }

    public static native void nvmaInvalidateAllocation(long var0, long var2, long var4, long var6);

    public static void vmaInvalidateAllocation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long offset, @NativeType(value="VkDeviceSize") long size) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaInvalidateAllocation(allocator, allocation, offset, size);
    }

    public static native int nvmaFlushAllocations(long var0, int var2, long var3, long var5, long var7);

    @NativeType(value="VkResult")
    public static int vmaFlushAllocations(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation const *") PointerBuffer allocations, @NativeType(value="VkDeviceSize const *") @Nullable LongBuffer offsets, @NativeType(value="VkDeviceSize const *") @Nullable LongBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.checkSafe((Buffer)offsets, (int)allocations.remaining());
            Checks.checkSafe((Buffer)sizes, (int)allocations.remaining());
        }
        return Vma.nvmaFlushAllocations(allocator, allocations.remaining(), MemoryUtil.memAddress((CustomBuffer)allocations), MemoryUtil.memAddressSafe((LongBuffer)offsets), MemoryUtil.memAddressSafe((LongBuffer)sizes));
    }

    public static native int nvmaInvalidateAllocations(long var0, int var2, long var3, long var5, long var7);

    @NativeType(value="VkResult")
    public static int vmaInvalidateAllocations(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation const *") PointerBuffer allocations, @NativeType(value="VkDeviceSize const *") @Nullable LongBuffer offsets, @NativeType(value="VkDeviceSize const *") @Nullable LongBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.checkSafe((Buffer)offsets, (int)allocations.remaining());
            Checks.checkSafe((Buffer)sizes, (int)allocations.remaining());
        }
        return Vma.nvmaInvalidateAllocations(allocator, allocations.remaining(), MemoryUtil.memAddress((CustomBuffer)allocations), MemoryUtil.memAddressSafe((LongBuffer)offsets), MemoryUtil.memAddressSafe((LongBuffer)sizes));
    }

    public static native int nvmaCopyMemoryToAllocation(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaCopyMemoryToAllocation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="void const *") ByteBuffer pSrcHostPointer, @NativeType(value="VmaAllocation") long dstAllocation, @NativeType(value="VkDeviceSize") long dstAllocationLocalOffset) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)dstAllocation);
        }
        return Vma.nvmaCopyMemoryToAllocation(allocator, MemoryUtil.memAddress((ByteBuffer)pSrcHostPointer), dstAllocation, dstAllocationLocalOffset, pSrcHostPointer.remaining());
    }

    public static native int nvmaCopyAllocationToMemory(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaCopyAllocationToMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long srcAllocation, @NativeType(value="VkDeviceSize") long srcAllocationLocalOffset, @NativeType(value="void *") ByteBuffer pDstHostPointer) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)srcAllocation);
        }
        return Vma.nvmaCopyAllocationToMemory(allocator, srcAllocation, srcAllocationLocalOffset, MemoryUtil.memAddress((ByteBuffer)pDstHostPointer), pDstHostPointer.remaining());
    }

    public static native int nvmaCheckCorruption(long var0, int var2);

    @NativeType(value="VkResult")
    public static int vmaCheckCorruption(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int memoryTypeBits) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        return Vma.nvmaCheckCorruption(allocator, memoryTypeBits);
    }

    public static native int nvmaBeginDefragmentation(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaBeginDefragmentation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaDefragmentationInfo const *") VmaDefragmentationInfo pInfo, @NativeType(value="VmaDefragmentationContext *") PointerBuffer pContext) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pContext, (int)1);
        }
        return Vma.nvmaBeginDefragmentation(allocator, pInfo.address(), MemoryUtil.memAddress((CustomBuffer)pContext));
    }

    public static native void nvmaEndDefragmentation(long var0, long var2, long var4);

    public static void vmaEndDefragmentation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaDefragmentationContext") long context, @NativeType(value="VmaDefragmentationStats *") @Nullable VmaDefragmentationStats pStats) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)context);
        }
        Vma.nvmaEndDefragmentation(allocator, context, MemoryUtil.memAddressSafe((Pointer)pStats));
    }

    public static native int nvmaBeginDefragmentationPass(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaBeginDefragmentationPass(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaDefragmentationContext") long context, @NativeType(value="VmaDefragmentationPassMoveInfo *") VmaDefragmentationPassMoveInfo pInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)context);
        }
        return Vma.nvmaBeginDefragmentationPass(allocator, context, pInfo.address());
    }

    public static native int nvmaEndDefragmentationPass(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaEndDefragmentationPass(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaDefragmentationContext") long context, @NativeType(value="VmaDefragmentationPassMoveInfo *") VmaDefragmentationPassMoveInfo pPassInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)context);
        }
        return Vma.nvmaEndDefragmentationPass(allocator, context, pPassInfo.address());
    }

    public static native int nvmaBindBufferMemory(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaBindBufferMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkBuffer") long buffer) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        return Vma.nvmaBindBufferMemory(allocator, allocation, buffer);
    }

    public static native int nvmaBindBufferMemory2(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaBindBufferMemory2(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long allocationLocalOffset, @NativeType(value="VkBuffer") long buffer, @NativeType(value="void const *") long pNext) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        return Vma.nvmaBindBufferMemory2(allocator, allocation, allocationLocalOffset, buffer, pNext);
    }

    public static native int nvmaBindImageMemory(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaBindImageMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkImage") long image) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        return Vma.nvmaBindImageMemory(allocator, allocation, image);
    }

    public static native int nvmaBindImageMemory2(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaBindImageMemory2(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long allocationLocalOffset, @NativeType(value="VkImage") long image, @NativeType(value="void const *") long pNext) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        return Vma.nvmaBindImageMemory2(allocator, allocation, allocationLocalOffset, image, pNext);
    }

    public static native int nvmaCreateBuffer(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaCreateBuffer(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo pBufferCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="VkBuffer *") LongBuffer pBuffer, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @NativeType(value="VmaAllocationInfo *") @Nullable VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pBuffer, (int)1);
            Checks.check((CustomBuffer)pAllocation, (int)1);
        }
        return Vma.nvmaCreateBuffer(allocator, pBufferCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress((LongBuffer)pBuffer), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native int nvmaCreateBufferWithAlignment(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="VkResult")
    public static int vmaCreateBufferWithAlignment(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo pBufferCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="VkDeviceSize") long minAlignment, @NativeType(value="VkBuffer *") LongBuffer pBuffer, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @NativeType(value="VmaAllocationInfo *") @Nullable VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pBuffer, (int)1);
            Checks.check((CustomBuffer)pAllocation, (int)1);
        }
        return Vma.nvmaCreateBufferWithAlignment(allocator, pBufferCreateInfo.address(), pAllocationCreateInfo.address(), minAlignment, MemoryUtil.memAddress((LongBuffer)pBuffer), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native int nvmaCreateAliasingBuffer(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaCreateAliasingBuffer(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo pBufferCreateInfo, @NativeType(value="VkBuffer *") LongBuffer pBuffer) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
            Checks.check((Buffer)pBuffer, (int)1);
        }
        return Vma.nvmaCreateAliasingBuffer(allocator, allocation, pBufferCreateInfo.address(), MemoryUtil.memAddress((LongBuffer)pBuffer));
    }

    public static native int nvmaCreateAliasingBuffer2(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaCreateAliasingBuffer2(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long allocationLocalOffset, @NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo pBufferCreateInfo, @NativeType(value="VkBuffer *") LongBuffer pBuffer) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
            Checks.check((Buffer)pBuffer, (int)1);
        }
        return Vma.nvmaCreateAliasingBuffer2(allocator, allocation, allocationLocalOffset, pBufferCreateInfo.address(), MemoryUtil.memAddress((LongBuffer)pBuffer));
    }

    public static native void nvmaDestroyBuffer(long var0, long var2, long var4);

    public static void vmaDestroyBuffer(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBuffer") long buffer, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaDestroyBuffer(allocator, buffer, allocation);
    }

    public static native int nvmaCreateImage(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaCreateImage(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo pImageCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="VkImage *") LongBuffer pImage, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @NativeType(value="VmaAllocationInfo *") @Nullable VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pImage, (int)1);
            Checks.check((CustomBuffer)pAllocation, (int)1);
        }
        return Vma.nvmaCreateImage(allocator, pImageCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress((LongBuffer)pImage), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native int nvmaCreateAliasingImage(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaCreateAliasingImage(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo pImageCreateInfo, @NativeType(value="VkImage *") LongBuffer pImage) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
            Checks.check((Buffer)pImage, (int)1);
        }
        return Vma.nvmaCreateAliasingImage(allocator, allocation, pImageCreateInfo.address(), MemoryUtil.memAddress((LongBuffer)pImage));
    }

    public static native int nvmaCreateAliasingImage2(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaCreateAliasingImage2(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long allocationLocalOffset, @NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo pImageCreateInfo, @NativeType(value="VkImage *") LongBuffer pImage) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
            Checks.check((Buffer)pImage, (int)1);
        }
        return Vma.nvmaCreateAliasingImage2(allocator, allocation, allocationLocalOffset, pImageCreateInfo.address(), MemoryUtil.memAddress((LongBuffer)pImage));
    }

    public static native void nvmaDestroyImage(long var0, long var2, long var4);

    public static void vmaDestroyImage(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImage") long image, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaDestroyImage(allocator, image, allocation);
    }

    public static native int nvmaCreateVirtualBlock(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaCreateVirtualBlock(@NativeType(value="VmaVirtualBlockCreateInfo const *") VmaVirtualBlockCreateInfo pCreateInfo, @NativeType(value="VmaVirtualBlock *") PointerBuffer pVirtualBlock) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pVirtualBlock, (int)1);
        }
        return Vma.nvmaCreateVirtualBlock(pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pVirtualBlock));
    }

    public static native void nvmaDestroyVirtualBlock(long var0);

    public static void vmaDestroyVirtualBlock(@NativeType(value="VmaVirtualBlock") long virtualBlock) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
        }
        Vma.nvmaDestroyVirtualBlock(virtualBlock);
    }

    public static native int nvmaIsVirtualBlockEmpty(long var0);

    @NativeType(value="VkBool32")
    public static boolean vmaIsVirtualBlockEmpty(@NativeType(value="VmaVirtualBlock") long virtualBlock) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
        }
        return Vma.nvmaIsVirtualBlockEmpty(virtualBlock) != 0;
    }

    public static native void nvmaGetVirtualAllocationInfo(long var0, long var2, long var4);

    public static void vmaGetVirtualAllocationInfo(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaVirtualAllocation") long allocation, @NativeType(value="VmaVirtualAllocationInfo *") VmaVirtualAllocationInfo pVirtualAllocInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
            Checks.check((long)allocation);
        }
        Vma.nvmaGetVirtualAllocationInfo(virtualBlock, allocation, pVirtualAllocInfo.address());
    }

    public static native int nvmaVirtualAllocate(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaVirtualAllocate(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaVirtualAllocationCreateInfo const *") VmaVirtualAllocationCreateInfo pCreateInfo, @NativeType(value="VmaVirtualAllocation *") PointerBuffer pAllocation, @NativeType(value="VkDeviceSize *") @Nullable LongBuffer pOffset) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
            Checks.check((CustomBuffer)pAllocation, (int)1);
            Checks.checkSafe((Buffer)pOffset, (int)1);
        }
        return Vma.nvmaVirtualAllocate(virtualBlock, pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((LongBuffer)pOffset));
    }

    public static native void nvmaVirtualFree(long var0, long var2);

    public static void vmaVirtualFree(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaVirtualAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
        }
        Vma.nvmaVirtualFree(virtualBlock, allocation);
    }

    public static native void nvmaClearVirtualBlock(long var0);

    public static void vmaClearVirtualBlock(@NativeType(value="VmaVirtualBlock") long virtualBlock) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
        }
        Vma.nvmaClearVirtualBlock(virtualBlock);
    }

    public static native void nvmaSetVirtualAllocationUserData(long var0, long var2, long var4);

    public static void vmaSetVirtualAllocationUserData(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaVirtualAllocation") long allocation, @NativeType(value="void *") long pUserData) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
            Checks.check((long)allocation);
            Checks.check((long)pUserData);
        }
        Vma.nvmaSetVirtualAllocationUserData(virtualBlock, allocation, pUserData);
    }

    public static native void nvmaGetVirtualBlockStatistics(long var0, long var2);

    public static void vmaGetVirtualBlockStatistics(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaStatistics *") VmaStatistics pStats) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
        }
        Vma.nvmaGetVirtualBlockStatistics(virtualBlock, pStats.address());
    }

    public static native void nvmaCalculateVirtualBlockStatistics(long var0, long var2);

    public static void vmaCalculateVirtualBlockStatistics(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaDetailedStatistics *") VmaDetailedStatistics pStats) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
        }
        Vma.nvmaCalculateVirtualBlockStatistics(virtualBlock, pStats.address());
    }

    public static native void nvmaBuildVirtualBlockStatsString(long var0, long var2, int var4);

    public static void vmaBuildVirtualBlockStatsString(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="char **") PointerBuffer ppStatsString, @NativeType(value="VkBool32") boolean detailedMap) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
            Checks.check((CustomBuffer)ppStatsString, (int)1);
        }
        Vma.nvmaBuildVirtualBlockStatsString(virtualBlock, MemoryUtil.memAddress((CustomBuffer)ppStatsString), detailedMap ? 1 : 0);
    }

    public static native void nvmaFreeVirtualBlockStatsString(long var0, long var2);

    public static void vmaFreeVirtualBlockStatsString(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="char *") ByteBuffer pStatsString) {
        if (Checks.CHECKS) {
            Checks.check((long)virtualBlock);
        }
        Vma.nvmaFreeVirtualBlockStatsString(virtualBlock, MemoryUtil.memAddress((ByteBuffer)pStatsString));
    }

    public static native void nvmaBuildStatsString(long var0, long var2, int var4);

    public static void vmaBuildStatsString(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="char **") PointerBuffer ppStatsString, @NativeType(value="VkBool32") boolean detailedMap) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)ppStatsString, (int)1);
        }
        Vma.nvmaBuildStatsString(allocator, MemoryUtil.memAddress((CustomBuffer)ppStatsString), detailedMap ? 1 : 0);
    }

    public static native void nvmaFreeStatsString(long var0, long var2);

    public static void vmaFreeStatsString(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="char *") ByteBuffer pStatsString) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaFreeStatsString(allocator, MemoryUtil.memAddress((ByteBuffer)pStatsString));
    }

    static {
        LibVma.initialize();
    }
}

