/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaDetailedStatistics;

public class VmaTotalStatistics
extends Struct<VmaTotalStatistics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORYTYPE;
    public static final int MEMORYHEAP;
    public static final int TOTAL;

    protected VmaTotalStatistics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VmaTotalStatistics create(long address, @Nullable ByteBuffer container) {
        return new VmaTotalStatistics(address, container);
    }

    public VmaTotalStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaTotalStatistics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaDetailedStatistics[32]")
    public VmaDetailedStatistics.Buffer memoryType() {
        return VmaTotalStatistics.nmemoryType(this.address());
    }

    public VmaDetailedStatistics memoryType(int index) {
        return VmaTotalStatistics.nmemoryType(this.address(), index);
    }

    @NativeType(value="VmaDetailedStatistics[16]")
    public VmaDetailedStatistics.Buffer memoryHeap() {
        return VmaTotalStatistics.nmemoryHeap(this.address());
    }

    public VmaDetailedStatistics memoryHeap(int index) {
        return VmaTotalStatistics.nmemoryHeap(this.address(), index);
    }

    public VmaDetailedStatistics total() {
        return VmaTotalStatistics.ntotal(this.address());
    }

    public static VmaTotalStatistics malloc() {
        return new VmaTotalStatistics(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VmaTotalStatistics calloc() {
        return new VmaTotalStatistics(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VmaTotalStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VmaTotalStatistics(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VmaTotalStatistics create(long address) {
        return new VmaTotalStatistics(address, null);
    }

    public static @Nullable VmaTotalStatistics createSafe(long address) {
        return address == 0L ? null : new VmaTotalStatistics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VmaTotalStatistics.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaTotalStatistics.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaTotalStatistics malloc(MemoryStack stack) {
        return new VmaTotalStatistics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaTotalStatistics calloc(MemoryStack stack) {
        return new VmaTotalStatistics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VmaDetailedStatistics.Buffer nmemoryType(long struct) {
        return VmaDetailedStatistics.create(struct + (long)MEMORYTYPE, 32);
    }

    public static VmaDetailedStatistics nmemoryType(long struct, int index) {
        return VmaDetailedStatistics.create(struct + (long)MEMORYTYPE + Checks.check((int)index, (int)32) * (long)VmaDetailedStatistics.SIZEOF);
    }

    public static VmaDetailedStatistics.Buffer nmemoryHeap(long struct) {
        return VmaDetailedStatistics.create(struct + (long)MEMORYHEAP, 16);
    }

    public static VmaDetailedStatistics nmemoryHeap(long struct, int index) {
        return VmaDetailedStatistics.create(struct + (long)MEMORYHEAP + Checks.check((int)index, (int)16) * (long)VmaDetailedStatistics.SIZEOF);
    }

    public static VmaDetailedStatistics ntotal(long struct) {
        return VmaDetailedStatistics.create(struct + (long)TOTAL);
    }

    static {
        Struct.Layout layout = VmaTotalStatistics.__struct((Struct.Member[])new Struct.Member[]{VmaTotalStatistics.__array((int)VmaDetailedStatistics.SIZEOF, (int)VmaDetailedStatistics.ALIGNOF, (int)32), VmaTotalStatistics.__array((int)VmaDetailedStatistics.SIZEOF, (int)VmaDetailedStatistics.ALIGNOF, (int)16), VmaTotalStatistics.__member((int)VmaDetailedStatistics.SIZEOF, (int)VmaDetailedStatistics.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORYTYPE = layout.offsetof(0);
        MEMORYHEAP = layout.offsetof(1);
        TOTAL = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaTotalStatistics, Buffer>
    implements NativeResource {
        private static final VmaTotalStatistics ELEMENT_FACTORY = VmaTotalStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VmaTotalStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaDetailedStatistics[32]")
        public VmaDetailedStatistics.Buffer memoryType() {
            return VmaTotalStatistics.nmemoryType(this.address());
        }

        public VmaDetailedStatistics memoryType(int index) {
            return VmaTotalStatistics.nmemoryType(this.address(), index);
        }

        @NativeType(value="VmaDetailedStatistics[16]")
        public VmaDetailedStatistics.Buffer memoryHeap() {
            return VmaTotalStatistics.nmemoryHeap(this.address());
        }

        public VmaDetailedStatistics memoryHeap(int index) {
            return VmaTotalStatistics.nmemoryHeap(this.address(), index);
        }

        public VmaDetailedStatistics total() {
            return VmaTotalStatistics.ntotal(this.address());
        }
    }
}

