/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkCalibratedTimestampInfoKHR;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class EXTCalibratedTimestamps {
    public static final int VK_EXT_CALIBRATED_TIMESTAMPS_SPEC_VERSION = 2;
    public static final String VK_EXT_CALIBRATED_TIMESTAMPS_EXTENSION_NAME = "VK_EXT_calibrated_timestamps";
    public static final int VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT = 1000184000;
    public static final int VK_TIME_DOMAIN_DEVICE_EXT = 0;
    public static final int VK_TIME_DOMAIN_CLOCK_MONOTONIC_EXT = 1;
    public static final int VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_EXT = 2;
    public static final int VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_EXT = 3;
    public static final int VK_TIME_DOMAIN_DEVICE_KHR = 0;
    public static final int VK_TIME_DOMAIN_CLOCK_MONOTONIC_KHR = 1;
    public static final int VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_KHR = 2;
    public static final int VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_KHR = 3;

    protected EXTCalibratedTimestamps() {
        throw new UnsupportedOperationException();
    }

    public static int nvkGetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, long pTimeDomainCount, long pTimeDomains) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceCalibrateableTimeDomainsEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)physicalDevice.address(), (long)pTimeDomainCount, (long)pTimeDomains, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") IntBuffer pTimeDomainCount, @Nullable @NativeType(value="VkTimeDomainKHR *") IntBuffer pTimeDomains) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pTimeDomainCount, (int)1);
            Checks.checkSafe((Buffer)pTimeDomains, (int)pTimeDomainCount.get(pTimeDomainCount.position()));
        }
        return EXTCalibratedTimestamps.nvkGetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, MemoryUtil.memAddress((IntBuffer)pTimeDomainCount), MemoryUtil.memAddressSafe((IntBuffer)pTimeDomains));
    }

    public static int nvkGetCalibratedTimestampsEXT(VkDevice device, int timestampCount, long pTimestampInfos, long pTimestamps, long pMaxDeviation) {
        long __functionAddress = device.getCapabilities().vkGetCalibratedTimestampsEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPI((long)device.address(), (int)timestampCount, (long)pTimestampInfos, (long)pTimestamps, (long)pMaxDeviation, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetCalibratedTimestampsEXT(VkDevice device, @NativeType(value="VkCalibratedTimestampInfoKHR const *") VkCalibratedTimestampInfoKHR.Buffer pTimestampInfos, @NativeType(value="uint64_t *") LongBuffer pTimestamps, @NativeType(value="uint64_t *") LongBuffer pMaxDeviation) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pTimestamps, (int)pTimestampInfos.remaining());
            Checks.check((Buffer)pMaxDeviation, (int)1);
        }
        return EXTCalibratedTimestamps.nvkGetCalibratedTimestampsEXT(device, pTimestampInfos.remaining(), pTimestampInfos.address(), MemoryUtil.memAddress((LongBuffer)pTimestamps), MemoryUtil.memAddress((LongBuffer)pMaxDeviation));
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") int[] pTimeDomainCount, @Nullable @NativeType(value="VkTimeDomainKHR *") int[] pTimeDomains) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceCalibrateableTimeDomainsEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pTimeDomainCount, (int)1);
            Checks.checkSafe((int[])pTimeDomains, (int)pTimeDomainCount[0]);
        }
        return JNI.callPPPI((long)physicalDevice.address(), (int[])pTimeDomainCount, (int[])pTimeDomains, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetCalibratedTimestampsEXT(VkDevice device, @NativeType(value="VkCalibratedTimestampInfoKHR const *") VkCalibratedTimestampInfoKHR.Buffer pTimestampInfos, @NativeType(value="uint64_t *") long[] pTimestamps, @NativeType(value="uint64_t *") long[] pMaxDeviation) {
        long __functionAddress = device.getCapabilities().vkGetCalibratedTimestampsEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pTimestamps, (int)pTimestampInfos.remaining());
            Checks.check((long[])pMaxDeviation, (int)1);
        }
        return JNI.callPPPPI((long)device.address(), (int)pTimestampInfos.remaining(), (long)pTimestampInfos.address(), (long[])pTimestamps, (long[])pMaxDeviation, (long)__functionAddress);
    }
}

