/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAabbPositionsKHR
extends Struct<VkAabbPositionsKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MINX;
    public static final int MINY;
    public static final int MINZ;
    public static final int MAXX;
    public static final int MAXY;
    public static final int MAXZ;

    protected VkAabbPositionsKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkAabbPositionsKHR create(long address, @Nullable ByteBuffer container) {
        return new VkAabbPositionsKHR(address, container);
    }

    public VkAabbPositionsKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAabbPositionsKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float minX() {
        return VkAabbPositionsKHR.nminX(this.address());
    }

    public float minY() {
        return VkAabbPositionsKHR.nminY(this.address());
    }

    public float minZ() {
        return VkAabbPositionsKHR.nminZ(this.address());
    }

    public float maxX() {
        return VkAabbPositionsKHR.nmaxX(this.address());
    }

    public float maxY() {
        return VkAabbPositionsKHR.nmaxY(this.address());
    }

    public float maxZ() {
        return VkAabbPositionsKHR.nmaxZ(this.address());
    }

    public VkAabbPositionsKHR minX(float value) {
        VkAabbPositionsKHR.nminX(this.address(), value);
        return this;
    }

    public VkAabbPositionsKHR minY(float value) {
        VkAabbPositionsKHR.nminY(this.address(), value);
        return this;
    }

    public VkAabbPositionsKHR minZ(float value) {
        VkAabbPositionsKHR.nminZ(this.address(), value);
        return this;
    }

    public VkAabbPositionsKHR maxX(float value) {
        VkAabbPositionsKHR.nmaxX(this.address(), value);
        return this;
    }

    public VkAabbPositionsKHR maxY(float value) {
        VkAabbPositionsKHR.nmaxY(this.address(), value);
        return this;
    }

    public VkAabbPositionsKHR maxZ(float value) {
        VkAabbPositionsKHR.nmaxZ(this.address(), value);
        return this;
    }

    public VkAabbPositionsKHR set(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX(minX);
        this.minY(minY);
        this.minZ(minZ);
        this.maxX(maxX);
        this.maxY(maxY);
        this.maxZ(maxZ);
        return this;
    }

    public VkAabbPositionsKHR set(VkAabbPositionsKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAabbPositionsKHR malloc() {
        return new VkAabbPositionsKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkAabbPositionsKHR calloc() {
        return new VkAabbPositionsKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkAabbPositionsKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkAabbPositionsKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkAabbPositionsKHR create(long address) {
        return new VkAabbPositionsKHR(address, null);
    }

    @Nullable
    public static VkAabbPositionsKHR createSafe(long address) {
        return address == 0L ? null : new VkAabbPositionsKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkAabbPositionsKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAabbPositionsKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAabbPositionsKHR malloc(MemoryStack stack) {
        return new VkAabbPositionsKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAabbPositionsKHR calloc(MemoryStack stack) {
        return new VkAabbPositionsKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nminX(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINX);
    }

    public static float nminY(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINY);
    }

    public static float nminZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINZ);
    }

    public static float nmaxX(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXX);
    }

    public static float nmaxY(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXY);
    }

    public static float nmaxZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXZ);
    }

    public static void nminX(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MINX, value);
    }

    public static void nminY(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MINY, value);
    }

    public static void nminZ(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MINZ, value);
    }

    public static void nmaxX(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXX, value);
    }

    public static void nmaxY(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXY, value);
    }

    public static void nmaxZ(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXZ, value);
    }

    static {
        Struct.Layout layout = VkAabbPositionsKHR.__struct((Struct.Member[])new Struct.Member[]{VkAabbPositionsKHR.__member((int)4), VkAabbPositionsKHR.__member((int)4), VkAabbPositionsKHR.__member((int)4), VkAabbPositionsKHR.__member((int)4), VkAabbPositionsKHR.__member((int)4), VkAabbPositionsKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MINX = layout.offsetof(0);
        MINY = layout.offsetof(1);
        MINZ = layout.offsetof(2);
        MAXX = layout.offsetof(3);
        MAXY = layout.offsetof(4);
        MAXZ = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkAabbPositionsKHR, Buffer>
    implements NativeResource {
        private static final VkAabbPositionsKHR ELEMENT_FACTORY = VkAabbPositionsKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAabbPositionsKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float minX() {
            return VkAabbPositionsKHR.nminX(this.address());
        }

        public float minY() {
            return VkAabbPositionsKHR.nminY(this.address());
        }

        public float minZ() {
            return VkAabbPositionsKHR.nminZ(this.address());
        }

        public float maxX() {
            return VkAabbPositionsKHR.nmaxX(this.address());
        }

        public float maxY() {
            return VkAabbPositionsKHR.nmaxY(this.address());
        }

        public float maxZ() {
            return VkAabbPositionsKHR.nmaxZ(this.address());
        }

        public Buffer minX(float value) {
            VkAabbPositionsKHR.nminX(this.address(), value);
            return this;
        }

        public Buffer minY(float value) {
            VkAabbPositionsKHR.nminY(this.address(), value);
            return this;
        }

        public Buffer minZ(float value) {
            VkAabbPositionsKHR.nminZ(this.address(), value);
            return this;
        }

        public Buffer maxX(float value) {
            VkAabbPositionsKHR.nmaxX(this.address(), value);
            return this;
        }

        public Buffer maxY(float value) {
            VkAabbPositionsKHR.nmaxY(this.address(), value);
            return this;
        }

        public Buffer maxZ(float value) {
            VkAabbPositionsKHR.nmaxZ(this.address(), value);
            return this;
        }
    }
}

