/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCommandPoolCreateInfo
extends Struct<VkCommandPoolCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int QUEUEFAMILYINDEX;

    protected VkCommandPoolCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCommandPoolCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkCommandPoolCreateInfo(address, container);
    }

    public VkCommandPoolCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCommandPoolCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCommandPoolCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCommandPoolCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkCommandPoolCreateFlags")
    public int flags() {
        return VkCommandPoolCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndex() {
        return VkCommandPoolCreateInfo.nqueueFamilyIndex(this.address());
    }

    public VkCommandPoolCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkCommandPoolCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkCommandPoolCreateInfo sType$Default() {
        return this.sType(39);
    }

    public VkCommandPoolCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkCommandPoolCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkCommandPoolCreateInfo flags(@NativeType(value="VkCommandPoolCreateFlags") int value) {
        VkCommandPoolCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkCommandPoolCreateInfo queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkCommandPoolCreateInfo.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkCommandPoolCreateInfo set(int sType, long pNext, int flags, int queueFamilyIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.queueFamilyIndex(queueFamilyIndex);
        return this;
    }

    public VkCommandPoolCreateInfo set(VkCommandPoolCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCommandPoolCreateInfo malloc() {
        return new VkCommandPoolCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCommandPoolCreateInfo calloc() {
        return new VkCommandPoolCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCommandPoolCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCommandPoolCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCommandPoolCreateInfo create(long address) {
        return new VkCommandPoolCreateInfo(address, null);
    }

    @Nullable
    public static VkCommandPoolCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkCommandPoolCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCommandPoolCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCommandPoolCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkCommandPoolCreateInfo mallocStack() {
        return VkCommandPoolCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCommandPoolCreateInfo callocStack() {
        return VkCommandPoolCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCommandPoolCreateInfo mallocStack(MemoryStack stack) {
        return VkCommandPoolCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkCommandPoolCreateInfo callocStack(MemoryStack stack) {
        return VkCommandPoolCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkCommandPoolCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkCommandPoolCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCommandPoolCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCommandPoolCreateInfo.calloc(capacity, stack);
    }

    public static VkCommandPoolCreateInfo malloc(MemoryStack stack) {
        return new VkCommandPoolCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCommandPoolCreateInfo calloc(MemoryStack stack) {
        return new VkCommandPoolCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nqueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFAMILYINDEX);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nqueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEFAMILYINDEX, value);
    }

    static {
        Struct.Layout layout = VkCommandPoolCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkCommandPoolCreateInfo.__member((int)4), VkCommandPoolCreateInfo.__member((int)POINTER_SIZE), VkCommandPoolCreateInfo.__member((int)4), VkCommandPoolCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        QUEUEFAMILYINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCommandPoolCreateInfo, Buffer>
    implements NativeResource {
        private static final VkCommandPoolCreateInfo ELEMENT_FACTORY = VkCommandPoolCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCommandPoolCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCommandPoolCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCommandPoolCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkCommandPoolCreateFlags")
        public int flags() {
            return VkCommandPoolCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndex() {
            return VkCommandPoolCreateInfo.nqueueFamilyIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCommandPoolCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(39);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCommandPoolCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkCommandPoolCreateFlags") int value) {
            VkCommandPoolCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkCommandPoolCreateInfo.nqueueFamilyIndex(this.address(), value);
            return this;
        }
    }
}

