/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferCopy2;
import org.lwjgl.vulkan.VkCopyBufferInfo2;

public class VkCopyBufferInfo2KHR
extends VkCopyBufferInfo2 {
    protected VkCopyBufferInfo2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCopyBufferInfo2KHR create(long address, @Nullable ByteBuffer container) {
        return new VkCopyBufferInfo2KHR(address, container);
    }

    public VkCopyBufferInfo2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkCopyBufferInfo2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkCopyBufferInfo2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkCopyBufferInfo2KHR sType$Default() {
        return this.sType(1000337000);
    }

    @Override
    public VkCopyBufferInfo2KHR pNext(@NativeType(value="void const *") long value) {
        VkCopyBufferInfo2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkCopyBufferInfo2KHR srcBuffer(@NativeType(value="VkBuffer") long value) {
        VkCopyBufferInfo2KHR.nsrcBuffer(this.address(), value);
        return this;
    }

    @Override
    public VkCopyBufferInfo2KHR dstBuffer(@NativeType(value="VkBuffer") long value) {
        VkCopyBufferInfo2KHR.ndstBuffer(this.address(), value);
        return this;
    }

    @Override
    public VkCopyBufferInfo2KHR pRegions(@NativeType(value="VkBufferCopy2 const *") VkBufferCopy2.Buffer value) {
        VkCopyBufferInfo2KHR.npRegions(this.address(), value);
        return this;
    }

    @Override
    public VkCopyBufferInfo2KHR set(int sType, long pNext, long srcBuffer, long dstBuffer, VkBufferCopy2.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcBuffer(srcBuffer);
        this.dstBuffer(dstBuffer);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyBufferInfo2KHR set(VkCopyBufferInfo2KHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyBufferInfo2KHR malloc() {
        return new VkCopyBufferInfo2KHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyBufferInfo2KHR calloc() {
        return new VkCopyBufferInfo2KHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyBufferInfo2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyBufferInfo2KHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyBufferInfo2KHR create(long address) {
        return new VkCopyBufferInfo2KHR(address, null);
    }

    @Nullable
    public static VkCopyBufferInfo2KHR createSafe(long address) {
        return address == 0L ? null : new VkCopyBufferInfo2KHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyBufferInfo2KHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyBufferInfo2KHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyBufferInfo2KHR malloc(MemoryStack stack) {
        return new VkCopyBufferInfo2KHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyBufferInfo2KHR calloc(MemoryStack stack) {
        return new VkCopyBufferInfo2KHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkCopyBufferInfo2.Buffer {
        private static final VkCopyBufferInfo2KHR ELEMENT_FACTORY = VkCopyBufferInfo2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCopyBufferInfo2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyBufferInfo2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000337000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyBufferInfo2KHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer srcBuffer(@NativeType(value="VkBuffer") long value) {
            VkCopyBufferInfo2KHR.nsrcBuffer(this.address(), value);
            return this;
        }

        @Override
        public Buffer dstBuffer(@NativeType(value="VkBuffer") long value) {
            VkCopyBufferInfo2KHR.ndstBuffer(this.address(), value);
            return this;
        }

        @Override
        public Buffer pRegions(@NativeType(value="VkBufferCopy2 const *") VkBufferCopy2.Buffer value) {
            VkCopyBufferInfo2KHR.npRegions(this.address(), value);
            return this;
        }
    }
}

