/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDirectDriverLoadingInfoLUNARG;

public class VkDirectDriverLoadingListLUNARG
extends Struct<VkDirectDriverLoadingListLUNARG>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MODE;
    public static final int DRIVERCOUNT;
    public static final int PDRIVERS;

    protected VkDirectDriverLoadingListLUNARG(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDirectDriverLoadingListLUNARG create(long address, @Nullable ByteBuffer container) {
        return new VkDirectDriverLoadingListLUNARG(address, container);
    }

    public VkDirectDriverLoadingListLUNARG(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDirectDriverLoadingListLUNARG.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDirectDriverLoadingListLUNARG.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDirectDriverLoadingListLUNARG.npNext(this.address());
    }

    @NativeType(value="VkDirectDriverLoadingModeLUNARG")
    public int mode() {
        return VkDirectDriverLoadingListLUNARG.nmode(this.address());
    }

    @NativeType(value="uint32_t")
    public int driverCount() {
        return VkDirectDriverLoadingListLUNARG.ndriverCount(this.address());
    }

    @NativeType(value="VkDirectDriverLoadingInfoLUNARG const *")
    public VkDirectDriverLoadingInfoLUNARG.Buffer pDrivers() {
        return VkDirectDriverLoadingListLUNARG.npDrivers(this.address());
    }

    public VkDirectDriverLoadingListLUNARG sType(@NativeType(value="VkStructureType") int value) {
        VkDirectDriverLoadingListLUNARG.nsType(this.address(), value);
        return this;
    }

    public VkDirectDriverLoadingListLUNARG sType$Default() {
        return this.sType(1000459001);
    }

    public VkDirectDriverLoadingListLUNARG pNext(@NativeType(value="void const *") long value) {
        VkDirectDriverLoadingListLUNARG.npNext(this.address(), value);
        return this;
    }

    public VkDirectDriverLoadingListLUNARG mode(@NativeType(value="VkDirectDriverLoadingModeLUNARG") int value) {
        VkDirectDriverLoadingListLUNARG.nmode(this.address(), value);
        return this;
    }

    public VkDirectDriverLoadingListLUNARG pDrivers(@NativeType(value="VkDirectDriverLoadingInfoLUNARG const *") VkDirectDriverLoadingInfoLUNARG.Buffer value) {
        VkDirectDriverLoadingListLUNARG.npDrivers(this.address(), value);
        return this;
    }

    public VkDirectDriverLoadingListLUNARG set(int sType, long pNext, int mode, VkDirectDriverLoadingInfoLUNARG.Buffer pDrivers) {
        this.sType(sType);
        this.pNext(pNext);
        this.mode(mode);
        this.pDrivers(pDrivers);
        return this;
    }

    public VkDirectDriverLoadingListLUNARG set(VkDirectDriverLoadingListLUNARG src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDirectDriverLoadingListLUNARG malloc() {
        return new VkDirectDriverLoadingListLUNARG(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDirectDriverLoadingListLUNARG calloc() {
        return new VkDirectDriverLoadingListLUNARG(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDirectDriverLoadingListLUNARG create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDirectDriverLoadingListLUNARG(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDirectDriverLoadingListLUNARG create(long address) {
        return new VkDirectDriverLoadingListLUNARG(address, null);
    }

    @Nullable
    public static VkDirectDriverLoadingListLUNARG createSafe(long address) {
        return address == 0L ? null : new VkDirectDriverLoadingListLUNARG(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDirectDriverLoadingListLUNARG.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDirectDriverLoadingListLUNARG.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDirectDriverLoadingListLUNARG malloc(MemoryStack stack) {
        return new VkDirectDriverLoadingListLUNARG(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDirectDriverLoadingListLUNARG calloc(MemoryStack stack) {
        return new VkDirectDriverLoadingListLUNARG(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nmode(long struct) {
        return UNSAFE.getInt(null, struct + (long)MODE);
    }

    public static int ndriverCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DRIVERCOUNT);
    }

    public static VkDirectDriverLoadingInfoLUNARG.Buffer npDrivers(long struct) {
        return VkDirectDriverLoadingInfoLUNARG.create(MemoryUtil.memGetAddress((long)(struct + (long)PDRIVERS)), VkDirectDriverLoadingListLUNARG.ndriverCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nmode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MODE, value);
    }

    public static void ndriverCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DRIVERCOUNT, value);
    }

    public static void npDrivers(long struct, VkDirectDriverLoadingInfoLUNARG.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDRIVERS), (long)value.address());
        VkDirectDriverLoadingListLUNARG.ndriverCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        int driverCount = VkDirectDriverLoadingListLUNARG.ndriverCount(struct);
        long pDrivers = MemoryUtil.memGetAddress((long)(struct + (long)PDRIVERS));
        Checks.check((long)pDrivers);
        VkDirectDriverLoadingListLUNARG.validate((long)pDrivers, (int)driverCount, (int)VkDirectDriverLoadingInfoLUNARG.SIZEOF, VkDirectDriverLoadingInfoLUNARG::validate);
    }

    static {
        Struct.Layout layout = VkDirectDriverLoadingListLUNARG.__struct((Struct.Member[])new Struct.Member[]{VkDirectDriverLoadingListLUNARG.__member((int)4), VkDirectDriverLoadingListLUNARG.__member((int)POINTER_SIZE), VkDirectDriverLoadingListLUNARG.__member((int)4), VkDirectDriverLoadingListLUNARG.__member((int)4), VkDirectDriverLoadingListLUNARG.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MODE = layout.offsetof(2);
        DRIVERCOUNT = layout.offsetof(3);
        PDRIVERS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDirectDriverLoadingListLUNARG, Buffer>
    implements NativeResource {
        private static final VkDirectDriverLoadingListLUNARG ELEMENT_FACTORY = VkDirectDriverLoadingListLUNARG.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDirectDriverLoadingListLUNARG getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDirectDriverLoadingListLUNARG.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDirectDriverLoadingListLUNARG.npNext(this.address());
        }

        @NativeType(value="VkDirectDriverLoadingModeLUNARG")
        public int mode() {
            return VkDirectDriverLoadingListLUNARG.nmode(this.address());
        }

        @NativeType(value="uint32_t")
        public int driverCount() {
            return VkDirectDriverLoadingListLUNARG.ndriverCount(this.address());
        }

        @NativeType(value="VkDirectDriverLoadingInfoLUNARG const *")
        public VkDirectDriverLoadingInfoLUNARG.Buffer pDrivers() {
            return VkDirectDriverLoadingListLUNARG.npDrivers(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDirectDriverLoadingListLUNARG.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000459001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDirectDriverLoadingListLUNARG.npNext(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="VkDirectDriverLoadingModeLUNARG") int value) {
            VkDirectDriverLoadingListLUNARG.nmode(this.address(), value);
            return this;
        }

        public Buffer pDrivers(@NativeType(value="VkDirectDriverLoadingInfoLUNARG const *") VkDirectDriverLoadingInfoLUNARG.Buffer value) {
            VkDirectDriverLoadingListLUNARG.npDrivers(this.address(), value);
            return this;
        }
    }
}

