/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceOrHostAddressConstAMDX;

public class VkDispatchGraphCountInfoAMDX
extends Struct<VkDispatchGraphCountInfoAMDX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COUNT;
    public static final int INFOS;
    public static final int STRIDE;

    protected VkDispatchGraphCountInfoAMDX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDispatchGraphCountInfoAMDX create(long address, @Nullable ByteBuffer container) {
        return new VkDispatchGraphCountInfoAMDX(address, container);
    }

    public VkDispatchGraphCountInfoAMDX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDispatchGraphCountInfoAMDX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int count() {
        return VkDispatchGraphCountInfoAMDX.ncount(this.address());
    }

    public VkDeviceOrHostAddressConstAMDX infos() {
        return VkDispatchGraphCountInfoAMDX.ninfos(this.address());
    }

    @NativeType(value="uint64_t")
    public long stride() {
        return VkDispatchGraphCountInfoAMDX.nstride(this.address());
    }

    public VkDispatchGraphCountInfoAMDX count(@NativeType(value="uint32_t") int value) {
        VkDispatchGraphCountInfoAMDX.ncount(this.address(), value);
        return this;
    }

    public VkDispatchGraphCountInfoAMDX infos(VkDeviceOrHostAddressConstAMDX value) {
        VkDispatchGraphCountInfoAMDX.ninfos(this.address(), value);
        return this;
    }

    public VkDispatchGraphCountInfoAMDX infos(Consumer<VkDeviceOrHostAddressConstAMDX> consumer) {
        consumer.accept(this.infos());
        return this;
    }

    public VkDispatchGraphCountInfoAMDX stride(@NativeType(value="uint64_t") long value) {
        VkDispatchGraphCountInfoAMDX.nstride(this.address(), value);
        return this;
    }

    public VkDispatchGraphCountInfoAMDX set(int count, VkDeviceOrHostAddressConstAMDX infos, long stride) {
        this.count(count);
        this.infos(infos);
        this.stride(stride);
        return this;
    }

    public VkDispatchGraphCountInfoAMDX set(VkDispatchGraphCountInfoAMDX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDispatchGraphCountInfoAMDX malloc() {
        return new VkDispatchGraphCountInfoAMDX(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDispatchGraphCountInfoAMDX calloc() {
        return new VkDispatchGraphCountInfoAMDX(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDispatchGraphCountInfoAMDX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDispatchGraphCountInfoAMDX(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDispatchGraphCountInfoAMDX create(long address) {
        return new VkDispatchGraphCountInfoAMDX(address, null);
    }

    @Nullable
    public static VkDispatchGraphCountInfoAMDX createSafe(long address) {
        return address == 0L ? null : new VkDispatchGraphCountInfoAMDX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDispatchGraphCountInfoAMDX.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDispatchGraphCountInfoAMDX.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDispatchGraphCountInfoAMDX malloc(MemoryStack stack) {
        return new VkDispatchGraphCountInfoAMDX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDispatchGraphCountInfoAMDX calloc(MemoryStack stack) {
        return new VkDispatchGraphCountInfoAMDX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COUNT);
    }

    public static VkDeviceOrHostAddressConstAMDX ninfos(long struct) {
        return VkDeviceOrHostAddressConstAMDX.create(struct + (long)INFOS);
    }

    public static long nstride(long struct) {
        return UNSAFE.getLong(null, struct + (long)STRIDE);
    }

    public static void ncount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COUNT, value);
    }

    public static void ninfos(long struct, VkDeviceOrHostAddressConstAMDX value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)INFOS), (long)VkDeviceOrHostAddressConstAMDX.SIZEOF);
    }

    public static void nstride(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)STRIDE, value);
    }

    static {
        Struct.Layout layout = VkDispatchGraphCountInfoAMDX.__struct((Struct.Member[])new Struct.Member[]{VkDispatchGraphCountInfoAMDX.__member((int)4), VkDispatchGraphCountInfoAMDX.__member((int)VkDeviceOrHostAddressConstAMDX.SIZEOF, (int)VkDeviceOrHostAddressConstAMDX.ALIGNOF), VkDispatchGraphCountInfoAMDX.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COUNT = layout.offsetof(0);
        INFOS = layout.offsetof(1);
        STRIDE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDispatchGraphCountInfoAMDX, Buffer>
    implements NativeResource {
        private static final VkDispatchGraphCountInfoAMDX ELEMENT_FACTORY = VkDispatchGraphCountInfoAMDX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDispatchGraphCountInfoAMDX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int count() {
            return VkDispatchGraphCountInfoAMDX.ncount(this.address());
        }

        public VkDeviceOrHostAddressConstAMDX infos() {
            return VkDispatchGraphCountInfoAMDX.ninfos(this.address());
        }

        @NativeType(value="uint64_t")
        public long stride() {
            return VkDispatchGraphCountInfoAMDX.nstride(this.address());
        }

        public Buffer count(@NativeType(value="uint32_t") int value) {
            VkDispatchGraphCountInfoAMDX.ncount(this.address(), value);
            return this;
        }

        public Buffer infos(VkDeviceOrHostAddressConstAMDX value) {
            VkDispatchGraphCountInfoAMDX.ninfos(this.address(), value);
            return this;
        }

        public Buffer infos(Consumer<VkDeviceOrHostAddressConstAMDX> consumer) {
            consumer.accept(this.infos());
            return this;
        }

        public Buffer stride(@NativeType(value="uint64_t") long value) {
            VkDispatchGraphCountInfoAMDX.nstride(this.address(), value);
            return this;
        }
    }
}

