/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceOrHostAddressConstAMDX;

public class VkDispatchGraphInfoAMDX
extends Struct<VkDispatchGraphInfoAMDX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NODEINDEX;
    public static final int PAYLOADCOUNT;
    public static final int PAYLOADS;
    public static final int PAYLOADSTRIDE;

    protected VkDispatchGraphInfoAMDX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDispatchGraphInfoAMDX create(long address, @Nullable ByteBuffer container) {
        return new VkDispatchGraphInfoAMDX(address, container);
    }

    public VkDispatchGraphInfoAMDX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDispatchGraphInfoAMDX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int nodeIndex() {
        return VkDispatchGraphInfoAMDX.nnodeIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int payloadCount() {
        return VkDispatchGraphInfoAMDX.npayloadCount(this.address());
    }

    public VkDeviceOrHostAddressConstAMDX payloads() {
        return VkDispatchGraphInfoAMDX.npayloads(this.address());
    }

    @NativeType(value="uint64_t")
    public long payloadStride() {
        return VkDispatchGraphInfoAMDX.npayloadStride(this.address());
    }

    public VkDispatchGraphInfoAMDX nodeIndex(@NativeType(value="uint32_t") int value) {
        VkDispatchGraphInfoAMDX.nnodeIndex(this.address(), value);
        return this;
    }

    public VkDispatchGraphInfoAMDX payloadCount(@NativeType(value="uint32_t") int value) {
        VkDispatchGraphInfoAMDX.npayloadCount(this.address(), value);
        return this;
    }

    public VkDispatchGraphInfoAMDX payloads(VkDeviceOrHostAddressConstAMDX value) {
        VkDispatchGraphInfoAMDX.npayloads(this.address(), value);
        return this;
    }

    public VkDispatchGraphInfoAMDX payloads(Consumer<VkDeviceOrHostAddressConstAMDX> consumer) {
        consumer.accept(this.payloads());
        return this;
    }

    public VkDispatchGraphInfoAMDX payloadStride(@NativeType(value="uint64_t") long value) {
        VkDispatchGraphInfoAMDX.npayloadStride(this.address(), value);
        return this;
    }

    public VkDispatchGraphInfoAMDX set(int nodeIndex, int payloadCount, VkDeviceOrHostAddressConstAMDX payloads, long payloadStride) {
        this.nodeIndex(nodeIndex);
        this.payloadCount(payloadCount);
        this.payloads(payloads);
        this.payloadStride(payloadStride);
        return this;
    }

    public VkDispatchGraphInfoAMDX set(VkDispatchGraphInfoAMDX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDispatchGraphInfoAMDX malloc() {
        return new VkDispatchGraphInfoAMDX(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDispatchGraphInfoAMDX calloc() {
        return new VkDispatchGraphInfoAMDX(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDispatchGraphInfoAMDX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDispatchGraphInfoAMDX(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDispatchGraphInfoAMDX create(long address) {
        return new VkDispatchGraphInfoAMDX(address, null);
    }

    @Nullable
    public static VkDispatchGraphInfoAMDX createSafe(long address) {
        return address == 0L ? null : new VkDispatchGraphInfoAMDX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDispatchGraphInfoAMDX.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDispatchGraphInfoAMDX.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDispatchGraphInfoAMDX malloc(MemoryStack stack) {
        return new VkDispatchGraphInfoAMDX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDispatchGraphInfoAMDX calloc(MemoryStack stack) {
        return new VkDispatchGraphInfoAMDX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nnodeIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)NODEINDEX);
    }

    public static int npayloadCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)PAYLOADCOUNT);
    }

    public static VkDeviceOrHostAddressConstAMDX npayloads(long struct) {
        return VkDeviceOrHostAddressConstAMDX.create(struct + (long)PAYLOADS);
    }

    public static long npayloadStride(long struct) {
        return UNSAFE.getLong(null, struct + (long)PAYLOADSTRIDE);
    }

    public static void nnodeIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NODEINDEX, value);
    }

    public static void npayloadCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PAYLOADCOUNT, value);
    }

    public static void npayloads(long struct, VkDeviceOrHostAddressConstAMDX value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PAYLOADS), (long)VkDeviceOrHostAddressConstAMDX.SIZEOF);
    }

    public static void npayloadStride(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PAYLOADSTRIDE, value);
    }

    static {
        Struct.Layout layout = VkDispatchGraphInfoAMDX.__struct((Struct.Member[])new Struct.Member[]{VkDispatchGraphInfoAMDX.__member((int)4), VkDispatchGraphInfoAMDX.__member((int)4), VkDispatchGraphInfoAMDX.__member((int)VkDeviceOrHostAddressConstAMDX.SIZEOF, (int)VkDeviceOrHostAddressConstAMDX.ALIGNOF), VkDispatchGraphInfoAMDX.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NODEINDEX = layout.offsetof(0);
        PAYLOADCOUNT = layout.offsetof(1);
        PAYLOADS = layout.offsetof(2);
        PAYLOADSTRIDE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDispatchGraphInfoAMDX, Buffer>
    implements NativeResource {
        private static final VkDispatchGraphInfoAMDX ELEMENT_FACTORY = VkDispatchGraphInfoAMDX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDispatchGraphInfoAMDX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int nodeIndex() {
            return VkDispatchGraphInfoAMDX.nnodeIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int payloadCount() {
            return VkDispatchGraphInfoAMDX.npayloadCount(this.address());
        }

        public VkDeviceOrHostAddressConstAMDX payloads() {
            return VkDispatchGraphInfoAMDX.npayloads(this.address());
        }

        @NativeType(value="uint64_t")
        public long payloadStride() {
            return VkDispatchGraphInfoAMDX.npayloadStride(this.address());
        }

        public Buffer nodeIndex(@NativeType(value="uint32_t") int value) {
            VkDispatchGraphInfoAMDX.nnodeIndex(this.address(), value);
            return this;
        }

        public Buffer payloadCount(@NativeType(value="uint32_t") int value) {
            VkDispatchGraphInfoAMDX.npayloadCount(this.address(), value);
            return this;
        }

        public Buffer payloads(VkDeviceOrHostAddressConstAMDX value) {
            VkDispatchGraphInfoAMDX.npayloads(this.address(), value);
            return this;
        }

        public Buffer payloads(Consumer<VkDeviceOrHostAddressConstAMDX> consumer) {
            consumer.accept(this.payloads());
            return this;
        }

        public Buffer payloadStride(@NativeType(value="uint64_t") long value) {
            VkDispatchGraphInfoAMDX.npayloadStride(this.address(), value);
            return this;
        }
    }
}

