/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExportMetalObjectCreateInfoEXT;
import org.lwjgl.vulkan.VkImportMetalSharedEventInfoEXT;

public class VkEventCreateInfo
extends Struct<VkEventCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    protected VkEventCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkEventCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkEventCreateInfo(address, container);
    }

    public VkEventCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkEventCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkEventCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkEventCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkEventCreateFlags")
    public int flags() {
        return VkEventCreateInfo.nflags(this.address());
    }

    public VkEventCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkEventCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkEventCreateInfo sType$Default() {
        return this.sType(10);
    }

    public VkEventCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkEventCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkEventCreateInfo pNext(VkExportMetalObjectCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkEventCreateInfo pNext(VkImportMetalSharedEventInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkEventCreateInfo flags(@NativeType(value="VkEventCreateFlags") int value) {
        VkEventCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkEventCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkEventCreateInfo set(VkEventCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkEventCreateInfo malloc() {
        return new VkEventCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkEventCreateInfo calloc() {
        return new VkEventCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkEventCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkEventCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkEventCreateInfo create(long address) {
        return new VkEventCreateInfo(address, null);
    }

    @Nullable
    public static VkEventCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkEventCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkEventCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkEventCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkEventCreateInfo mallocStack() {
        return VkEventCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkEventCreateInfo callocStack() {
        return VkEventCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkEventCreateInfo mallocStack(MemoryStack stack) {
        return VkEventCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkEventCreateInfo callocStack(MemoryStack stack) {
        return VkEventCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkEventCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkEventCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.calloc(capacity, stack);
    }

    public static VkEventCreateInfo malloc(MemoryStack stack) {
        return new VkEventCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkEventCreateInfo calloc(MemoryStack stack) {
        return new VkEventCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkEventCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkEventCreateInfo.__member((int)4), VkEventCreateInfo.__member((int)POINTER_SIZE), VkEventCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkEventCreateInfo, Buffer>
    implements NativeResource {
        private static final VkEventCreateInfo ELEMENT_FACTORY = VkEventCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkEventCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkEventCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkEventCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkEventCreateFlags")
        public int flags() {
            return VkEventCreateInfo.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkEventCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(10);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkEventCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkExportMetalObjectCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImportMetalSharedEventInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkEventCreateFlags") int value) {
            VkEventCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

