/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageFormatListCreateInfo
extends Struct<VkImageFormatListCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int VIEWFORMATCOUNT;
    public static final int PVIEWFORMATS;

    protected VkImageFormatListCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkImageFormatListCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkImageFormatListCreateInfo(address, container);
    }

    public VkImageFormatListCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageFormatListCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageFormatListCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageFormatListCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewFormatCount() {
        return VkImageFormatListCreateInfo.nviewFormatCount(this.address());
    }

    @Nullable
    @NativeType(value="VkFormat const *")
    public IntBuffer pViewFormats() {
        return VkImageFormatListCreateInfo.npViewFormats(this.address());
    }

    public VkImageFormatListCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkImageFormatListCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkImageFormatListCreateInfo sType$Default() {
        return this.sType(1000147000);
    }

    public VkImageFormatListCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkImageFormatListCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkImageFormatListCreateInfo pViewFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
        VkImageFormatListCreateInfo.npViewFormats(this.address(), value);
        return this;
    }

    public VkImageFormatListCreateInfo set(int sType, long pNext, @Nullable IntBuffer pViewFormats) {
        this.sType(sType);
        this.pNext(pNext);
        this.pViewFormats(pViewFormats);
        return this;
    }

    public VkImageFormatListCreateInfo set(VkImageFormatListCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageFormatListCreateInfo malloc() {
        return new VkImageFormatListCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkImageFormatListCreateInfo calloc() {
        return new VkImageFormatListCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkImageFormatListCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkImageFormatListCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkImageFormatListCreateInfo create(long address) {
        return new VkImageFormatListCreateInfo(address, null);
    }

    @Nullable
    public static VkImageFormatListCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkImageFormatListCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkImageFormatListCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageFormatListCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkImageFormatListCreateInfo malloc(MemoryStack stack) {
        return new VkImageFormatListCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageFormatListCreateInfo calloc(MemoryStack stack) {
        return new VkImageFormatListCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nviewFormatCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWFORMATCOUNT);
    }

    @Nullable
    public static IntBuffer npViewFormats(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PVIEWFORMATS)), (int)VkImageFormatListCreateInfo.nviewFormatCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nviewFormatCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWFORMATCOUNT, value);
    }

    public static void npViewFormats(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVIEWFORMATS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkImageFormatListCreateInfo.nviewFormatCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkImageFormatListCreateInfo.nviewFormatCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVIEWFORMATS)));
        }
    }

    static {
        Struct.Layout layout = VkImageFormatListCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkImageFormatListCreateInfo.__member((int)4), VkImageFormatListCreateInfo.__member((int)POINTER_SIZE), VkImageFormatListCreateInfo.__member((int)4), VkImageFormatListCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        VIEWFORMATCOUNT = layout.offsetof(2);
        PVIEWFORMATS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImageFormatListCreateInfo, Buffer>
    implements NativeResource {
        private static final VkImageFormatListCreateInfo ELEMENT_FACTORY = VkImageFormatListCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageFormatListCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageFormatListCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageFormatListCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewFormatCount() {
            return VkImageFormatListCreateInfo.nviewFormatCount(this.address());
        }

        @Nullable
        @NativeType(value="VkFormat const *")
        public IntBuffer pViewFormats() {
            return VkImageFormatListCreateInfo.npViewFormats(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageFormatListCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000147000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageFormatListCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pViewFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
            VkImageFormatListCreateInfo.npViewFormats(this.address(), value);
            return this;
        }
    }
}

