/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkImageViewUsageCreateInfo;

public class VkImageViewUsageCreateInfoKHR
extends VkImageViewUsageCreateInfo {
    protected VkImageViewUsageCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageViewUsageCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkImageViewUsageCreateInfoKHR(address, container);
    }

    public VkImageViewUsageCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkImageViewUsageCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkImageViewUsageCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkImageViewUsageCreateInfoKHR sType$Default() {
        return this.sType(1000117002);
    }

    @Override
    public VkImageViewUsageCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkImageViewUsageCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkImageViewUsageCreateInfoKHR usage(@NativeType(value="VkImageUsageFlags") int value) {
        VkImageViewUsageCreateInfoKHR.nusage(this.address(), value);
        return this;
    }

    @Override
    public VkImageViewUsageCreateInfoKHR set(int sType, long pNext, int usage) {
        this.sType(sType);
        this.pNext(pNext);
        this.usage(usage);
        return this;
    }

    public VkImageViewUsageCreateInfoKHR set(VkImageViewUsageCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageViewUsageCreateInfoKHR malloc() {
        return new VkImageViewUsageCreateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkImageViewUsageCreateInfoKHR calloc() {
        return new VkImageViewUsageCreateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkImageViewUsageCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkImageViewUsageCreateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkImageViewUsageCreateInfoKHR create(long address) {
        return new VkImageViewUsageCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkImageViewUsageCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkImageViewUsageCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkImageViewUsageCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageViewUsageCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImageViewUsageCreateInfoKHR mallocStack() {
        return VkImageViewUsageCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageViewUsageCreateInfoKHR callocStack() {
        return VkImageViewUsageCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageViewUsageCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkImageViewUsageCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkImageViewUsageCreateInfoKHR callocStack(MemoryStack stack) {
        return VkImageViewUsageCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageViewUsageCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageViewUsageCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageViewUsageCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageViewUsageCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkImageViewUsageCreateInfoKHR malloc(MemoryStack stack) {
        return new VkImageViewUsageCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageViewUsageCreateInfoKHR calloc(MemoryStack stack) {
        return new VkImageViewUsageCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkImageViewUsageCreateInfo.Buffer {
        private static final VkImageViewUsageCreateInfoKHR ELEMENT_FACTORY = VkImageViewUsageCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImageViewUsageCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageViewUsageCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000117002);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageViewUsageCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer usage(@NativeType(value="VkImageUsageFlags") int value) {
            VkImageViewUsageCreateInfoKHR.nusage(this.address(), value);
            return this;
        }
    }
}

