/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMemoryFdInfoKHR
extends Struct<VkImportMemoryFdInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPE;
    public static final int FD;

    protected VkImportMemoryFdInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkImportMemoryFdInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkImportMemoryFdInfoKHR(address, container);
    }

    public VkImportMemoryFdInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImportMemoryFdInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportMemoryFdInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportMemoryFdInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
    public int handleType() {
        return VkImportMemoryFdInfoKHR.nhandleType(this.address());
    }

    public int fd() {
        return VkImportMemoryFdInfoKHR.nfd(this.address());
    }

    public VkImportMemoryFdInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkImportMemoryFdInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkImportMemoryFdInfoKHR sType$Default() {
        return this.sType(1000074000);
    }

    public VkImportMemoryFdInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkImportMemoryFdInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkImportMemoryFdInfoKHR handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
        VkImportMemoryFdInfoKHR.nhandleType(this.address(), value);
        return this;
    }

    public VkImportMemoryFdInfoKHR fd(int value) {
        VkImportMemoryFdInfoKHR.nfd(this.address(), value);
        return this;
    }

    public VkImportMemoryFdInfoKHR set(int sType, long pNext, int handleType, int fd) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleType(handleType);
        this.fd(fd);
        return this;
    }

    public VkImportMemoryFdInfoKHR set(VkImportMemoryFdInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImportMemoryFdInfoKHR malloc() {
        return new VkImportMemoryFdInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkImportMemoryFdInfoKHR calloc() {
        return new VkImportMemoryFdInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkImportMemoryFdInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkImportMemoryFdInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkImportMemoryFdInfoKHR create(long address) {
        return new VkImportMemoryFdInfoKHR(address, null);
    }

    @Nullable
    public static VkImportMemoryFdInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkImportMemoryFdInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkImportMemoryFdInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImportMemoryFdInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImportMemoryFdInfoKHR mallocStack() {
        return VkImportMemoryFdInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportMemoryFdInfoKHR callocStack() {
        return VkImportMemoryFdInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportMemoryFdInfoKHR mallocStack(MemoryStack stack) {
        return VkImportMemoryFdInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkImportMemoryFdInfoKHR callocStack(MemoryStack stack) {
        return VkImportMemoryFdInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImportMemoryFdInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImportMemoryFdInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryFdInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryFdInfoKHR.calloc(capacity, stack);
    }

    public static VkImportMemoryFdInfoKHR malloc(MemoryStack stack) {
        return new VkImportMemoryFdInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImportMemoryFdInfoKHR calloc(MemoryStack stack) {
        return new VkImportMemoryFdInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nhandleType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPE);
    }

    public static int nfd(long struct) {
        return UNSAFE.getInt(null, struct + (long)FD);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nhandleType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPE, value);
    }

    public static void nfd(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FD, value);
    }

    static {
        Struct.Layout layout = VkImportMemoryFdInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkImportMemoryFdInfoKHR.__member((int)4), VkImportMemoryFdInfoKHR.__member((int)POINTER_SIZE), VkImportMemoryFdInfoKHR.__member((int)4), VkImportMemoryFdInfoKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPE = layout.offsetof(2);
        FD = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImportMemoryFdInfoKHR, Buffer>
    implements NativeResource {
        private static final VkImportMemoryFdInfoKHR ELEMENT_FACTORY = VkImportMemoryFdInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImportMemoryFdInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportMemoryFdInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportMemoryFdInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
        public int handleType() {
            return VkImportMemoryFdInfoKHR.nhandleType(this.address());
        }

        public int fd() {
            return VkImportMemoryFdInfoKHR.nfd(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportMemoryFdInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000074000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportMemoryFdInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
            VkImportMemoryFdInfoKHR.nhandleType(this.address(), value);
            return this;
        }

        public Buffer fd(int value) {
            VkImportMemoryFdInfoKHR.nfd(this.address(), value);
            return this;
        }
    }
}

