/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMemoryWin32HandleInfoNV
extends Struct<VkImportMemoryWin32HandleInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPE;
    public static final int HANDLE;

    protected VkImportMemoryWin32HandleInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkImportMemoryWin32HandleInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkImportMemoryWin32HandleInfoNV(address, container);
    }

    public VkImportMemoryWin32HandleInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImportMemoryWin32HandleInfoNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportMemoryWin32HandleInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportMemoryWin32HandleInfoNV.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
    public int handleType() {
        return VkImportMemoryWin32HandleInfoNV.nhandleType(this.address());
    }

    @NativeType(value="HANDLE")
    public long handle() {
        return VkImportMemoryWin32HandleInfoNV.nhandle(this.address());
    }

    public VkImportMemoryWin32HandleInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkImportMemoryWin32HandleInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV sType$Default() {
        return this.sType(1000057000);
    }

    public VkImportMemoryWin32HandleInfoNV pNext(@NativeType(value="void const *") long value) {
        VkImportMemoryWin32HandleInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
        VkImportMemoryWin32HandleInfoNV.nhandleType(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV handle(@NativeType(value="HANDLE") long value) {
        VkImportMemoryWin32HandleInfoNV.nhandle(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV set(int sType, long pNext, int handleType, long handle) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleType(handleType);
        this.handle(handle);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV set(VkImportMemoryWin32HandleInfoNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImportMemoryWin32HandleInfoNV malloc() {
        return new VkImportMemoryWin32HandleInfoNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkImportMemoryWin32HandleInfoNV calloc() {
        return new VkImportMemoryWin32HandleInfoNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkImportMemoryWin32HandleInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkImportMemoryWin32HandleInfoNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkImportMemoryWin32HandleInfoNV create(long address) {
        return new VkImportMemoryWin32HandleInfoNV(address, null);
    }

    @Nullable
    public static VkImportMemoryWin32HandleInfoNV createSafe(long address) {
        return address == 0L ? null : new VkImportMemoryWin32HandleInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkImportMemoryWin32HandleInfoNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImportMemoryWin32HandleInfoNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoNV mallocStack() {
        return VkImportMemoryWin32HandleInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoNV callocStack() {
        return VkImportMemoryWin32HandleInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoNV mallocStack(MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoNV callocStack(MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.calloc(capacity, stack);
    }

    public static VkImportMemoryWin32HandleInfoNV malloc(MemoryStack stack) {
        return new VkImportMemoryWin32HandleInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImportMemoryWin32HandleInfoNV calloc(MemoryStack stack) {
        return new VkImportMemoryWin32HandleInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nhandleType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPE);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HANDLE));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nhandleType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPE, value);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HANDLE), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)HANDLE)));
    }

    static {
        Struct.Layout layout = VkImportMemoryWin32HandleInfoNV.__struct((Struct.Member[])new Struct.Member[]{VkImportMemoryWin32HandleInfoNV.__member((int)4), VkImportMemoryWin32HandleInfoNV.__member((int)POINTER_SIZE), VkImportMemoryWin32HandleInfoNV.__member((int)4), VkImportMemoryWin32HandleInfoNV.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPE = layout.offsetof(2);
        HANDLE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImportMemoryWin32HandleInfoNV, Buffer>
    implements NativeResource {
        private static final VkImportMemoryWin32HandleInfoNV ELEMENT_FACTORY = VkImportMemoryWin32HandleInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImportMemoryWin32HandleInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportMemoryWin32HandleInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportMemoryWin32HandleInfoNV.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
        public int handleType() {
            return VkImportMemoryWin32HandleInfoNV.nhandleType(this.address());
        }

        @NativeType(value="HANDLE")
        public long handle() {
            return VkImportMemoryWin32HandleInfoNV.nhandle(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportMemoryWin32HandleInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000057000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportMemoryWin32HandleInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
            VkImportMemoryWin32HandleInfoNV.nhandleType(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="HANDLE") long value) {
            VkImportMemoryWin32HandleInfoNV.nhandle(this.address(), value);
            return this;
        }
    }
}

