/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.DispatchableHandleInstance;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkApplicationInfo;
import org.lwjgl.vulkan.VkExtensionProperties;
import org.lwjgl.vulkan.VkInstanceCreateInfo;

public class VkInstance
extends DispatchableHandleInstance {
    public VkInstance(long handle, VkInstanceCreateInfo ci) {
        super(handle, VkInstance.getInstanceCapabilities(handle, ci));
    }

    private static VKCapabilitiesInstance getInstanceCapabilities(long handle, VkInstanceCreateInfo ci) {
        VkApplicationInfo appInfo = ci.pApplicationInfo();
        int apiVersion = appInfo != null && appInfo.apiVersion() != 0 ? appInfo.apiVersion() : VK10.VK_API_VERSION_1_0;
        return new VKCapabilitiesInstance(functionName -> {
            long address = JNI.callPPP((long)handle, (long)MemoryUtil.memAddress((ByteBuffer)functionName), (long)VK.getGlobalCommands().vkGetInstanceProcAddr);
            if (address == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLogMissing((String)"VK instance", (ByteBuffer)functionName);
            }
            return address;
        }, apiVersion, VK.getEnabledExtensionSet(apiVersion, ci.ppEnabledExtensionNames()), VkInstance.getAvailableDeviceExtensions(handle));
    }

    private static Set<String> getAvailableDeviceExtensions(long instance) {
        HashSet<String> extensions = new HashSet<String>();
        try (MemoryStack frame0 = MemoryStack.stackPush();){
            int err;
            IntBuffer ip = frame0.callocInt(1);
            long GetInstanceProcAddr = VK.getGlobalCommands().vkGetInstanceProcAddr;
            long EnumeratePhysicalDevices = JNI.callPPP((long)instance, (long)MemoryUtil.memAddress((ByteBuffer)frame0.ASCII((CharSequence)"vkEnumeratePhysicalDevices")), (long)GetInstanceProcAddr);
            long EnumerateDeviceExtensionProperties = JNI.callPPP((long)instance, (long)MemoryUtil.memAddress((ByteBuffer)frame0.ASCII((CharSequence)"vkEnumerateDeviceExtensionProperties")), (long)GetInstanceProcAddr);
            if (EnumeratePhysicalDevices != 0L && EnumerateDeviceExtensionProperties != 0L && (err = JNI.callPPPI((long)instance, (long)MemoryUtil.memAddress((IntBuffer)ip), (long)0L, (long)EnumeratePhysicalDevices)) == 0 && ip.get(0) != 0) {
                PointerBuffer physicalDevices = frame0.mallocPointer(ip.get(0));
                err = JNI.callPPPI((long)instance, (long)MemoryUtil.memAddress((IntBuffer)ip), (long)MemoryUtil.memAddress((CustomBuffer)physicalDevices), (long)EnumeratePhysicalDevices);
                if (err == 0) {
                    for (int i = 0; i < physicalDevices.remaining(); ++i) {
                        err = JNI.callPPPPI((long)physicalDevices.get(i), (long)0L, (long)MemoryUtil.memAddress((IntBuffer)ip), (long)0L, (long)EnumerateDeviceExtensionProperties);
                        if (err != 0 || ip.get(0) == 0) continue;
                        try (MemoryStack frame1 = frame0.push();){
                            VkExtensionProperties.Buffer deviceExtensions = VkExtensionProperties.malloc(ip.get(0), frame1);
                            err = JNI.callPPPPI((long)physicalDevices.get(i), (long)0L, (long)MemoryUtil.memAddress((IntBuffer)ip), (long)deviceExtensions.address(), (long)EnumerateDeviceExtensionProperties);
                            if (err != 0) continue;
                            for (int j = 0; j < deviceExtensions.remaining(); ++j) {
                                extensions.add(((VkExtensionProperties)deviceExtensions.get(j)).extensionNameString());
                            }
                            continue;
                        }
                    }
                }
            }
        }
        return extensions;
    }
}

