/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMultiDrawIndexedInfoEXT
extends Struct<VkMultiDrawIndexedInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FIRSTINDEX;
    public static final int INDEXCOUNT;
    public static final int VERTEXOFFSET;

    protected VkMultiDrawIndexedInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMultiDrawIndexedInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMultiDrawIndexedInfoEXT(address, container);
    }

    public VkMultiDrawIndexedInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMultiDrawIndexedInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int firstIndex() {
        return VkMultiDrawIndexedInfoEXT.nfirstIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCount() {
        return VkMultiDrawIndexedInfoEXT.nindexCount(this.address());
    }

    @NativeType(value="int32_t")
    public int vertexOffset() {
        return VkMultiDrawIndexedInfoEXT.nvertexOffset(this.address());
    }

    public VkMultiDrawIndexedInfoEXT firstIndex(@NativeType(value="uint32_t") int value) {
        VkMultiDrawIndexedInfoEXT.nfirstIndex(this.address(), value);
        return this;
    }

    public VkMultiDrawIndexedInfoEXT indexCount(@NativeType(value="uint32_t") int value) {
        VkMultiDrawIndexedInfoEXT.nindexCount(this.address(), value);
        return this;
    }

    public VkMultiDrawIndexedInfoEXT vertexOffset(@NativeType(value="int32_t") int value) {
        VkMultiDrawIndexedInfoEXT.nvertexOffset(this.address(), value);
        return this;
    }

    public VkMultiDrawIndexedInfoEXT set(int firstIndex, int indexCount, int vertexOffset) {
        this.firstIndex(firstIndex);
        this.indexCount(indexCount);
        this.vertexOffset(vertexOffset);
        return this;
    }

    public VkMultiDrawIndexedInfoEXT set(VkMultiDrawIndexedInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMultiDrawIndexedInfoEXT malloc() {
        return new VkMultiDrawIndexedInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMultiDrawIndexedInfoEXT calloc() {
        return new VkMultiDrawIndexedInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMultiDrawIndexedInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMultiDrawIndexedInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMultiDrawIndexedInfoEXT create(long address) {
        return new VkMultiDrawIndexedInfoEXT(address, null);
    }

    @Nullable
    public static VkMultiDrawIndexedInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkMultiDrawIndexedInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMultiDrawIndexedInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMultiDrawIndexedInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMultiDrawIndexedInfoEXT malloc(MemoryStack stack) {
        return new VkMultiDrawIndexedInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMultiDrawIndexedInfoEXT calloc(MemoryStack stack) {
        return new VkMultiDrawIndexedInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nfirstIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRSTINDEX);
    }

    public static int nindexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXCOUNT);
    }

    public static int nvertexOffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXOFFSET);
    }

    public static void nfirstIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRSTINDEX, value);
    }

    public static void nindexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXCOUNT, value);
    }

    public static void nvertexOffset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXOFFSET, value);
    }

    static {
        Struct.Layout layout = VkMultiDrawIndexedInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkMultiDrawIndexedInfoEXT.__member((int)4), VkMultiDrawIndexedInfoEXT.__member((int)4), VkMultiDrawIndexedInfoEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FIRSTINDEX = layout.offsetof(0);
        INDEXCOUNT = layout.offsetof(1);
        VERTEXOFFSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMultiDrawIndexedInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMultiDrawIndexedInfoEXT ELEMENT_FACTORY = VkMultiDrawIndexedInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMultiDrawIndexedInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int firstIndex() {
            return VkMultiDrawIndexedInfoEXT.nfirstIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCount() {
            return VkMultiDrawIndexedInfoEXT.nindexCount(this.address());
        }

        @NativeType(value="int32_t")
        public int vertexOffset() {
            return VkMultiDrawIndexedInfoEXT.nvertexOffset(this.address());
        }

        public Buffer firstIndex(@NativeType(value="uint32_t") int value) {
            VkMultiDrawIndexedInfoEXT.nfirstIndex(this.address(), value);
            return this;
        }

        public Buffer indexCount(@NativeType(value="uint32_t") int value) {
            VkMultiDrawIndexedInfoEXT.nindexCount(this.address(), value);
            return this;
        }

        public Buffer vertexOffset(@NativeType(value="int32_t") int value) {
            VkMultiDrawIndexedInfoEXT.nvertexOffset(this.address(), value);
            return this;
        }
    }
}

