/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineIndirectDeviceAddressInfoNV
extends Struct<VkPipelineIndirectDeviceAddressInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PIPELINEBINDPOINT;
    public static final int PIPELINE;

    protected VkPipelineIndirectDeviceAddressInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPipelineIndirectDeviceAddressInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineIndirectDeviceAddressInfoNV(address, container);
    }

    public VkPipelineIndirectDeviceAddressInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineIndirectDeviceAddressInfoNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineIndirectDeviceAddressInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineIndirectDeviceAddressInfoNV.npNext(this.address());
    }

    @NativeType(value="VkPipelineBindPoint")
    public int pipelineBindPoint() {
        return VkPipelineIndirectDeviceAddressInfoNV.npipelineBindPoint(this.address());
    }

    @NativeType(value="VkPipeline")
    public long pipeline() {
        return VkPipelineIndirectDeviceAddressInfoNV.npipeline(this.address());
    }

    public VkPipelineIndirectDeviceAddressInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineIndirectDeviceAddressInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkPipelineIndirectDeviceAddressInfoNV sType$Default() {
        return this.sType(1000428002);
    }

    public VkPipelineIndirectDeviceAddressInfoNV pNext(@NativeType(value="void const *") long value) {
        VkPipelineIndirectDeviceAddressInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkPipelineIndirectDeviceAddressInfoNV pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
        VkPipelineIndirectDeviceAddressInfoNV.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkPipelineIndirectDeviceAddressInfoNV pipeline(@NativeType(value="VkPipeline") long value) {
        VkPipelineIndirectDeviceAddressInfoNV.npipeline(this.address(), value);
        return this;
    }

    public VkPipelineIndirectDeviceAddressInfoNV set(int sType, long pNext, int pipelineBindPoint, long pipeline) {
        this.sType(sType);
        this.pNext(pNext);
        this.pipelineBindPoint(pipelineBindPoint);
        this.pipeline(pipeline);
        return this;
    }

    public VkPipelineIndirectDeviceAddressInfoNV set(VkPipelineIndirectDeviceAddressInfoNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineIndirectDeviceAddressInfoNV malloc() {
        return new VkPipelineIndirectDeviceAddressInfoNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPipelineIndirectDeviceAddressInfoNV calloc() {
        return new VkPipelineIndirectDeviceAddressInfoNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPipelineIndirectDeviceAddressInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPipelineIndirectDeviceAddressInfoNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPipelineIndirectDeviceAddressInfoNV create(long address) {
        return new VkPipelineIndirectDeviceAddressInfoNV(address, null);
    }

    @Nullable
    public static VkPipelineIndirectDeviceAddressInfoNV createSafe(long address) {
        return address == 0L ? null : new VkPipelineIndirectDeviceAddressInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPipelineIndirectDeviceAddressInfoNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineIndirectDeviceAddressInfoNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineIndirectDeviceAddressInfoNV malloc(MemoryStack stack) {
        return new VkPipelineIndirectDeviceAddressInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineIndirectDeviceAddressInfoNV calloc(MemoryStack stack) {
        return new VkPipelineIndirectDeviceAddressInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int npipelineBindPoint(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIPELINEBINDPOINT);
    }

    public static long npipeline(long struct) {
        return UNSAFE.getLong(null, struct + (long)PIPELINE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void npipeline(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PIPELINE, value);
    }

    static {
        Struct.Layout layout = VkPipelineIndirectDeviceAddressInfoNV.__struct((Struct.Member[])new Struct.Member[]{VkPipelineIndirectDeviceAddressInfoNV.__member((int)4), VkPipelineIndirectDeviceAddressInfoNV.__member((int)POINTER_SIZE), VkPipelineIndirectDeviceAddressInfoNV.__member((int)4), VkPipelineIndirectDeviceAddressInfoNV.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PIPELINEBINDPOINT = layout.offsetof(2);
        PIPELINE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineIndirectDeviceAddressInfoNV, Buffer>
    implements NativeResource {
        private static final VkPipelineIndirectDeviceAddressInfoNV ELEMENT_FACTORY = VkPipelineIndirectDeviceAddressInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPipelineIndirectDeviceAddressInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineIndirectDeviceAddressInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineIndirectDeviceAddressInfoNV.npNext(this.address());
        }

        @NativeType(value="VkPipelineBindPoint")
        public int pipelineBindPoint() {
            return VkPipelineIndirectDeviceAddressInfoNV.npipelineBindPoint(this.address());
        }

        @NativeType(value="VkPipeline")
        public long pipeline() {
            return VkPipelineIndirectDeviceAddressInfoNV.npipeline(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineIndirectDeviceAddressInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000428002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineIndirectDeviceAddressInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
            VkPipelineIndirectDeviceAddressInfoNV.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer pipeline(@NativeType(value="VkPipeline") long value) {
            VkPipelineIndirectDeviceAddressInfoNV.npipeline(this.address(), value);
            return this;
        }
    }
}

