/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkPipelineInfoKHR;

public class VkPipelineInfoEXT
extends VkPipelineInfoKHR {
    protected VkPipelineInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineInfoEXT(address, container);
    }

    public VkPipelineInfoEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkPipelineInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineInfoEXT.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineInfoEXT sType$Default() {
        return this.sType(1000269001);
    }

    @Override
    public VkPipelineInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkPipelineInfoEXT.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineInfoEXT pipeline(@NativeType(value="VkPipeline") long value) {
        VkPipelineInfoEXT.npipeline(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineInfoEXT set(int sType, long pNext, long pipeline) {
        this.sType(sType);
        this.pNext(pNext);
        this.pipeline(pipeline);
        return this;
    }

    public VkPipelineInfoEXT set(VkPipelineInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineInfoEXT malloc() {
        return new VkPipelineInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPipelineInfoEXT calloc() {
        return new VkPipelineInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPipelineInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPipelineInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPipelineInfoEXT create(long address) {
        return new VkPipelineInfoEXT(address, null);
    }

    @Nullable
    public static VkPipelineInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkPipelineInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPipelineInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineInfoEXT malloc(MemoryStack stack) {
        return new VkPipelineInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineInfoEXT calloc(MemoryStack stack) {
        return new VkPipelineInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkPipelineInfoKHR.Buffer {
        private static final VkPipelineInfoEXT ELEMENT_FACTORY = VkPipelineInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineInfoEXT.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000269001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineInfoEXT.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pipeline(@NativeType(value="VkPipeline") long value) {
            VkPipelineInfoEXT.npipeline(this.address(), value);
            return this;
        }
    }
}

