/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkVideoEncodeH264PictureInfoKHR;
import org.lwjgl.vulkan.VkVideoEncodeH265PictureInfoKHR;
import org.lwjgl.vulkan.VkVideoInlineQueryInfoKHR;
import org.lwjgl.vulkan.VkVideoPictureResourceInfoKHR;
import org.lwjgl.vulkan.VkVideoReferenceSlotInfoKHR;

public class VkVideoEncodeInfoKHR
extends Struct<VkVideoEncodeInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DSTBUFFER;
    public static final int DSTBUFFEROFFSET;
    public static final int DSTBUFFERRANGE;
    public static final int SRCPICTURERESOURCE;
    public static final int PSETUPREFERENCESLOT;
    public static final int REFERENCESLOTCOUNT;
    public static final int PREFERENCESLOTS;
    public static final int PRECEDINGEXTERNALLYENCODEDBYTES;

    protected VkVideoEncodeInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkVideoEncodeInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoEncodeInfoKHR(address, container);
    }

    public VkVideoEncodeInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkVideoEncodeInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoEncodeInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoEncodeInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoEncodeFlagsKHR")
    public int flags() {
        return VkVideoEncodeInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkBuffer")
    public long dstBuffer() {
        return VkVideoEncodeInfoKHR.ndstBuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long dstBufferOffset() {
        return VkVideoEncodeInfoKHR.ndstBufferOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long dstBufferRange() {
        return VkVideoEncodeInfoKHR.ndstBufferRange(this.address());
    }

    public VkVideoPictureResourceInfoKHR srcPictureResource() {
        return VkVideoEncodeInfoKHR.nsrcPictureResource(this.address());
    }

    @Nullable
    @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
    public VkVideoReferenceSlotInfoKHR pSetupReferenceSlot() {
        return VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address());
    }

    @NativeType(value="uint32_t")
    public int referenceSlotCount() {
        return VkVideoEncodeInfoKHR.nreferenceSlotCount(this.address());
    }

    @Nullable
    @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
    public VkVideoReferenceSlotInfoKHR.Buffer pReferenceSlots() {
        return VkVideoEncodeInfoKHR.npReferenceSlots(this.address());
    }

    @NativeType(value="uint32_t")
    public int precedingExternallyEncodedBytes() {
        return VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address());
    }

    public VkVideoEncodeInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoEncodeInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR sType$Default() {
        return this.sType(1000299000);
    }

    public VkVideoEncodeInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoEncodeInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoEncodeH264PictureInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoEncodeH265PictureInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoInlineQueryInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR flags(@NativeType(value="VkVideoEncodeFlagsKHR") int value) {
        VkVideoEncodeInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR dstBuffer(@NativeType(value="VkBuffer") long value) {
        VkVideoEncodeInfoKHR.ndstBuffer(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR dstBufferOffset(@NativeType(value="VkDeviceSize") long value) {
        VkVideoEncodeInfoKHR.ndstBufferOffset(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR dstBufferRange(@NativeType(value="VkDeviceSize") long value) {
        VkVideoEncodeInfoKHR.ndstBufferRange(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR srcPictureResource(VkVideoPictureResourceInfoKHR value) {
        VkVideoEncodeInfoKHR.nsrcPictureResource(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR srcPictureResource(Consumer<VkVideoPictureResourceInfoKHR> consumer) {
        consumer.accept(this.srcPictureResource());
        return this;
    }

    public VkVideoEncodeInfoKHR pSetupReferenceSlot(@Nullable @NativeType(value="VkVideoReferenceSlotInfoKHR const *") VkVideoReferenceSlotInfoKHR value) {
        VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR pReferenceSlots(@Nullable @NativeType(value="VkVideoReferenceSlotInfoKHR const *") VkVideoReferenceSlotInfoKHR.Buffer value) {
        VkVideoEncodeInfoKHR.npReferenceSlots(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR precedingExternallyEncodedBytes(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR set(int sType, long pNext, int flags, long dstBuffer, long dstBufferOffset, long dstBufferRange, VkVideoPictureResourceInfoKHR srcPictureResource, @Nullable VkVideoReferenceSlotInfoKHR pSetupReferenceSlot, @Nullable VkVideoReferenceSlotInfoKHR.Buffer pReferenceSlots, int precedingExternallyEncodedBytes) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.dstBuffer(dstBuffer);
        this.dstBufferOffset(dstBufferOffset);
        this.dstBufferRange(dstBufferRange);
        this.srcPictureResource(srcPictureResource);
        this.pSetupReferenceSlot(pSetupReferenceSlot);
        this.pReferenceSlots(pReferenceSlots);
        this.precedingExternallyEncodedBytes(precedingExternallyEncodedBytes);
        return this;
    }

    public VkVideoEncodeInfoKHR set(VkVideoEncodeInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkVideoEncodeInfoKHR malloc() {
        return new VkVideoEncodeInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkVideoEncodeInfoKHR calloc() {
        return new VkVideoEncodeInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkVideoEncodeInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkVideoEncodeInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkVideoEncodeInfoKHR create(long address) {
        return new VkVideoEncodeInfoKHR(address, null);
    }

    @Nullable
    public static VkVideoEncodeInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoEncodeInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkVideoEncodeInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoEncodeInfoKHR malloc(MemoryStack stack) {
        return new VkVideoEncodeInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoEncodeInfoKHR calloc(MemoryStack stack) {
        return new VkVideoEncodeInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long ndstBuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTBUFFER);
    }

    public static long ndstBufferOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTBUFFEROFFSET);
    }

    public static long ndstBufferRange(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTBUFFERRANGE);
    }

    public static VkVideoPictureResourceInfoKHR nsrcPictureResource(long struct) {
        return VkVideoPictureResourceInfoKHR.create(struct + (long)SRCPICTURERESOURCE);
    }

    @Nullable
    public static VkVideoReferenceSlotInfoKHR npSetupReferenceSlot(long struct) {
        return VkVideoReferenceSlotInfoKHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSETUPREFERENCESLOT)));
    }

    public static int nreferenceSlotCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REFERENCESLOTCOUNT);
    }

    @Nullable
    public static VkVideoReferenceSlotInfoKHR.Buffer npReferenceSlots(long struct) {
        return VkVideoReferenceSlotInfoKHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PREFERENCESLOTS)), VkVideoEncodeInfoKHR.nreferenceSlotCount(struct));
    }

    public static int nprecedingExternallyEncodedBytes(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRECEDINGEXTERNALLYENCODEDBYTES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndstBuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTBUFFER, value);
    }

    public static void ndstBufferOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTBUFFEROFFSET, value);
    }

    public static void ndstBufferRange(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTBUFFERRANGE, value);
    }

    public static void nsrcPictureResource(long struct, VkVideoPictureResourceInfoKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SRCPICTURERESOURCE), (long)VkVideoPictureResourceInfoKHR.SIZEOF);
    }

    public static void npSetupReferenceSlot(long struct, @Nullable VkVideoReferenceSlotInfoKHR value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSETUPREFERENCESLOT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nreferenceSlotCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REFERENCESLOTCOUNT, value);
    }

    public static void npReferenceSlots(long struct, @Nullable VkVideoReferenceSlotInfoKHR.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREFERENCESLOTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkVideoEncodeInfoKHR.nreferenceSlotCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nprecedingExternallyEncodedBytes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRECEDINGEXTERNALLYENCODEDBYTES, value);
    }

    public static void validate(long struct) {
        if (VkVideoEncodeInfoKHR.nreferenceSlotCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREFERENCESLOTS)));
        }
    }

    static {
        Struct.Layout layout = VkVideoEncodeInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkVideoEncodeInfoKHR.__member((int)4), VkVideoEncodeInfoKHR.__member((int)POINTER_SIZE), VkVideoEncodeInfoKHR.__member((int)4), VkVideoEncodeInfoKHR.__member((int)8), VkVideoEncodeInfoKHR.__member((int)8), VkVideoEncodeInfoKHR.__member((int)8), VkVideoEncodeInfoKHR.__member((int)VkVideoPictureResourceInfoKHR.SIZEOF, (int)VkVideoPictureResourceInfoKHR.ALIGNOF), VkVideoEncodeInfoKHR.__member((int)POINTER_SIZE), VkVideoEncodeInfoKHR.__member((int)4), VkVideoEncodeInfoKHR.__member((int)POINTER_SIZE), VkVideoEncodeInfoKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DSTBUFFER = layout.offsetof(3);
        DSTBUFFEROFFSET = layout.offsetof(4);
        DSTBUFFERRANGE = layout.offsetof(5);
        SRCPICTURERESOURCE = layout.offsetof(6);
        PSETUPREFERENCESLOT = layout.offsetof(7);
        REFERENCESLOTCOUNT = layout.offsetof(8);
        PREFERENCESLOTS = layout.offsetof(9);
        PRECEDINGEXTERNALLYENCODEDBYTES = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeInfoKHR ELEMENT_FACTORY = VkVideoEncodeInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkVideoEncodeInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoEncodeInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoEncodeInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoEncodeFlagsKHR")
        public int flags() {
            return VkVideoEncodeInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkBuffer")
        public long dstBuffer() {
            return VkVideoEncodeInfoKHR.ndstBuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long dstBufferOffset() {
            return VkVideoEncodeInfoKHR.ndstBufferOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long dstBufferRange() {
            return VkVideoEncodeInfoKHR.ndstBufferRange(this.address());
        }

        public VkVideoPictureResourceInfoKHR srcPictureResource() {
            return VkVideoEncodeInfoKHR.nsrcPictureResource(this.address());
        }

        @Nullable
        @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
        public VkVideoReferenceSlotInfoKHR pSetupReferenceSlot() {
            return VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address());
        }

        @NativeType(value="uint32_t")
        public int referenceSlotCount() {
            return VkVideoEncodeInfoKHR.nreferenceSlotCount(this.address());
        }

        @Nullable
        @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
        public VkVideoReferenceSlotInfoKHR.Buffer pReferenceSlots() {
            return VkVideoEncodeInfoKHR.npReferenceSlots(this.address());
        }

        @NativeType(value="uint32_t")
        public int precedingExternallyEncodedBytes() {
            return VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoEncodeInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000299000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoEncodeInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoEncodeH264PictureInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265PictureInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoInlineQueryInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkVideoEncodeFlagsKHR") int value) {
            VkVideoEncodeInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer dstBuffer(@NativeType(value="VkBuffer") long value) {
            VkVideoEncodeInfoKHR.ndstBuffer(this.address(), value);
            return this;
        }

        public Buffer dstBufferOffset(@NativeType(value="VkDeviceSize") long value) {
            VkVideoEncodeInfoKHR.ndstBufferOffset(this.address(), value);
            return this;
        }

        public Buffer dstBufferRange(@NativeType(value="VkDeviceSize") long value) {
            VkVideoEncodeInfoKHR.ndstBufferRange(this.address(), value);
            return this;
        }

        public Buffer srcPictureResource(VkVideoPictureResourceInfoKHR value) {
            VkVideoEncodeInfoKHR.nsrcPictureResource(this.address(), value);
            return this;
        }

        public Buffer srcPictureResource(Consumer<VkVideoPictureResourceInfoKHR> consumer) {
            consumer.accept(this.srcPictureResource());
            return this;
        }

        public Buffer pSetupReferenceSlot(@Nullable @NativeType(value="VkVideoReferenceSlotInfoKHR const *") VkVideoReferenceSlotInfoKHR value) {
            VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address(), value);
            return this;
        }

        public Buffer pReferenceSlots(@Nullable @NativeType(value="VkVideoReferenceSlotInfoKHR const *") VkVideoReferenceSlotInfoKHR.Buffer value) {
            VkVideoEncodeInfoKHR.npReferenceSlots(this.address(), value);
            return this;
        }

        public Buffer precedingExternallyEncodedBytes(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address(), value);
            return this;
        }
    }
}

