/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class StdVideoEncodeH265LongTermRefPics
extends Struct<StdVideoEncodeH265LongTermRefPics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUM_LONG_TERM_SPS;
    public static final int NUM_LONG_TERM_PICS;
    public static final int LT_IDX_SPS;
    public static final int POC_LSB_LT;
    public static final int USED_BY_CURR_PIC_LT_FLAG;
    public static final int DELTA_POC_MSB_PRESENT_FLAG;
    public static final int DELTA_POC_MSB_CYCLE_LT;

    protected StdVideoEncodeH265LongTermRefPics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoEncodeH265LongTermRefPics create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH265LongTermRefPics(address, container);
    }

    public StdVideoEncodeH265LongTermRefPics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeH265LongTermRefPics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t")
    public byte num_long_term_sps() {
        return StdVideoEncodeH265LongTermRefPics.nnum_long_term_sps(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_long_term_pics() {
        return StdVideoEncodeH265LongTermRefPics.nnum_long_term_pics(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS]")
    public ByteBuffer lt_idx_sps() {
        return StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address());
    }

    @NativeType(value="uint8_t")
    public byte lt_idx_sps(int index) {
        return StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_PICS]")
    public ByteBuffer poc_lsb_lt() {
        return StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address());
    }

    @NativeType(value="uint8_t")
    public byte poc_lsb_lt(int index) {
        return StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), index);
    }

    @NativeType(value="uint16_t")
    public short used_by_curr_pic_lt_flag() {
        return StdVideoEncodeH265LongTermRefPics.nused_by_curr_pic_lt_flag(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]")
    public ByteBuffer delta_poc_msb_present_flag() {
        return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address());
    }

    @NativeType(value="uint8_t")
    public byte delta_poc_msb_present_flag(int index) {
        return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]")
    public ByteBuffer delta_poc_msb_cycle_lt() {
        return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address());
    }

    @NativeType(value="uint8_t")
    public byte delta_poc_msb_cycle_lt(int index) {
        return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), index);
    }

    public StdVideoEncodeH265LongTermRefPics num_long_term_sps(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.nnum_long_term_sps(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics num_long_term_pics(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.nnum_long_term_pics(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics lt_idx_sps(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS]") ByteBuffer value) {
        StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics lt_idx_sps(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics poc_lsb_lt(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_PICS]") ByteBuffer value) {
        StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics poc_lsb_lt(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics used_by_curr_pic_lt_flag(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeH265LongTermRefPics.nused_by_curr_pic_lt_flag(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics delta_poc_msb_present_flag(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]") ByteBuffer value) {
        StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics delta_poc_msb_present_flag(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics delta_poc_msb_cycle_lt(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]") ByteBuffer value) {
        StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics delta_poc_msb_cycle_lt(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics set(byte num_long_term_sps, byte num_long_term_pics, ByteBuffer lt_idx_sps, ByteBuffer poc_lsb_lt, short used_by_curr_pic_lt_flag, ByteBuffer delta_poc_msb_present_flag, ByteBuffer delta_poc_msb_cycle_lt) {
        this.num_long_term_sps(num_long_term_sps);
        this.num_long_term_pics(num_long_term_pics);
        this.lt_idx_sps(lt_idx_sps);
        this.poc_lsb_lt(poc_lsb_lt);
        this.used_by_curr_pic_lt_flag(used_by_curr_pic_lt_flag);
        this.delta_poc_msb_present_flag(delta_poc_msb_present_flag);
        this.delta_poc_msb_cycle_lt(delta_poc_msb_cycle_lt);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics set(StdVideoEncodeH265LongTermRefPics src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeH265LongTermRefPics malloc() {
        return new StdVideoEncodeH265LongTermRefPics(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoEncodeH265LongTermRefPics calloc() {
        return new StdVideoEncodeH265LongTermRefPics(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoEncodeH265LongTermRefPics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoEncodeH265LongTermRefPics(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoEncodeH265LongTermRefPics create(long address) {
        return new StdVideoEncodeH265LongTermRefPics(address, null);
    }

    @Nullable
    public static StdVideoEncodeH265LongTermRefPics createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH265LongTermRefPics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoEncodeH265LongTermRefPics.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH265LongTermRefPics.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH265LongTermRefPics malloc(MemoryStack stack) {
        return new StdVideoEncodeH265LongTermRefPics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH265LongTermRefPics calloc(MemoryStack stack) {
        return new StdVideoEncodeH265LongTermRefPics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nnum_long_term_sps(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_LONG_TERM_SPS);
    }

    public static byte nnum_long_term_pics(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_LONG_TERM_PICS);
    }

    public static ByteBuffer nlt_idx_sps(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LT_IDX_SPS), (int)32);
    }

    public static byte nlt_idx_sps(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)LT_IDX_SPS + Checks.check((int)index, (int)32) * 1L);
    }

    public static ByteBuffer npoc_lsb_lt(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)POC_LSB_LT), (int)16);
    }

    public static byte npoc_lsb_lt(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)POC_LSB_LT + Checks.check((int)index, (int)16) * 1L);
    }

    public static short nused_by_curr_pic_lt_flag(long struct) {
        return UNSAFE.getShort(null, struct + (long)USED_BY_CURR_PIC_LT_FLAG);
    }

    public static ByteBuffer ndelta_poc_msb_present_flag(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DELTA_POC_MSB_PRESENT_FLAG), (int)48);
    }

    public static byte ndelta_poc_msb_present_flag(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DELTA_POC_MSB_PRESENT_FLAG + Checks.check((int)index, (int)48) * 1L);
    }

    public static ByteBuffer ndelta_poc_msb_cycle_lt(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DELTA_POC_MSB_CYCLE_LT), (int)48);
    }

    public static byte ndelta_poc_msb_cycle_lt(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DELTA_POC_MSB_CYCLE_LT + Checks.check((int)index, (int)48) * 1L);
    }

    public static void nnum_long_term_sps(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_LONG_TERM_SPS, value);
    }

    public static void nnum_long_term_pics(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_LONG_TERM_PICS, value);
    }

    public static void nlt_idx_sps(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)32);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)LT_IDX_SPS), (long)(value.remaining() * 1));
    }

    public static void nlt_idx_sps(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)LT_IDX_SPS + Checks.check((int)index, (int)32) * 1L, value);
    }

    public static void npoc_lsb_lt(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)POC_LSB_LT), (long)(value.remaining() * 1));
    }

    public static void npoc_lsb_lt(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)POC_LSB_LT + Checks.check((int)index, (int)16) * 1L, value);
    }

    public static void nused_by_curr_pic_lt_flag(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)USED_BY_CURR_PIC_LT_FLAG, value);
    }

    public static void ndelta_poc_msb_present_flag(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)48);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DELTA_POC_MSB_PRESENT_FLAG), (long)(value.remaining() * 1));
    }

    public static void ndelta_poc_msb_present_flag(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_POC_MSB_PRESENT_FLAG + Checks.check((int)index, (int)48) * 1L, value);
    }

    public static void ndelta_poc_msb_cycle_lt(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)48);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DELTA_POC_MSB_CYCLE_LT), (long)(value.remaining() * 1));
    }

    public static void ndelta_poc_msb_cycle_lt(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_POC_MSB_CYCLE_LT + Checks.check((int)index, (int)48) * 1L, value);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH265LongTermRefPics.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeH265LongTermRefPics.__member((int)1), StdVideoEncodeH265LongTermRefPics.__member((int)1), StdVideoEncodeH265LongTermRefPics.__array((int)1, (int)32), StdVideoEncodeH265LongTermRefPics.__array((int)1, (int)16), StdVideoEncodeH265LongTermRefPics.__member((int)2), StdVideoEncodeH265LongTermRefPics.__array((int)1, (int)48), StdVideoEncodeH265LongTermRefPics.__array((int)1, (int)48)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUM_LONG_TERM_SPS = layout.offsetof(0);
        NUM_LONG_TERM_PICS = layout.offsetof(1);
        LT_IDX_SPS = layout.offsetof(2);
        POC_LSB_LT = layout.offsetof(3);
        USED_BY_CURR_PIC_LT_FLAG = layout.offsetof(4);
        DELTA_POC_MSB_PRESENT_FLAG = layout.offsetof(5);
        DELTA_POC_MSB_CYCLE_LT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH265LongTermRefPics, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH265LongTermRefPics ELEMENT_FACTORY = StdVideoEncodeH265LongTermRefPics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected StdVideoEncodeH265LongTermRefPics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t")
        public byte num_long_term_sps() {
            return StdVideoEncodeH265LongTermRefPics.nnum_long_term_sps(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_long_term_pics() {
            return StdVideoEncodeH265LongTermRefPics.nnum_long_term_pics(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS]")
        public ByteBuffer lt_idx_sps() {
            return StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address());
        }

        @NativeType(value="uint8_t")
        public byte lt_idx_sps(int index) {
            return StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_PICS]")
        public ByteBuffer poc_lsb_lt() {
            return StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address());
        }

        @NativeType(value="uint8_t")
        public byte poc_lsb_lt(int index) {
            return StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), index);
        }

        @NativeType(value="uint16_t")
        public short used_by_curr_pic_lt_flag() {
            return StdVideoEncodeH265LongTermRefPics.nused_by_curr_pic_lt_flag(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]")
        public ByteBuffer delta_poc_msb_present_flag() {
            return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address());
        }

        @NativeType(value="uint8_t")
        public byte delta_poc_msb_present_flag(int index) {
            return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]")
        public ByteBuffer delta_poc_msb_cycle_lt() {
            return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address());
        }

        @NativeType(value="uint8_t")
        public byte delta_poc_msb_cycle_lt(int index) {
            return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), index);
        }

        public Buffer num_long_term_sps(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.nnum_long_term_sps(this.address(), value);
            return this;
        }

        public Buffer num_long_term_pics(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.nnum_long_term_pics(this.address(), value);
            return this;
        }

        public Buffer lt_idx_sps(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS]") ByteBuffer value) {
            StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), value);
            return this;
        }

        public Buffer lt_idx_sps(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), index, value);
            return this;
        }

        public Buffer poc_lsb_lt(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_PICS]") ByteBuffer value) {
            StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), value);
            return this;
        }

        public Buffer poc_lsb_lt(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), index, value);
            return this;
        }

        public Buffer used_by_curr_pic_lt_flag(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeH265LongTermRefPics.nused_by_curr_pic_lt_flag(this.address(), value);
            return this;
        }

        public Buffer delta_poc_msb_present_flag(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]") ByteBuffer value) {
            StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), value);
            return this;
        }

        public Buffer delta_poc_msb_present_flag(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), index, value);
            return this;
        }

        public Buffer delta_poc_msb_cycle_lt(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]") ByteBuffer value) {
            StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), value);
            return this;
        }

        public Buffer delta_poc_msb_cycle_lt(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), index, value);
            return this;
        }
    }
}

