/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkCommandBuffer;

public class EXTTransformFeedback {
    public static final int VK_EXT_TRANSFORM_FEEDBACK_SPEC_VERSION = 1;
    public static final String VK_EXT_TRANSFORM_FEEDBACK_EXTENSION_NAME = "VK_EXT_transform_feedback";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT = 1000028000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT = 1000028001;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT = 1000028002;
    public static final int VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT = 1000028004;
    public static final int VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT = 2048;
    public static final int VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT = 4096;
    public static final int VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT = 0x2000000;
    public static final int VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT = 0x4000000;
    public static final int VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT = 0x8000000;
    public static final int VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT = 0x1000000;

    protected EXTTransformFeedback() {
        throw new UnsupportedOperationException();
    }

    public static void nvkCmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, int firstBinding, int bindingCount, long pBuffers, long pOffsets, long pSizes) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBindTransformFeedbackBuffersEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPPV((long)commandBuffer.address(), (int)firstBinding, (int)bindingCount, (long)pBuffers, (long)pOffsets, (long)pSizes, (long)__functionAddress);
    }

    public static void vkCmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstBinding, @NativeType(value="VkBuffer const *") LongBuffer pBuffers, @NativeType(value="VkDeviceSize const *") LongBuffer pOffsets, @NativeType(value="VkDeviceSize const *") @Nullable LongBuffer pSizes) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOffsets, (int)pBuffers.remaining());
            Checks.checkSafe((Buffer)pSizes, (int)pBuffers.remaining());
        }
        EXTTransformFeedback.nvkCmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, pBuffers.remaining(), MemoryUtil.memAddress((LongBuffer)pBuffers), MemoryUtil.memAddress((LongBuffer)pOffsets), MemoryUtil.memAddressSafe((LongBuffer)pSizes));
    }

    public static void nvkCmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, int firstCounterBuffer, int counterBufferCount, long pCounterBuffers, long pCounterBufferOffsets) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBeginTransformFeedbackEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)commandBuffer.address(), (int)firstCounterBuffer, (int)counterBufferCount, (long)pCounterBuffers, (long)pCounterBufferOffsets, (long)__functionAddress);
    }

    public static void vkCmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstCounterBuffer, @NativeType(value="VkBuffer const *") @Nullable LongBuffer pCounterBuffers, @NativeType(value="VkDeviceSize const *") @Nullable LongBuffer pCounterBufferOffsets) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pCounterBufferOffsets, (int)Checks.remainingSafe((Buffer)pCounterBuffers));
        }
        EXTTransformFeedback.nvkCmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, Checks.remainingSafe((Buffer)pCounterBuffers), MemoryUtil.memAddressSafe((LongBuffer)pCounterBuffers), MemoryUtil.memAddressSafe((LongBuffer)pCounterBufferOffsets));
    }

    public static void nvkCmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, int firstCounterBuffer, int counterBufferCount, long pCounterBuffers, long pCounterBufferOffsets) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdEndTransformFeedbackEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)commandBuffer.address(), (int)firstCounterBuffer, (int)counterBufferCount, (long)pCounterBuffers, (long)pCounterBufferOffsets, (long)__functionAddress);
    }

    public static void vkCmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstCounterBuffer, @NativeType(value="VkBuffer const *") @Nullable LongBuffer pCounterBuffers, @NativeType(value="VkDeviceSize const *") @Nullable LongBuffer pCounterBufferOffsets) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pCounterBufferOffsets, (int)Checks.remainingSafe((Buffer)pCounterBuffers));
        }
        EXTTransformFeedback.nvkCmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, Checks.remainingSafe((Buffer)pCounterBuffers), MemoryUtil.memAddressSafe((LongBuffer)pCounterBuffers), MemoryUtil.memAddressSafe((LongBuffer)pCounterBufferOffsets));
    }

    public static void vkCmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkQueryPool") long queryPool, @NativeType(value="uint32_t") int query, @NativeType(value="VkQueryControlFlags") int flags, @NativeType(value="uint32_t") int index) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBeginQueryIndexedEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJV((long)commandBuffer.address(), (long)queryPool, (int)query, (int)flags, (int)index, (long)__functionAddress);
    }

    public static void vkCmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkQueryPool") long queryPool, @NativeType(value="uint32_t") int query, @NativeType(value="uint32_t") int index) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdEndQueryIndexedEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJV((long)commandBuffer.address(), (long)queryPool, (int)query, (int)index, (long)__functionAddress);
    }

    public static void vkCmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int instanceCount, @NativeType(value="uint32_t") int firstInstance, @NativeType(value="VkBuffer") long counterBuffer, @NativeType(value="VkDeviceSize") long counterBufferOffset, @NativeType(value="uint32_t") int counterOffset, @NativeType(value="uint32_t") int vertexStride) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDrawIndirectByteCountEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJJV((long)commandBuffer.address(), (int)instanceCount, (int)firstInstance, (long)counterBuffer, (long)counterBufferOffset, (int)counterOffset, (int)vertexStride, (long)__functionAddress);
    }

    public static void vkCmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstBinding, @NativeType(value="VkBuffer const *") long[] pBuffers, @NativeType(value="VkDeviceSize const *") long[] pOffsets, @NativeType(value="VkDeviceSize const *") long @Nullable [] pSizes) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBindTransformFeedbackBuffersEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pOffsets, (int)pBuffers.length);
            Checks.checkSafe((long[])pSizes, (int)pBuffers.length);
        }
        JNI.callPPPPV((long)commandBuffer.address(), (int)firstBinding, (int)pBuffers.length, (long[])pBuffers, (long[])pOffsets, (long[])pSizes, (long)__functionAddress);
    }

    public static void vkCmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstCounterBuffer, @NativeType(value="VkBuffer const *") long @Nullable [] pCounterBuffers, @NativeType(value="VkDeviceSize const *") long @Nullable [] pCounterBufferOffsets) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBeginTransformFeedbackEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((long[])pCounterBufferOffsets, (int)Checks.lengthSafe((long[])pCounterBuffers));
        }
        JNI.callPPPV((long)commandBuffer.address(), (int)firstCounterBuffer, (int)Checks.lengthSafe((long[])pCounterBuffers), (long[])pCounterBuffers, (long[])pCounterBufferOffsets, (long)__functionAddress);
    }

    public static void vkCmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstCounterBuffer, @NativeType(value="VkBuffer const *") long @Nullable [] pCounterBuffers, @NativeType(value="VkDeviceSize const *") long @Nullable [] pCounterBufferOffsets) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdEndTransformFeedbackEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((long[])pCounterBufferOffsets, (int)Checks.lengthSafe((long[])pCounterBuffers));
        }
        JNI.callPPPV((long)commandBuffer.address(), (int)firstCounterBuffer, (int)Checks.lengthSafe((long[])pCounterBuffers), (long[])pCounterBuffers, (long[])pCounterBufferOffsets, (long)__functionAddress);
    }
}

