/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAccelerationStructureBuildGeometryInfoKHR;
import org.lwjgl.vulkan.VkAccelerationStructureBuildSizesInfoKHR;
import org.lwjgl.vulkan.VkAccelerationStructureCreateInfoKHR;
import org.lwjgl.vulkan.VkAccelerationStructureDeviceAddressInfoKHR;
import org.lwjgl.vulkan.VkAccelerationStructureVersionInfoKHR;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkCopyAccelerationStructureInfoKHR;
import org.lwjgl.vulkan.VkCopyAccelerationStructureToMemoryInfoKHR;
import org.lwjgl.vulkan.VkCopyMemoryToAccelerationStructureInfoKHR;
import org.lwjgl.vulkan.VkDevice;

public class KHRAccelerationStructure {
    public static final int VK_KHR_ACCELERATION_STRUCTURE_SPEC_VERSION = 13;
    public static final String VK_KHR_ACCELERATION_STRUCTURE_EXTENSION_NAME = "VK_KHR_acceleration_structure";
    public static final int VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR = 1000150007;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR = 1000150000;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR = 1000150002;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR = 1000150003;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR = 1000150004;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR = 1000150005;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR = 1000150006;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR = 1000150009;
    public static final int VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR = 1000150010;
    public static final int VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR = 1000150011;
    public static final int VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR = 1000150012;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR = 1000150013;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR = 1000150014;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR = 1000150017;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR = 1000150020;
    public static final int VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR = 0x2000000;
    public static final int VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR = 1000150000;
    public static final int VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR = 0x200000;
    public static final int VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR = 0x400000;
    public static final int VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR = 1000150000;
    public static final int VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR = 1000150001;
    public static final int VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR = 1000150000;
    public static final int VK_INDEX_TYPE_NONE_KHR = 1000165000;
    public static final int VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR = 0x20000000;
    public static final int VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR = 524288;
    public static final int VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR = 0x100000;
    public static final int VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR = 2;
    public static final int VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR = 3;
    public static final long VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR = 0x20000000L;
    public static final int VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR_EXT = 1000150000;
    public static final int VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR = 0;
    public static final int VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR = 1;
    public static final int VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR = 2;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR = 1;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR = 2;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR = 4;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR = 8;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR = 16;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR = 0;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR = 1;
    public static final int VK_GEOMETRY_TYPE_TRIANGLES_KHR = 0;
    public static final int VK_GEOMETRY_TYPE_AABBS_KHR = 1;
    public static final int VK_GEOMETRY_TYPE_INSTANCES_KHR = 2;
    public static final int VK_GEOMETRY_OPAQUE_BIT_KHR = 1;
    public static final int VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR = 2;
    public static final int VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR = 0;
    public static final int VK_ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR = 1;
    public static final int VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR = 2;
    public static final int VK_GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR = 1;
    public static final int VK_GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR = 2;
    public static final int VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR = 4;
    public static final int VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR = 8;
    public static final int VK_GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_KHR = 2;
    public static final int VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR = 1;
    public static final int VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR = 0;
    public static final int VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR = 1;
    public static final int VK_ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR = 0;
    public static final int VK_ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR = 1;

    protected KHRAccelerationStructure() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreateAccelerationStructureKHR(VkDevice device, long pCreateInfo, long pAllocator, long pAccelerationStructure) {
        long __functionAddress = device.getCapabilities().vkCreateAccelerationStructureKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo, (long)pAllocator, (long)pAccelerationStructure, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateAccelerationStructureKHR(VkDevice device, @NativeType(value="VkAccelerationStructureCreateInfoKHR const *") VkAccelerationStructureCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkAccelerationStructureKHR *") LongBuffer pAccelerationStructure) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pAccelerationStructure, (int)1);
        }
        return KHRAccelerationStructure.nvkCreateAccelerationStructureKHR(device, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pAccelerationStructure));
    }

    public static void nvkDestroyAccelerationStructureKHR(VkDevice device, long accelerationStructure, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyAccelerationStructureKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJPV((long)device.address(), (long)accelerationStructure, (long)pAllocator, (long)__functionAddress);
    }

    public static void vkDestroyAccelerationStructureKHR(VkDevice device, @NativeType(value="VkAccelerationStructureKHR") long accelerationStructure, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator) {
        KHRAccelerationStructure.nvkDestroyAccelerationStructureKHR(device, accelerationStructure, MemoryUtil.memAddressSafe((Pointer)pAllocator));
    }

    public static void nvkCmdBuildAccelerationStructuresKHR(VkCommandBuffer commandBuffer, int infoCount, long pInfos, long ppBuildRangeInfos) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBuildAccelerationStructuresKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)commandBuffer.address(), (int)infoCount, (long)pInfos, (long)ppBuildRangeInfos, (long)__functionAddress);
    }

    public static void vkCmdBuildAccelerationStructuresKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkAccelerationStructureBuildGeometryInfoKHR const *") VkAccelerationStructureBuildGeometryInfoKHR.Buffer pInfos, @NativeType(value="VkAccelerationStructureBuildRangeInfoKHR const * const *") PointerBuffer ppBuildRangeInfos) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ppBuildRangeInfos, (int)pInfos.remaining());
        }
        KHRAccelerationStructure.nvkCmdBuildAccelerationStructuresKHR(commandBuffer, pInfos.remaining(), pInfos.address(), MemoryUtil.memAddress((CustomBuffer)ppBuildRangeInfos));
    }

    public static void nvkCmdBuildAccelerationStructuresIndirectKHR(VkCommandBuffer commandBuffer, int infoCount, long pInfos, long pIndirectDeviceAddresses, long pIndirectStrides, long ppMaxPrimitiveCounts) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBuildAccelerationStructuresIndirectKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPPPV((long)commandBuffer.address(), (int)infoCount, (long)pInfos, (long)pIndirectDeviceAddresses, (long)pIndirectStrides, (long)ppMaxPrimitiveCounts, (long)__functionAddress);
    }

    public static void vkCmdBuildAccelerationStructuresIndirectKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkAccelerationStructureBuildGeometryInfoKHR const *") VkAccelerationStructureBuildGeometryInfoKHR.Buffer pInfos, @NativeType(value="VkDeviceAddress const *") LongBuffer pIndirectDeviceAddresses, @NativeType(value="uint32_t const *") IntBuffer pIndirectStrides, @NativeType(value="uint32_t const * const *") PointerBuffer ppMaxPrimitiveCounts) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pIndirectDeviceAddresses, (int)pInfos.remaining());
            Checks.check((Buffer)pIndirectStrides, (int)pInfos.remaining());
            Checks.check((CustomBuffer)ppMaxPrimitiveCounts, (int)pInfos.remaining());
        }
        KHRAccelerationStructure.nvkCmdBuildAccelerationStructuresIndirectKHR(commandBuffer, pInfos.remaining(), pInfos.address(), MemoryUtil.memAddress((LongBuffer)pIndirectDeviceAddresses), MemoryUtil.memAddress((IntBuffer)pIndirectStrides), MemoryUtil.memAddress((CustomBuffer)ppMaxPrimitiveCounts));
    }

    public static int nvkBuildAccelerationStructuresKHR(VkDevice device, long deferredOperation, int infoCount, long pInfos, long ppBuildRangeInfos) {
        long __functionAddress = device.getCapabilities().vkBuildAccelerationStructuresKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPI((long)device.address(), (long)deferredOperation, (int)infoCount, (long)pInfos, (long)ppBuildRangeInfos, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkBuildAccelerationStructuresKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long deferredOperation, @NativeType(value="VkAccelerationStructureBuildGeometryInfoKHR const *") VkAccelerationStructureBuildGeometryInfoKHR.Buffer pInfos, @NativeType(value="VkAccelerationStructureBuildRangeInfoKHR const * const *") PointerBuffer ppBuildRangeInfos) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ppBuildRangeInfos, (int)pInfos.remaining());
        }
        return KHRAccelerationStructure.nvkBuildAccelerationStructuresKHR(device, deferredOperation, pInfos.remaining(), pInfos.address(), MemoryUtil.memAddress((CustomBuffer)ppBuildRangeInfos));
    }

    public static int nvkCopyAccelerationStructureKHR(VkDevice device, long deferredOperation, long pInfo) {
        long __functionAddress = device.getCapabilities().vkCopyAccelerationStructureKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)device.address(), (long)deferredOperation, (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCopyAccelerationStructureKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long deferredOperation, @NativeType(value="VkCopyAccelerationStructureInfoKHR const *") VkCopyAccelerationStructureInfoKHR pInfo) {
        return KHRAccelerationStructure.nvkCopyAccelerationStructureKHR(device, deferredOperation, pInfo.address());
    }

    public static int nvkCopyAccelerationStructureToMemoryKHR(VkDevice device, long deferredOperation, long pInfo) {
        long __functionAddress = device.getCapabilities().vkCopyAccelerationStructureToMemoryKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)device.address(), (long)deferredOperation, (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCopyAccelerationStructureToMemoryKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long deferredOperation, @NativeType(value="VkCopyAccelerationStructureToMemoryInfoKHR const *") VkCopyAccelerationStructureToMemoryInfoKHR pInfo) {
        return KHRAccelerationStructure.nvkCopyAccelerationStructureToMemoryKHR(device, deferredOperation, pInfo.address());
    }

    public static int nvkCopyMemoryToAccelerationStructureKHR(VkDevice device, long deferredOperation, long pInfo) {
        long __functionAddress = device.getCapabilities().vkCopyMemoryToAccelerationStructureKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)device.address(), (long)deferredOperation, (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCopyMemoryToAccelerationStructureKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long deferredOperation, @NativeType(value="VkCopyMemoryToAccelerationStructureInfoKHR const *") VkCopyMemoryToAccelerationStructureInfoKHR pInfo) {
        return KHRAccelerationStructure.nvkCopyMemoryToAccelerationStructureKHR(device, deferredOperation, pInfo.address());
    }

    public static int nvkWriteAccelerationStructuresPropertiesKHR(VkDevice device, int accelerationStructureCount, long pAccelerationStructures, int queryType, long dataSize, long pData, long stride) {
        long __functionAddress = device.getCapabilities().vkWriteAccelerationStructuresPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPPI((long)device.address(), (int)accelerationStructureCount, (long)pAccelerationStructures, (int)queryType, (long)dataSize, (long)pData, (long)stride, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkWriteAccelerationStructuresPropertiesKHR(VkDevice device, @NativeType(value="VkAccelerationStructureKHR const *") LongBuffer pAccelerationStructures, @NativeType(value="VkQueryType") int queryType, @NativeType(value="void *") ByteBuffer pData, @NativeType(value="size_t") long stride) {
        return KHRAccelerationStructure.nvkWriteAccelerationStructuresPropertiesKHR(device, pAccelerationStructures.remaining(), MemoryUtil.memAddress((LongBuffer)pAccelerationStructures), queryType, pData.remaining(), MemoryUtil.memAddress((ByteBuffer)pData), stride);
    }

    public static void nvkCmdCopyAccelerationStructureKHR(VkCommandBuffer commandBuffer, long pInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdCopyAccelerationStructureKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)commandBuffer.address(), (long)pInfo, (long)__functionAddress);
    }

    public static void vkCmdCopyAccelerationStructureKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkCopyAccelerationStructureInfoKHR const *") VkCopyAccelerationStructureInfoKHR pInfo) {
        KHRAccelerationStructure.nvkCmdCopyAccelerationStructureKHR(commandBuffer, pInfo.address());
    }

    public static void nvkCmdCopyAccelerationStructureToMemoryKHR(VkCommandBuffer commandBuffer, long pInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdCopyAccelerationStructureToMemoryKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)commandBuffer.address(), (long)pInfo, (long)__functionAddress);
    }

    public static void vkCmdCopyAccelerationStructureToMemoryKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkCopyAccelerationStructureToMemoryInfoKHR const *") VkCopyAccelerationStructureToMemoryInfoKHR pInfo) {
        KHRAccelerationStructure.nvkCmdCopyAccelerationStructureToMemoryKHR(commandBuffer, pInfo.address());
    }

    public static void nvkCmdCopyMemoryToAccelerationStructureKHR(VkCommandBuffer commandBuffer, long pInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdCopyMemoryToAccelerationStructureKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)commandBuffer.address(), (long)pInfo, (long)__functionAddress);
    }

    public static void vkCmdCopyMemoryToAccelerationStructureKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkCopyMemoryToAccelerationStructureInfoKHR const *") VkCopyMemoryToAccelerationStructureInfoKHR pInfo) {
        KHRAccelerationStructure.nvkCmdCopyMemoryToAccelerationStructureKHR(commandBuffer, pInfo.address());
    }

    public static long nvkGetAccelerationStructureDeviceAddressKHR(VkDevice device, long pInfo) {
        long __functionAddress = device.getCapabilities().vkGetAccelerationStructureDeviceAddressKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPJ((long)device.address(), (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="VkDeviceAddress")
    public static long vkGetAccelerationStructureDeviceAddressKHR(VkDevice device, @NativeType(value="VkAccelerationStructureDeviceAddressInfoKHR const *") VkAccelerationStructureDeviceAddressInfoKHR pInfo) {
        return KHRAccelerationStructure.nvkGetAccelerationStructureDeviceAddressKHR(device, pInfo.address());
    }

    public static void nvkCmdWriteAccelerationStructuresPropertiesKHR(VkCommandBuffer commandBuffer, int accelerationStructureCount, long pAccelerationStructures, int queryType, long queryPool, int firstQuery) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdWriteAccelerationStructuresPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPJV((long)commandBuffer.address(), (int)accelerationStructureCount, (long)pAccelerationStructures, (int)queryType, (long)queryPool, (int)firstQuery, (long)__functionAddress);
    }

    public static void vkCmdWriteAccelerationStructuresPropertiesKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkAccelerationStructureKHR const *") LongBuffer pAccelerationStructures, @NativeType(value="VkQueryType") int queryType, @NativeType(value="VkQueryPool") long queryPool, @NativeType(value="uint32_t") int firstQuery) {
        KHRAccelerationStructure.nvkCmdWriteAccelerationStructuresPropertiesKHR(commandBuffer, pAccelerationStructures.remaining(), MemoryUtil.memAddress((LongBuffer)pAccelerationStructures), queryType, queryPool, firstQuery);
    }

    public static void nvkGetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, long pVersionInfo, long pCompatibility) {
        long __functionAddress = device.getCapabilities().vkGetDeviceAccelerationStructureCompatibilityKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkAccelerationStructureVersionInfoKHR.validate(pVersionInfo);
        }
        JNI.callPPPV((long)device.address(), (long)pVersionInfo, (long)pCompatibility, (long)__functionAddress);
    }

    public static void vkGetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, @NativeType(value="VkAccelerationStructureVersionInfoKHR const *") VkAccelerationStructureVersionInfoKHR pVersionInfo, @NativeType(value="VkAccelerationStructureCompatibilityKHR *") IntBuffer pCompatibility) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pCompatibility, (int)1);
        }
        KHRAccelerationStructure.nvkGetDeviceAccelerationStructureCompatibilityKHR(device, pVersionInfo.address(), MemoryUtil.memAddress((IntBuffer)pCompatibility));
    }

    public static void nvkGetAccelerationStructureBuildSizesKHR(VkDevice device, int buildType, long pBuildInfo, long pMaxPrimitiveCounts, long pSizeInfo) {
        long __functionAddress = device.getCapabilities().vkGetAccelerationStructureBuildSizesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPPV((long)device.address(), (int)buildType, (long)pBuildInfo, (long)pMaxPrimitiveCounts, (long)pSizeInfo, (long)__functionAddress);
    }

    public static void vkGetAccelerationStructureBuildSizesKHR(VkDevice device, @NativeType(value="VkAccelerationStructureBuildTypeKHR") int buildType, @NativeType(value="VkAccelerationStructureBuildGeometryInfoKHR const *") VkAccelerationStructureBuildGeometryInfoKHR pBuildInfo, @NativeType(value="uint32_t const *") @Nullable IntBuffer pMaxPrimitiveCounts, @NativeType(value="VkAccelerationStructureBuildSizesInfoKHR *") VkAccelerationStructureBuildSizesInfoKHR pSizeInfo) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pMaxPrimitiveCounts, (int)pBuildInfo.geometryCount());
        }
        KHRAccelerationStructure.nvkGetAccelerationStructureBuildSizesKHR(device, buildType, pBuildInfo.address(), MemoryUtil.memAddressSafe((IntBuffer)pMaxPrimitiveCounts), pSizeInfo.address());
    }

    @NativeType(value="VkResult")
    public static int vkCreateAccelerationStructureKHR(VkDevice device, @NativeType(value="VkAccelerationStructureCreateInfoKHR const *") VkAccelerationStructureCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkAccelerationStructureKHR *") long[] pAccelerationStructure) {
        long __functionAddress = device.getCapabilities().vkCreateAccelerationStructureKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pAccelerationStructure, (int)1);
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pAccelerationStructure, (long)__functionAddress);
    }

    public static void vkCmdBuildAccelerationStructuresIndirectKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkAccelerationStructureBuildGeometryInfoKHR const *") VkAccelerationStructureBuildGeometryInfoKHR.Buffer pInfos, @NativeType(value="VkDeviceAddress const *") long[] pIndirectDeviceAddresses, @NativeType(value="uint32_t const *") int[] pIndirectStrides, @NativeType(value="uint32_t const * const *") PointerBuffer ppMaxPrimitiveCounts) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBuildAccelerationStructuresIndirectKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pIndirectDeviceAddresses, (int)pInfos.remaining());
            Checks.check((int[])pIndirectStrides, (int)pInfos.remaining());
            Checks.check((CustomBuffer)ppMaxPrimitiveCounts, (int)pInfos.remaining());
        }
        JNI.callPPPPPV((long)commandBuffer.address(), (int)pInfos.remaining(), (long)pInfos.address(), (long[])pIndirectDeviceAddresses, (int[])pIndirectStrides, (long)MemoryUtil.memAddress((CustomBuffer)ppMaxPrimitiveCounts), (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkWriteAccelerationStructuresPropertiesKHR(VkDevice device, @NativeType(value="VkAccelerationStructureKHR const *") long[] pAccelerationStructures, @NativeType(value="VkQueryType") int queryType, @NativeType(value="void *") ByteBuffer pData, @NativeType(value="size_t") long stride) {
        long __functionAddress = device.getCapabilities().vkWriteAccelerationStructuresPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPPI((long)device.address(), (int)pAccelerationStructures.length, (long[])pAccelerationStructures, (int)queryType, (long)pData.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)pData), (long)stride, (long)__functionAddress);
    }

    public static void vkCmdWriteAccelerationStructuresPropertiesKHR(VkCommandBuffer commandBuffer, @NativeType(value="VkAccelerationStructureKHR const *") long[] pAccelerationStructures, @NativeType(value="VkQueryType") int queryType, @NativeType(value="VkQueryPool") long queryPool, @NativeType(value="uint32_t") int firstQuery) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdWriteAccelerationStructuresPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPJV((long)commandBuffer.address(), (int)pAccelerationStructures.length, (long[])pAccelerationStructures, (int)queryType, (long)queryPool, (int)firstQuery, (long)__functionAddress);
    }

    public static void vkGetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, @NativeType(value="VkAccelerationStructureVersionInfoKHR const *") VkAccelerationStructureVersionInfoKHR pVersionInfo, @NativeType(value="VkAccelerationStructureCompatibilityKHR *") int[] pCompatibility) {
        long __functionAddress = device.getCapabilities().vkGetDeviceAccelerationStructureCompatibilityKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pCompatibility, (int)1);
            VkAccelerationStructureVersionInfoKHR.validate(pVersionInfo.address());
        }
        JNI.callPPPV((long)device.address(), (long)pVersionInfo.address(), (int[])pCompatibility, (long)__functionAddress);
    }

    public static void vkGetAccelerationStructureBuildSizesKHR(VkDevice device, @NativeType(value="VkAccelerationStructureBuildTypeKHR") int buildType, @NativeType(value="VkAccelerationStructureBuildGeometryInfoKHR const *") VkAccelerationStructureBuildGeometryInfoKHR pBuildInfo, @NativeType(value="uint32_t const *") int @Nullable [] pMaxPrimitiveCounts, @NativeType(value="VkAccelerationStructureBuildSizesInfoKHR *") VkAccelerationStructureBuildSizesInfoKHR pSizeInfo) {
        long __functionAddress = device.getCapabilities().vkGetAccelerationStructureBuildSizesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])pMaxPrimitiveCounts, (int)pBuildInfo.geometryCount());
        }
        JNI.callPPPPV((long)device.address(), (int)buildType, (long)pBuildInfo.address(), (int[])pMaxPrimitiveCounts, (long)pSizeInfo.address(), (long)__functionAddress);
    }
}

