/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkInstance;

public class KHRDeviceGroupCreation {
    public static final int VK_KHR_DEVICE_GROUP_CREATION_SPEC_VERSION = 1;
    public static final String VK_KHR_DEVICE_GROUP_CREATION_EXTENSION_NAME = "VK_KHR_device_group_creation";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR = 1000070000;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR = 1000070001;
    public static final int VK_MAX_DEVICE_GROUP_SIZE_KHR = 32;
    public static final int VK_MEMORY_HEAP_MULTI_INSTANCE_BIT_KHR = 2;

    protected KHRDeviceGroupCreation() {
        throw new UnsupportedOperationException();
    }

    public static int nvkEnumeratePhysicalDeviceGroupsKHR(VkInstance instance, long pPhysicalDeviceGroupCount, long pPhysicalDeviceGroupProperties) {
        long __functionAddress = instance.getCapabilities().vkEnumeratePhysicalDeviceGroupsKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)instance.address(), (long)pPhysicalDeviceGroupCount, (long)pPhysicalDeviceGroupProperties, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkEnumeratePhysicalDeviceGroupsKHR(VkInstance instance, @NativeType(value="uint32_t *") IntBuffer pPhysicalDeviceGroupCount, @NativeType(value="VkPhysicalDeviceGroupProperties *")  @Nullable VkPhysicalDeviceGroupProperties.Buffer pPhysicalDeviceGroupProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPhysicalDeviceGroupCount, (int)1);
            Checks.checkSafe((CustomBuffer)pPhysicalDeviceGroupProperties, (int)pPhysicalDeviceGroupCount.get(pPhysicalDeviceGroupCount.position()));
        }
        return KHRDeviceGroupCreation.nvkEnumeratePhysicalDeviceGroupsKHR(instance, MemoryUtil.memAddress((IntBuffer)pPhysicalDeviceGroupCount), MemoryUtil.memAddressSafe((Pointer)pPhysicalDeviceGroupProperties));
    }

    @NativeType(value="VkResult")
    public static int vkEnumeratePhysicalDeviceGroupsKHR(VkInstance instance, @NativeType(value="uint32_t *") int[] pPhysicalDeviceGroupCount, @NativeType(value="VkPhysicalDeviceGroupProperties *")  @Nullable VkPhysicalDeviceGroupProperties.Buffer pPhysicalDeviceGroupProperties) {
        long __functionAddress = instance.getCapabilities().vkEnumeratePhysicalDeviceGroupsKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pPhysicalDeviceGroupCount, (int)1);
            Checks.checkSafe((CustomBuffer)pPhysicalDeviceGroupProperties, (int)pPhysicalDeviceGroupCount[0]);
        }
        return JNI.callPPPI((long)instance.address(), (int[])pPhysicalDeviceGroupCount, (long)MemoryUtil.memAddressSafe((Pointer)pPhysicalDeviceGroupProperties), (long)__functionAddress);
    }
}

