/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDisplayModeCreateInfoKHR;
import org.lwjgl.vulkan.VkDisplayPlaneCapabilitiesKHR;
import org.lwjgl.vulkan.VkDisplaySurfaceCreateInfoKHR;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class KHRDisplay {
    public static final int VK_KHR_DISPLAY_SPEC_VERSION = 23;
    public static final String VK_KHR_DISPLAY_EXTENSION_NAME = "VK_KHR_display";
    public static final int VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR = 1000002000;
    public static final int VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR = 1000002001;
    public static final int VK_OBJECT_TYPE_DISPLAY_KHR = 1000002000;
    public static final int VK_OBJECT_TYPE_DISPLAY_MODE_KHR = 1000002001;
    public static final int VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR = 1;
    public static final int VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR = 2;
    public static final int VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR = 4;
    public static final int VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR = 8;

    protected KHRDisplay() {
        throw new UnsupportedOperationException();
    }

    public static int nvkGetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)physicalDevice.address(), (long)pPropertyCount, (long)pProperties, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") IntBuffer pPropertyCount, @NativeType(value="VkDisplayPropertiesKHR *")  @Nullable VkDisplayPropertiesKHR.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPropertyCount, (int)1);
            Checks.checkSafe((CustomBuffer)pProperties, (int)pPropertyCount.get(pPropertyCount.position()));
        }
        return KHRDisplay.nvkGetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, MemoryUtil.memAddress((IntBuffer)pPropertyCount), MemoryUtil.memAddressSafe((Pointer)pProperties));
    }

    public static int nvkGetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayPlanePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)physicalDevice.address(), (long)pPropertyCount, (long)pProperties, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") IntBuffer pPropertyCount, @NativeType(value="VkDisplayPlanePropertiesKHR *")  @Nullable VkDisplayPlanePropertiesKHR.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPropertyCount, (int)1);
            Checks.checkSafe((CustomBuffer)pProperties, (int)pPropertyCount.get(pPropertyCount.position()));
        }
        return KHRDisplay.nvkGetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, MemoryUtil.memAddress((IntBuffer)pPropertyCount), MemoryUtil.memAddressSafe((Pointer)pProperties));
    }

    public static int nvkGetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, int planeIndex, long pDisplayCount, long pDisplays) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayPlaneSupportedDisplaysKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)physicalDevice.address(), (int)planeIndex, (long)pDisplayCount, (long)pDisplays, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int planeIndex, @NativeType(value="uint32_t *") IntBuffer pDisplayCount, @NativeType(value="VkDisplayKHR *") @Nullable LongBuffer pDisplays) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pDisplayCount, (int)1);
            Checks.checkSafe((Buffer)pDisplays, (int)pDisplayCount.get(pDisplayCount.position()));
        }
        return KHRDisplay.nvkGetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, MemoryUtil.memAddress((IntBuffer)pDisplayCount), MemoryUtil.memAddressSafe((LongBuffer)pDisplays));
    }

    public static int nvkGetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, long display, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayModePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPI((long)physicalDevice.address(), (long)display, (long)pPropertyCount, (long)pProperties, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkDisplayKHR") long display, @NativeType(value="uint32_t *") IntBuffer pPropertyCount, @NativeType(value="VkDisplayModePropertiesKHR *")  @Nullable VkDisplayModePropertiesKHR.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPropertyCount, (int)1);
            Checks.checkSafe((CustomBuffer)pProperties, (int)pPropertyCount.get(pPropertyCount.position()));
        }
        return KHRDisplay.nvkGetDisplayModePropertiesKHR(physicalDevice, display, MemoryUtil.memAddress((IntBuffer)pPropertyCount), MemoryUtil.memAddressSafe((Pointer)pProperties));
    }

    public static int nvkCreateDisplayModeKHR(VkPhysicalDevice physicalDevice, long display, long pCreateInfo, long pAllocator, long pMode) {
        long __functionAddress = physicalDevice.getCapabilities().vkCreateDisplayModeKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPPI((long)physicalDevice.address(), (long)display, (long)pCreateInfo, (long)pAllocator, (long)pMode, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDisplayModeKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkDisplayKHR") long display, @NativeType(value="VkDisplayModeCreateInfoKHR const *") VkDisplayModeCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkDisplayModeKHR *") LongBuffer pMode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pMode, (int)1);
        }
        return KHRDisplay.nvkCreateDisplayModeKHR(physicalDevice, display, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pMode));
    }

    public static int nvkGetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, long mode, int planeIndex, long pCapabilities) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayPlaneCapabilitiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)physicalDevice.address(), (long)mode, (int)planeIndex, (long)pCapabilities, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkDisplayModeKHR") long mode, @NativeType(value="uint32_t") int planeIndex, @NativeType(value="VkDisplayPlaneCapabilitiesKHR *") VkDisplayPlaneCapabilitiesKHR pCapabilities) {
        return KHRDisplay.nvkGetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities.address());
    }

    public static int nvkCreateDisplayPlaneSurfaceKHR(VkInstance instance, long pCreateInfo, long pAllocator, long pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateDisplayPlaneSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPI((long)instance.address(), (long)pCreateInfo, (long)pAllocator, (long)pSurface, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDisplayPlaneSurfaceKHR(VkInstance instance, @NativeType(value="VkDisplaySurfaceCreateInfoKHR const *") VkDisplaySurfaceCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") LongBuffer pSurface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurface, (int)1);
        }
        return KHRDisplay.nvkCreateDisplayPlaneSurfaceKHR(instance, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pSurface));
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") int[] pPropertyCount, @NativeType(value="VkDisplayPropertiesKHR *")  @Nullable VkDisplayPropertiesKHR.Buffer pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pPropertyCount, (int)1);
            Checks.checkSafe((CustomBuffer)pProperties, (int)pPropertyCount[0]);
        }
        return JNI.callPPPI((long)physicalDevice.address(), (int[])pPropertyCount, (long)MemoryUtil.memAddressSafe((Pointer)pProperties), (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") int[] pPropertyCount, @NativeType(value="VkDisplayPlanePropertiesKHR *")  @Nullable VkDisplayPlanePropertiesKHR.Buffer pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayPlanePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pPropertyCount, (int)1);
            Checks.checkSafe((CustomBuffer)pProperties, (int)pPropertyCount[0]);
        }
        return JNI.callPPPI((long)physicalDevice.address(), (int[])pPropertyCount, (long)MemoryUtil.memAddressSafe((Pointer)pProperties), (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int planeIndex, @NativeType(value="uint32_t *") int[] pDisplayCount, @NativeType(value="VkDisplayKHR *") long @Nullable [] pDisplays) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayPlaneSupportedDisplaysKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pDisplayCount, (int)1);
            Checks.checkSafe((long[])pDisplays, (int)pDisplayCount[0]);
        }
        return JNI.callPPPI((long)physicalDevice.address(), (int)planeIndex, (int[])pDisplayCount, (long[])pDisplays, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkDisplayKHR") long display, @NativeType(value="uint32_t *") int[] pPropertyCount, @NativeType(value="VkDisplayModePropertiesKHR *")  @Nullable VkDisplayModePropertiesKHR.Buffer pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayModePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pPropertyCount, (int)1);
            Checks.checkSafe((CustomBuffer)pProperties, (int)pPropertyCount[0]);
        }
        return JNI.callPJPPI((long)physicalDevice.address(), (long)display, (int[])pPropertyCount, (long)MemoryUtil.memAddressSafe((Pointer)pProperties), (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDisplayModeKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkDisplayKHR") long display, @NativeType(value="VkDisplayModeCreateInfoKHR const *") VkDisplayModeCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkDisplayModeKHR *") long[] pMode) {
        long __functionAddress = physicalDevice.getCapabilities().vkCreateDisplayModeKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pMode, (int)1);
        }
        return JNI.callPJPPPI((long)physicalDevice.address(), (long)display, (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pMode, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDisplayPlaneSurfaceKHR(VkInstance instance, @NativeType(value="VkDisplaySurfaceCreateInfoKHR const *") VkDisplaySurfaceCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") long[] pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateDisplayPlaneSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pSurface, (int)1);
        }
        return JNI.callPPPPI((long)instance.address(), (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pSurface, (long)__functionAddress);
    }
}

