/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPipelineBinaryCreateInfoKHR;
import org.lwjgl.vulkan.VkPipelineBinaryDataInfoKHR;
import org.lwjgl.vulkan.VkPipelineBinaryHandlesInfoKHR;
import org.lwjgl.vulkan.VkPipelineBinaryKeyKHR;
import org.lwjgl.vulkan.VkPipelineCreateInfoKHR;
import org.lwjgl.vulkan.VkReleaseCapturedPipelineDataInfoKHR;

public class KHRPipelineBinary {
    public static final int VK_KHR_PIPELINE_BINARY_SPEC_VERSION = 1;
    public static final String VK_KHR_PIPELINE_BINARY_EXTENSION_NAME = "VK_KHR_pipeline_binary";
    public static final int VK_MAX_PIPELINE_BINARY_KEY_SIZE_KHR = 32;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_FEATURES_KHR = 1000483000;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_BINARY_CREATE_INFO_KHR = 1000483001;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_BINARY_INFO_KHR = 1000483002;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_BINARY_KEY_KHR = 1000483003;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_PROPERTIES_KHR = 1000483004;
    public static final int VK_STRUCTURE_TYPE_RELEASE_CAPTURED_PIPELINE_DATA_INFO_KHR = 1000483005;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_BINARY_DATA_INFO_KHR = 1000483006;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_CREATE_INFO_KHR = 1000483007;
    public static final int VK_STRUCTURE_TYPE_DEVICE_PIPELINE_BINARY_INTERNAL_CACHE_CONTROL_KHR = 1000483008;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_BINARY_HANDLES_INFO_KHR = 1000483009;
    public static final int VK_OBJECT_TYPE_PIPELINE_BINARY_KHR = 1000483000;
    public static final int VK_PIPELINE_BINARY_MISSING_KHR = 1000483000;
    public static final int VK_ERROR_NOT_ENOUGH_SPACE_KHR = -1000483000;
    public static final long VK_PIPELINE_CREATE_2_CAPTURE_DATA_BIT_KHR = 0x80000000L;

    protected KHRPipelineBinary() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreatePipelineBinariesKHR(VkDevice device, long pCreateInfo, long pAllocator, long pBinaries) {
        long __functionAddress = device.getCapabilities().vkCreatePipelineBinariesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkPipelineBinaryCreateInfoKHR.validate(pCreateInfo);
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo, (long)pAllocator, (long)pBinaries, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreatePipelineBinariesKHR(VkDevice device, @NativeType(value="VkPipelineBinaryCreateInfoKHR const *") VkPipelineBinaryCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkPipelineBinaryHandlesInfoKHR *") VkPipelineBinaryHandlesInfoKHR pBinaries) {
        return KHRPipelineBinary.nvkCreatePipelineBinariesKHR(device, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), pBinaries.address());
    }

    public static void nvkDestroyPipelineBinaryKHR(VkDevice device, long pipelineBinary, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyPipelineBinaryKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJPV((long)device.address(), (long)pipelineBinary, (long)pAllocator, (long)__functionAddress);
    }

    public static void vkDestroyPipelineBinaryKHR(VkDevice device, @NativeType(value="VkPipelineBinaryKHR") long pipelineBinary, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator) {
        KHRPipelineBinary.nvkDestroyPipelineBinaryKHR(device, pipelineBinary, MemoryUtil.memAddressSafe((Pointer)pAllocator));
    }

    public static int nvkGetPipelineKeyKHR(VkDevice device, long pPipelineCreateInfo, long pPipelineKey) {
        long __functionAddress = device.getCapabilities().vkGetPipelineKeyKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)device.address(), (long)pPipelineCreateInfo, (long)pPipelineKey, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPipelineKeyKHR(VkDevice device, @NativeType(value="VkPipelineCreateInfoKHR const *") @Nullable VkPipelineCreateInfoKHR pPipelineCreateInfo, @NativeType(value="VkPipelineBinaryKeyKHR *") VkPipelineBinaryKeyKHR pPipelineKey) {
        return KHRPipelineBinary.nvkGetPipelineKeyKHR(device, MemoryUtil.memAddressSafe((Pointer)pPipelineCreateInfo), pPipelineKey.address());
    }

    public static int nvkGetPipelineBinaryDataKHR(VkDevice device, long pInfo, long pPipelineBinaryKey, long pPipelineBinaryDataSize, long pPipelineBinaryData) {
        long __functionAddress = device.getCapabilities().vkGetPipelineBinaryDataKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPPI((long)device.address(), (long)pInfo, (long)pPipelineBinaryKey, (long)pPipelineBinaryDataSize, (long)pPipelineBinaryData, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPipelineBinaryDataKHR(VkDevice device, @NativeType(value="VkPipelineBinaryDataInfoKHR const *") VkPipelineBinaryDataInfoKHR pInfo, @NativeType(value="VkPipelineBinaryKeyKHR *") VkPipelineBinaryKeyKHR pPipelineBinaryKey, @NativeType(value="size_t *") PointerBuffer pPipelineBinaryDataSize, @NativeType(value="void *") @Nullable ByteBuffer pPipelineBinaryData) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pPipelineBinaryDataSize, (int)1);
            Checks.checkSafe((Buffer)pPipelineBinaryData, (long)pPipelineBinaryDataSize.get(pPipelineBinaryDataSize.position()));
        }
        return KHRPipelineBinary.nvkGetPipelineBinaryDataKHR(device, pInfo.address(), pPipelineBinaryKey.address(), MemoryUtil.memAddress((CustomBuffer)pPipelineBinaryDataSize), MemoryUtil.memAddressSafe((ByteBuffer)pPipelineBinaryData));
    }

    public static int nvkReleaseCapturedPipelineDataKHR(VkDevice device, long pInfo, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkReleaseCapturedPipelineDataKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)device.address(), (long)pInfo, (long)pAllocator, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkReleaseCapturedPipelineDataKHR(VkDevice device, @NativeType(value="VkReleaseCapturedPipelineDataInfoKHR const *") VkReleaseCapturedPipelineDataInfoKHR pInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator) {
        return KHRPipelineBinary.nvkReleaseCapturedPipelineDataKHR(device, pInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator));
    }
}

