/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkWin32SurfaceCreateInfoKHR;

public class KHRWin32Surface {
    public static final int VK_KHR_WIN32_SURFACE_SPEC_VERSION = 6;
    public static final String VK_KHR_WIN32_SURFACE_EXTENSION_NAME = "VK_KHR_win32_surface";
    public static final int VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR = 1000009000;

    protected KHRWin32Surface() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreateWin32SurfaceKHR(VkInstance instance, long pCreateInfo, long pAllocator, long pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateWin32SurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkWin32SurfaceCreateInfoKHR.validate(pCreateInfo);
        }
        return JNI.callPPPPI((long)instance.address(), (long)pCreateInfo, (long)pAllocator, (long)pSurface, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateWin32SurfaceKHR(VkInstance instance, @NativeType(value="VkWin32SurfaceCreateInfoKHR const *") VkWin32SurfaceCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") LongBuffer pSurface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurface, (int)1);
        }
        return KHRWin32Surface.nvkCreateWin32SurfaceKHR(instance, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pSurface));
    }

    @NativeType(value="VkBool32")
    public static boolean vkGetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int queueFamilyIndex) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceWin32PresentationSupportKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)physicalDevice.address(), (int)queueFamilyIndex, (long)__functionAddress) != 0;
    }

    @NativeType(value="VkResult")
    public static int vkCreateWin32SurfaceKHR(VkInstance instance, @NativeType(value="VkWin32SurfaceCreateInfoKHR const *") VkWin32SurfaceCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") long[] pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateWin32SurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pSurface, (int)1);
            VkWin32SurfaceCreateInfoKHR.validate(pCreateInfo.address());
        }
        return JNI.callPPPPI((long)instance.address(), (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pSurface, (long)__functionAddress);
    }
}

