/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureInfoNV;
import org.lwjgl.vulkan.VkOpaqueCaptureDescriptorDataCreateInfoEXT;

public class VkAccelerationStructureCreateInfoNV
extends Struct<VkAccelerationStructureCreateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int COMPACTEDSIZE;
    public static final int INFO;

    protected VkAccelerationStructureCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkAccelerationStructureCreateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureCreateInfoNV(address, container);
    }

    public VkAccelerationStructureCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAccelerationStructureCreateInfoNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAccelerationStructureCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAccelerationStructureCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long compactedSize() {
        return VkAccelerationStructureCreateInfoNV.ncompactedSize(this.address());
    }

    public VkAccelerationStructureInfoNV info() {
        return VkAccelerationStructureCreateInfoNV.ninfo(this.address());
    }

    public VkAccelerationStructureCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkAccelerationStructureCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoNV sType$Default() {
        return this.sType(1000165001);
    }

    public VkAccelerationStructureCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkAccelerationStructureCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoNV pNext(VkOpaqueCaptureDescriptorDataCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkAccelerationStructureCreateInfoNV compactedSize(@NativeType(value="VkDeviceSize") long value) {
        VkAccelerationStructureCreateInfoNV.ncompactedSize(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoNV info(VkAccelerationStructureInfoNV value) {
        VkAccelerationStructureCreateInfoNV.ninfo(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoNV info(Consumer<VkAccelerationStructureInfoNV> consumer) {
        consumer.accept(this.info());
        return this;
    }

    public VkAccelerationStructureCreateInfoNV set(int sType, long pNext, long compactedSize, VkAccelerationStructureInfoNV info) {
        this.sType(sType);
        this.pNext(pNext);
        this.compactedSize(compactedSize);
        this.info(info);
        return this;
    }

    public VkAccelerationStructureCreateInfoNV set(VkAccelerationStructureCreateInfoNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAccelerationStructureCreateInfoNV malloc() {
        return new VkAccelerationStructureCreateInfoNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkAccelerationStructureCreateInfoNV calloc() {
        return new VkAccelerationStructureCreateInfoNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkAccelerationStructureCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkAccelerationStructureCreateInfoNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkAccelerationStructureCreateInfoNV create(long address) {
        return new VkAccelerationStructureCreateInfoNV(address, null);
    }

    public static @Nullable VkAccelerationStructureCreateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkAccelerationStructureCreateInfoNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureCreateInfoNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkAccelerationStructureCreateInfoNV mallocStack() {
        return VkAccelerationStructureCreateInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAccelerationStructureCreateInfoNV callocStack() {
        return VkAccelerationStructureCreateInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAccelerationStructureCreateInfoNV mallocStack(MemoryStack stack) {
        return VkAccelerationStructureCreateInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkAccelerationStructureCreateInfoNV callocStack(MemoryStack stack) {
        return VkAccelerationStructureCreateInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkAccelerationStructureCreateInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkAccelerationStructureCreateInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAccelerationStructureCreateInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAccelerationStructureCreateInfoNV.calloc(capacity, stack);
    }

    public static VkAccelerationStructureCreateInfoNV malloc(MemoryStack stack) {
        return new VkAccelerationStructureCreateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureCreateInfoNV calloc(MemoryStack stack) {
        return new VkAccelerationStructureCreateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long ncompactedSize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)COMPACTEDSIZE));
    }

    public static VkAccelerationStructureInfoNV ninfo(long struct) {
        return VkAccelerationStructureInfoNV.create(struct + (long)INFO);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ncompactedSize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)COMPACTEDSIZE), (long)value);
    }

    public static void ninfo(long struct, VkAccelerationStructureInfoNV value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)INFO), (long)VkAccelerationStructureInfoNV.SIZEOF);
    }

    public static void validate(long struct) {
        VkAccelerationStructureInfoNV.validate(struct + (long)INFO);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureCreateInfoNV.__struct((Struct.Member[])new Struct.Member[]{VkAccelerationStructureCreateInfoNV.__member((int)4), VkAccelerationStructureCreateInfoNV.__member((int)POINTER_SIZE), VkAccelerationStructureCreateInfoNV.__member((int)8), VkAccelerationStructureCreateInfoNV.__member((int)VkAccelerationStructureInfoNV.SIZEOF, (int)VkAccelerationStructureInfoNV.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        COMPACTEDSIZE = layout.offsetof(2);
        INFO = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureCreateInfoNV ELEMENT_FACTORY = VkAccelerationStructureCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkAccelerationStructureCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAccelerationStructureCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAccelerationStructureCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long compactedSize() {
            return VkAccelerationStructureCreateInfoNV.ncompactedSize(this.address());
        }

        public VkAccelerationStructureInfoNV info() {
            return VkAccelerationStructureCreateInfoNV.ninfo(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAccelerationStructureCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000165001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAccelerationStructureCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkOpaqueCaptureDescriptorDataCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer compactedSize(@NativeType(value="VkDeviceSize") long value) {
            VkAccelerationStructureCreateInfoNV.ncompactedSize(this.address(), value);
            return this;
        }

        public Buffer info(VkAccelerationStructureInfoNV value) {
            VkAccelerationStructureCreateInfoNV.ninfo(this.address(), value);
            return this;
        }

        public Buffer info(Consumer<VkAccelerationStructureInfoNV> consumer) {
            consumer.accept(this.info());
            return this;
        }
    }
}

